/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.runtime.UpdateProcessInstanceSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.rest.dto.SuspensionStateDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class ProcessInstanceSuspensionStateDto
extends SuspensionStateDto {
    private String processInstanceId;
    private String processDefinitionId;
    private String processDefinitionKey;
    private String processDefinitionTenantId;
    private boolean processDefinitionWithoutTenantId;

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public void setProcessDefinitionTenantId(String processDefinitionTenantId) {
        this.processDefinitionTenantId = processDefinitionTenantId;
    }

    public void setProcessDefinitionWithoutTenantId(boolean processDefinitionWithoutTenantId) {
        this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
    }

    @Override
    public void updateSuspensionState(ProcessEngine engine) {
        int params = (this.processInstanceId != null ? 1 : 0) + (this.processDefinitionId != null ? 1 : 0) + (this.processDefinitionKey != null ? 1 : 0);
        if (params > 1) {
            String message = "Only one of processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        if (params == 0) {
            String message = "Either processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        UpdateProcessInstanceSuspensionStateBuilderImpl updateSuspensionStateBuilder = (UpdateProcessInstanceSuspensionStateBuilderImpl)engine.getRuntimeService().updateProcessInstanceSuspensionState();
        if (this.processInstanceId != null) {
            updateSuspensionStateBuilder.byProcessInstanceId(this.processInstanceId);
        } else if (this.processDefinitionId != null) {
            updateSuspensionStateBuilder.byProcessDefinitionId(this.processDefinitionId);
        } else if (this.processDefinitionKey != null) {
            updateSuspensionStateBuilder.byProcessDefinitionKey(this.processDefinitionKey);
            if (this.processDefinitionTenantId != null) {
                updateSuspensionStateBuilder.processDefinitionTenantId(this.processDefinitionTenantId);
            } else if (this.processDefinitionWithoutTenantId) {
                updateSuspensionStateBuilder.processDefinitionWithoutTenantId();
            }
        }
        if (this.getSuspended()) {
            updateSuspensionStateBuilder.suspend();
        } else {
            updateSuspensionStateBuilder.activate();
        }
    }
}

