/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.rest.MessageRestService;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.message.CorrelationMessageDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.runtime.MessageCorrelationBuilder;
import org.camunda.bpm.engine.variable.VariableMap;

public class MessageRestServiceImpl
extends AbstractRestProcessEngineAware
implements MessageRestService {
    public MessageRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public void deliverMessage(CorrelationMessageDto messageDto) {
        if (messageDto.getMessageName() == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No message name supplied");
        }
        if (messageDto.getTenantId() != null && messageDto.isWithoutTenantId()) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Parameter 'tenantId' cannot be used together with parameter 'withoutTenantId'.");
        }
        try {
            MessageCorrelationBuilder correlation = this.createMessageCorrelationBuilder(messageDto);
            if (!messageDto.isAll()) {
                correlation.correlate();
            } else {
                correlation.correlateAll();
            }
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot deliver message: %s", e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        catch (MismatchingMessageCorrelationException e) {
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)((Object)e));
        }
    }

    protected MessageCorrelationBuilder createMessageCorrelationBuilder(CorrelationMessageDto messageDto) {
        RuntimeService runtimeService = this.processEngine.getRuntimeService();
        ObjectMapper objectMapper = this.getObjectMapper();
        VariableMap correlationKeys = VariableValueDto.toMap(messageDto.getCorrelationKeys(), this.processEngine, objectMapper);
        VariableMap processVariables = VariableValueDto.toMap(messageDto.getProcessVariables(), this.processEngine, objectMapper);
        MessageCorrelationBuilder builder = runtimeService.createMessageCorrelation(messageDto.getMessageName()).setVariables((Map)processVariables).processInstanceBusinessKey(messageDto.getBusinessKey());
        if (correlationKeys != null && !correlationKeys.isEmpty()) {
            for (Map.Entry correlationKey : correlationKeys.entrySet()) {
                String name = (String)correlationKey.getKey();
                Object value = correlationKey.getValue();
                builder.processInstanceVariableEquals(name, value);
            }
        }
        if (messageDto.getTenantId() != null) {
            builder.tenantId(messageDto.getTenantId());
        } else if (messageDto.isWithoutTenantId()) {
            builder.withoutTenantId();
        }
        String processInstanceId = messageDto.getProcessInstanceId();
        if (processInstanceId != null) {
            builder.processInstanceId(processInstanceId);
        }
        return builder;
    }
}

