/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.migration.MigratingProcessInstanceValidationException;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanValidationException;
import org.camunda.bpm.engine.rest.MigrationRestService;
import org.camunda.bpm.engine.rest.dto.migration.MigrationExecutionDto;
import org.camunda.bpm.engine.rest.dto.migration.MigrationPlanDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;

public class MigrationRestServiceImpl
extends AbstractRestProcessEngineAware
implements MigrationRestService {
    public MigrationRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public MigrationPlanDto generateMigrationPlan(MigrationPlanDto initialMigrationPlan) {
        RuntimeService runtimeService = this.processEngine.getRuntimeService();
        String sourceProcessDefinitionId = initialMigrationPlan.getSourceProcessDefinitionId();
        String targetProcessDefinitionId = initialMigrationPlan.getTargetProcessDefinitionId();
        try {
            MigrationPlan migrationPlan = runtimeService.createMigrationPlan(sourceProcessDefinitionId, targetProcessDefinitionId).mapEqualActivities().build();
            return MigrationPlanDto.from(migrationPlan);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), e.getMessage());
        }
    }

    @Override
    public void executeMigrationPlan(MigrationExecutionDto migrationExecution) {
        MigrationPlanDto migrationPlanDto = migrationExecution.getMigrationPlan();
        List<String> processInstanceIds = migrationExecution.getProcessInstanceIds();
        try {
            MigrationPlan migrationPlan = MigrationPlanDto.toMigrationPlan(this.processEngine, migrationPlanDto);
            this.processEngine.getRuntimeService().newMigration(migrationPlan).processInstanceIds(processInstanceIds).execute();
        }
        catch (MigrationPlanValidationException e) {
            throw e;
        }
        catch (MigratingProcessInstanceValidationException e) {
            throw e;
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), e.getMessage());
        }
    }
}

