/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.batch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.batch.BatchStatisticsQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;

public class BatchStatisticsQueryDto
extends AbstractQueryDto<BatchStatisticsQuery> {
    private static final String SORT_BY_BATCH_ID_VALUE = "batchId";
    protected String batchId;
    protected String type;
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();

    public BatchStatisticsQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="batchId")
    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @CamundaQueryParam(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected BatchStatisticsQuery createNewQuery(ProcessEngine engine) {
        return engine.getManagementService().createBatchStatisticsQuery();
    }

    @Override
    protected void applyFilters(BatchStatisticsQuery query) {
        if (this.batchId != null) {
            query.batchId(this.batchId);
        }
        if (this.type != null) {
            query.type(this.type);
        }
    }

    @Override
    protected void applySortBy(BatchStatisticsQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_BATCH_ID_VALUE)) {
            query.orderById();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_BATCH_ID_VALUE);
    }
}

