/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history.batch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.batch.history.HistoricBatchQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;

public class HistoricBatchQueryDto
extends AbstractQueryDto<HistoricBatchQuery> {
    private static final String SORT_BY_BATCH_ID_VALUE = "batchId";
    private static final String SORT_BY_BATCH_START_TIME_VALUE = "startTime";
    private static final String SORT_BY_BATCH_END_TIME_VALUE = "endTime";
    protected String batchId;
    protected String type;
    protected Boolean completed;
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();

    public HistoricBatchQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="batchId")
    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @CamundaQueryParam(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @CamundaQueryParam(value="completed", converter=BooleanConverter.class)
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricBatchQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricBatchQuery();
    }

    @Override
    protected void applyFilters(HistoricBatchQuery query) {
        if (this.batchId != null) {
            query.batchId(this.batchId);
        }
        if (this.type != null) {
            query.type(this.type);
        }
        if (this.completed != null) {
            query.completed(this.completed.booleanValue());
        }
    }

    @Override
    protected void applySortBy(HistoricBatchQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_BATCH_ID_VALUE)) {
            query.orderById();
        }
        if (sortBy.equals(SORT_BY_BATCH_START_TIME_VALUE)) {
            query.orderByStartTime();
        }
        if (sortBy.equals(SORT_BY_BATCH_END_TIME_VALUE)) {
            query.orderByEndTime();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_BATCH_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_BATCH_START_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_BATCH_END_TIME_VALUE);
    }
}

