/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.identity;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;

public class TenantQueryDto
extends AbstractQueryDto<TenantQuery> {
    private static final String SORT_BY_TENANT_ID_VALUE = "id";
    private static final String SORT_BY_TENANT_NAME_VALUE = "name";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String id;
    protected String name;
    protected String nameLike;

    public TenantQueryDto() {
    }

    public TenantQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @CamundaQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @CamundaQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected TenantQuery createNewQuery(ProcessEngine engine) {
        return engine.getIdentityService().createTenantQuery();
    }

    @Override
    protected void applyFilters(TenantQuery query) {
        if (this.id != null) {
            query.tenantId(this.id);
        }
        if (this.name != null) {
            query.tenantName(this.name);
        }
        if (this.nameLike != null) {
            query.tenantNameLike(this.nameLike);
        }
    }

    @Override
    protected void applySortBy(TenantQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_TENANT_ID_VALUE)) {
            query.orderByTenantId();
        } else if (sortBy.equals(SORT_BY_TENANT_NAME_VALUE)) {
            query.orderByTenantName();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_NAME_VALUE);
    }
}

