/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.batch.impl;

import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.batch.BatchResource;

public class BatchResourceImpl
implements BatchResource {
    protected ProcessEngine processEngine;
    protected String batchId;

    public BatchResourceImpl(ProcessEngine processEngine, String batchId) {
        this.processEngine = processEngine;
        this.batchId = batchId;
    }

    @Override
    public BatchDto getBatch() {
        Batch batch = (Batch)this.processEngine.getManagementService().createBatchQuery().batchId(this.batchId).singleResult();
        if (batch == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Batch with id '" + this.batchId + "' does not exist");
        }
        return BatchDto.fromBatch(batch);
    }

    @Override
    public void deleteBatch(boolean cascade) {
        try {
            this.processEngine.getManagementService().deleteBatch(this.batchId, cascade);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Unable to delete batch with id '" + this.batchId + "'");
        }
    }
}

