/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.runtime.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.rest.dto.runtime.CaseExecutionDto;
import org.camunda.bpm.engine.rest.dto.runtime.CaseExecutionTriggerDto;
import org.camunda.bpm.engine.rest.dto.runtime.TriggerVariableValueDto;
import org.camunda.bpm.engine.rest.dto.runtime.VariableNameDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.sub.VariableResource;
import org.camunda.bpm.engine.rest.sub.runtime.CaseExecutionResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.CaseExecutionVariablesResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.LocalCaseExecutionVariablesResource;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionCommandBuilder;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class CaseExecutionResourceImpl
implements CaseExecutionResource {
    protected ProcessEngine engine;
    protected String caseExecutionId;
    protected ObjectMapper objectMapper;

    public CaseExecutionResourceImpl(ProcessEngine engine, String caseExecutionId, ObjectMapper objectMapper) {
        this.engine = engine;
        this.caseExecutionId = caseExecutionId;
        this.objectMapper = objectMapper;
    }

    @Override
    public CaseExecutionDto getCaseExecution() {
        CaseService caseService = this.engine.getCaseService();
        CaseExecution execution = (CaseExecution)caseService.createCaseExecutionQuery().caseExecutionId(this.caseExecutionId).singleResult();
        if (execution == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Case execution with id " + this.caseExecutionId + " does not exist.");
        }
        CaseExecutionDto result = CaseExecutionDto.fromCaseExecution(execution);
        return result;
    }

    @Override
    public void manualStart(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseExecutionId);
            this.initializeCommand(commandBuilder, triggerDto, "start manually");
            commandBuilder.manualStart();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException("manualStart", Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException("manualStart", Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException("manualStart", Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException("manualStart", Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    @Override
    public void disable(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseExecutionId);
            this.initializeCommand(commandBuilder, triggerDto, "disable");
            commandBuilder.disable();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException("disable", Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException("disable", Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException("disable", Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException("disable", Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    @Override
    public void reenable(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseExecutionId);
            this.initializeCommand(commandBuilder, triggerDto, "reenable");
            commandBuilder.reenable();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException("reenable", Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException("reenable", Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException("reenable", Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException("reenable", Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    @Override
    public void complete(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseExecutionId);
            this.initializeCommand(commandBuilder, triggerDto, "complete");
            commandBuilder.complete();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException("complete", Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException("complete", Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException("complete", Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException("complete", Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    protected InvalidRequestException createInvalidRequestException(String transition, Response.Status status, ProcessEngineException cause) {
        String errorMessage = String.format("Cannot %s case execution %s: %s", transition, this.caseExecutionId, cause.getMessage());
        return new InvalidRequestException(status, (Exception)((Object)cause), errorMessage);
    }

    protected RestException createRestException(String transition, Response.Status status, ProcessEngineException cause) {
        String errorMessage = String.format("Cannot %s case execution %s: %s", transition, this.caseExecutionId, cause.getMessage());
        return new RestException(status, (Exception)((Object)cause), errorMessage);
    }

    protected void initializeCommand(CaseExecutionCommandBuilder commandBuilder, CaseExecutionTriggerDto triggerDto, String transition) {
        List<VariableNameDto> deletions;
        Map<String, TriggerVariableValueDto> variables = triggerDto.getVariables();
        if (variables != null && !variables.isEmpty()) {
            this.initializeCommandWithVariables(commandBuilder, variables, transition);
        }
        if ((deletions = triggerDto.getDeletions()) != null && !deletions.isEmpty()) {
            this.initializeCommandWithDeletions(commandBuilder, deletions, transition);
        }
    }

    protected void initializeCommandWithVariables(CaseExecutionCommandBuilder commandBuilder, Map<String, TriggerVariableValueDto> variables, String transition) {
        for (String variableName : variables.keySet()) {
            try {
                TriggerVariableValueDto variableValue = variables.get(variableName);
                TypedValue typedValue = variableValue.toTypedValue(this.engine, this.objectMapper);
                if (variableValue.isLocal()) {
                    commandBuilder.setVariableLocal(variableName, (Object)typedValue);
                    continue;
                }
                commandBuilder.setVariable(variableName, (Object)typedValue);
            }
            catch (RestException e) {
                String errorMessage = String.format("Cannot %s case execution %s due to invalid variable %s: %s", transition, this.caseExecutionId, variableName, e.getMessage());
                throw new RestException(e.getStatus(), e, errorMessage);
            }
        }
    }

    protected void initializeCommandWithDeletions(CaseExecutionCommandBuilder commandBuilder, List<VariableNameDto> deletions, String transition) {
        for (VariableNameDto variableName : deletions) {
            if (variableName.isLocal()) {
                commandBuilder.removeVariableLocal(variableName.getName());
                continue;
            }
            commandBuilder.removeVariable(variableName.getName());
        }
    }

    @Override
    public VariableResource getVariablesLocal() {
        return new LocalCaseExecutionVariablesResource(this.engine, this.caseExecutionId, this.objectMapper);
    }

    @Override
    public VariableResource getVariables() {
        return new CaseExecutionVariablesResource(this.engine, this.caseExecutionId, this.objectMapper);
    }
}

