/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.ReportResult;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.converter.ReportResultToCsvConverter;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceReportDto;
import org.camunda.bpm.engine.rest.dto.history.ReportResultDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.history.HistoricProcessInstanceRestService;
import org.camunda.bpm.engine.rest.sub.history.HistoricProcessInstanceResource;
import org.camunda.bpm.engine.rest.sub.history.impl.HistoricProcessInstanceResourceImpl;

public class HistoricProcessInstanceRestServiceImpl
implements HistoricProcessInstanceRestService {
    public static final MediaType APPLICATION_CSV_TYPE = new MediaType("application", "csv");
    public static final MediaType TEXT_CSV_TYPE = new MediaType("text", "csv");
    public static final List<Variant> VARIANTS = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, APPLICATION_CSV_TYPE, TEXT_CSV_TYPE}).add().build();
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricProcessInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricProcessInstanceResource getHistoricProcessInstance(String processInstanceId) {
        return new HistoricProcessInstanceResourceImpl(this.processEngine, processInstanceId);
    }

    @Override
    public List<HistoricProcessInstanceDto> getHistoricProcessInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricProcessInstanceQueryDto queryHistoriProcessInstanceDto = new HistoricProcessInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricProcessInstances(queryHistoriProcessInstanceDto, firstResult, maxResults);
    }

    @Override
    public List<HistoricProcessInstanceDto> queryHistoricProcessInstances(HistoricProcessInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricProcessInstanceQuery query = (HistoricProcessInstanceQuery)queryDto.toQuery(this.processEngine);
        List<HistoricProcessInstance> matchingHistoricProcessInstances = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<HistoricProcessInstanceDto> historicProcessInstanceDtoResults = new ArrayList<HistoricProcessInstanceDto>();
        for (HistoricProcessInstance historicProcessInstance : matchingHistoricProcessInstances) {
            HistoricProcessInstanceDto resultHistoricProcessInstanceDto = HistoricProcessInstanceDto.fromHistoricProcessInstance(historicProcessInstance);
            historicProcessInstanceDtoResults.add(resultHistoricProcessInstanceDto);
        }
        return historicProcessInstanceDtoResults;
    }

    private List<HistoricProcessInstance> executePaginatedQuery(HistoricProcessInstanceQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getHistoricProcessInstancesCount(UriInfo uriInfo) {
        HistoricProcessInstanceQueryDto queryDto = new HistoricProcessInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricProcessInstancesCount(queryDto);
    }

    @Override
    public CountResultDto queryHistoricProcessInstancesCount(HistoricProcessInstanceQueryDto queryDto) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricProcessInstanceQuery query = (HistoricProcessInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    protected List<ReportResult> queryHistoricProcessInstanceReport(UriInfo uriInfo) {
        HistoricProcessInstanceReportDto reportDto = new HistoricProcessInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return reportDto.executeReport(this.processEngine);
    }

    @Override
    public Response getHistoricProcessInstancesReport(UriInfo uriInfo, Request request) {
        Variant variant = request.selectVariant(VARIANTS);
        if (variant != null) {
            MediaType mediaType = variant.getMediaType();
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
                List<ReportResultDto> result = this.getReportResultAsJson(uriInfo);
                return Response.ok(result, (MediaType)mediaType).build();
            }
            if (APPLICATION_CSV_TYPE.equals((Object)mediaType) || TEXT_CSV_TYPE.equals((Object)mediaType)) {
                String csv = this.getReportResultAsCsv(uriInfo);
                return Response.ok((Object)csv, (MediaType)mediaType).header("Content-Disposition", (Object)"attachment; filename=process-instance-report.csv").build();
            }
        }
        throw new InvalidRequestException(Response.Status.NOT_ACCEPTABLE, "No acceptable content-type found");
    }

    protected List<ReportResultDto> getReportResultAsJson(UriInfo uriInfo) {
        List<ReportResult> reports = this.queryHistoricProcessInstanceReport(uriInfo);
        ArrayList<ReportResultDto> result = new ArrayList<ReportResultDto>();
        for (ReportResult report : reports) {
            result.add(ReportResultDto.fromReportResult(report));
        }
        return result;
    }

    protected String getReportResultAsCsv(UriInfo uriInfo) {
        List<ReportResult> reports = this.queryHistoricProcessInstanceReport(uriInfo);
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        String reportType = (String)queryParameters.getFirst((Object)"reportType");
        return ReportResultToCsvConverter.convertReportResult(reports, reportType);
    }
}

