/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub;

import java.io.ByteArrayInputStream;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public abstract class AbstractResourceProvider<T extends Query<?, U>, U, DTO> {
    protected String id;
    protected ProcessEngine engine;

    public AbstractResourceProvider(String detailId, ProcessEngine engine) {
        this.id = detailId;
        this.engine = engine;
    }

    @GET
    @Produces(value={"application/json"})
    public DTO getResource(@QueryParam(value="deserializeValue") @DefaultValue(value="true") boolean deserializeObjectValue) {
        Object variableInstance = this.baseQueryForVariable(deserializeObjectValue).singleResult();
        if (variableInstance != null) {
            return this.transformToDto(variableInstance);
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, this.getResourceNameForErrorMessage() + " with Id '" + this.id + "' does not exist.");
    }

    @GET
    @Path(value="/data")
    public Response getResourceBinary() {
        Object queryResult = this.baseQueryForBinaryVariable().singleResult();
        if (queryResult != null) {
            TypedValue variableInstance = this.transformQueryResultIntoTypedValue(queryResult);
            if (ValueType.BYTES.equals(variableInstance.getType())) {
                return this.responseForByteVariable(variableInstance);
            }
            if (ValueType.FILE.equals(variableInstance.getType())) {
                return this.responseForFileVariable((FileValue)variableInstance);
            }
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, String.format("Value of %s %s is not a binary value.", this.getResourceNameForErrorMessage(), this.id));
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, this.getResourceNameForErrorMessage() + " with Id '" + this.id + "' does not exist.");
    }

    protected Response responseForFileVariable(FileValue fileValue) {
        String type;
        String string = type = fileValue.getMimeType() != null ? fileValue.getMimeType() : "application/octet-stream";
        if (fileValue.getEncoding() != null) {
            type = type + "; charset=" + fileValue.getEncoding();
        }
        return Response.ok((Object)fileValue.getValue(), (String)type).header("Content-Disposition", (Object)("attachment; filename=" + fileValue.getFilename())).build();
    }

    protected Response responseForByteVariable(TypedValue variableInstance) {
        byte[] valueBytes = (byte[])variableInstance.getValue();
        if (valueBytes == null) {
            valueBytes = new byte[]{};
        }
        return Response.ok((Object)new ByteArrayInputStream(valueBytes), (String)"application/octet-stream").build();
    }

    protected String getId() {
        return this.id;
    }

    protected ProcessEngine getEngine() {
        return this.engine;
    }

    protected abstract Query<T, U> baseQueryForBinaryVariable();

    protected abstract Query<T, U> baseQueryForVariable(boolean var1);

    protected abstract TypedValue transformQueryResultIntoTypedValue(U var1);

    protected abstract DTO transformToDto(U var1);

    protected abstract String getResourceNameForErrorMessage();
}

