/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.rest.MessageRestService;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.message.CorrelationMessageDto;
import org.camunda.bpm.engine.rest.dto.message.MessageCorrelationResultDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.runtime.MessageCorrelationBuilder;
import org.camunda.bpm.engine.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.variable.VariableMap;

public class MessageRestServiceImpl
extends AbstractRestProcessEngineAware
implements MessageRestService {
    public MessageRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public Response deliverMessage(CorrelationMessageDto messageDto) {
        if (messageDto.getMessageName() == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No message name supplied");
        }
        if (messageDto.getTenantId() != null && messageDto.isWithoutTenantId()) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Parameter 'tenantId' cannot be used together with parameter 'withoutTenantId'.");
        }
        ArrayList<MessageCorrelationResultDto> resultDtos = new ArrayList<MessageCorrelationResultDto>();
        try {
            MessageCorrelationBuilder correlation = this.createMessageCorrelationBuilder(messageDto);
            if (!messageDto.isAll()) {
                MessageCorrelationResult result = correlation.correlateWithResult();
                resultDtos.add(MessageCorrelationResultDto.fromMessageCorrelationResult(result));
            } else {
                List results = correlation.correlateAllWithResult();
                for (MessageCorrelationResult result : results) {
                    resultDtos.add(MessageCorrelationResultDto.fromMessageCorrelationResult(result));
                }
            }
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot deliver message: %s", e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        catch (MismatchingMessageCorrelationException e) {
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)((Object)e));
        }
        return this.createResponse(resultDtos, messageDto);
    }

    protected Response createResponse(List<MessageCorrelationResultDto> resultDtos, CorrelationMessageDto messageDto) {
        Response.ResponseBuilder response = Response.noContent();
        if (messageDto.isResultEnabled()) {
            response = Response.ok(resultDtos, (String)"application/json");
        }
        return response.build();
    }

    protected MessageCorrelationBuilder createMessageCorrelationBuilder(CorrelationMessageDto messageDto) {
        RuntimeService runtimeService = this.processEngine.getRuntimeService();
        ObjectMapper objectMapper = this.getObjectMapper();
        VariableMap correlationKeys = VariableValueDto.toMap(messageDto.getCorrelationKeys(), this.processEngine, objectMapper);
        VariableMap processVariables = VariableValueDto.toMap(messageDto.getProcessVariables(), this.processEngine, objectMapper);
        MessageCorrelationBuilder builder = runtimeService.createMessageCorrelation(messageDto.getMessageName());
        if (processVariables != null) {
            builder.setVariables((Map)processVariables);
        }
        if (messageDto.getBusinessKey() != null) {
            builder.processInstanceBusinessKey(messageDto.getBusinessKey());
        }
        if (correlationKeys != null && !correlationKeys.isEmpty()) {
            for (Map.Entry correlationKey : correlationKeys.entrySet()) {
                String name = (String)correlationKey.getKey();
                Object value = correlationKey.getValue();
                builder.processInstanceVariableEquals(name, value);
            }
        }
        if (messageDto.getTenantId() != null) {
            builder.tenantId(messageDto.getTenantId());
        } else if (messageDto.isWithoutTenantId()) {
            builder.withoutTenantId();
        }
        String processInstanceId = messageDto.getProcessInstanceId();
        if (processInstanceId != null) {
            builder.processInstanceId(processInstanceId);
        }
        return builder;
    }
}

