/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.ProcessInstanceRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceSuspensionStateDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.runtime.ProcessInstanceResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.ProcessInstanceResourceImpl;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;

public class ProcessInstanceRestServiceImpl
extends AbstractRestProcessEngineAware
implements ProcessInstanceRestService {
    public ProcessInstanceRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public List<ProcessInstanceDto> getProcessInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        ProcessInstanceQueryDto queryDto = new ProcessInstanceQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryProcessInstances(queryDto, firstResult, maxResults);
    }

    @Override
    public List<ProcessInstanceDto> queryProcessInstances(ProcessInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        ProcessInstanceQuery query = (ProcessInstanceQuery)queryDto.toQuery(engine);
        List<ProcessInstance> matchingInstances = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<ProcessInstanceDto> instanceResults = new ArrayList<ProcessInstanceDto>();
        for (ProcessInstance instance : matchingInstances) {
            ProcessInstanceDto resultInstance = ProcessInstanceDto.fromProcessInstance(instance);
            instanceResults.add(resultInstance);
        }
        return instanceResults;
    }

    private List<ProcessInstance> executePaginatedQuery(ProcessInstanceQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getProcessInstancesCount(UriInfo uriInfo) {
        ProcessInstanceQueryDto queryDto = new ProcessInstanceQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryProcessInstancesCount(queryDto);
    }

    @Override
    public CountResultDto queryProcessInstancesCount(ProcessInstanceQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        ProcessInstanceQuery query = (ProcessInstanceQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public ProcessInstanceResource getProcessInstance(String processInstanceId) {
        return new ProcessInstanceResourceImpl(this.getProcessEngine(), processInstanceId, this.getObjectMapper());
    }

    @Override
    public void updateSuspensionState(ProcessInstanceSuspensionStateDto dto) {
        if (dto.getProcessInstanceId() != null) {
            String message = "Either processDefinitionId or processDefinitionKey can be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        dto.updateSuspensionState(this.getProcessEngine());
    }
}

