/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.task.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.form.FormData;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;
import org.camunda.bpm.engine.rest.dto.task.CompleteTaskDto;
import org.camunda.bpm.engine.rest.dto.task.FormDto;
import org.camunda.bpm.engine.rest.dto.task.IdentityLinkDto;
import org.camunda.bpm.engine.rest.dto.task.TaskDto;
import org.camunda.bpm.engine.rest.dto.task.UserIdDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.hal.Hal;
import org.camunda.bpm.engine.rest.hal.task.HalTask;
import org.camunda.bpm.engine.rest.sub.VariableResource;
import org.camunda.bpm.engine.rest.sub.task.TaskAttachmentResource;
import org.camunda.bpm.engine.rest.sub.task.TaskCommentResource;
import org.camunda.bpm.engine.rest.sub.task.TaskResource;
import org.camunda.bpm.engine.rest.sub.task.impl.LocalTaskVariablesResource;
import org.camunda.bpm.engine.rest.sub.task.impl.TaskAttachmentResourceImpl;
import org.camunda.bpm.engine.rest.sub.task.impl.TaskCommentResourceImpl;
import org.camunda.bpm.engine.rest.sub.task.impl.TaskVariablesResource;
import org.camunda.bpm.engine.rest.util.ApplicationContextPathUtil;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.variable.VariableMap;

public class TaskResourceImpl
implements TaskResource {
    public static final List<Variant> VARIANTS = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, Hal.APPLICATION_HAL_JSON_TYPE}).add().build();
    protected ProcessEngine engine;
    protected String taskId;
    protected String rootResourcePath;
    protected ObjectMapper objectMapper;

    public TaskResourceImpl(ProcessEngine engine, String taskId, String rootResourcePath, ObjectMapper objectMapper) {
        this.engine = engine;
        this.taskId = taskId;
        this.rootResourcePath = rootResourcePath;
        this.objectMapper = objectMapper;
    }

    @Override
    public void claim(UserIdDto dto) {
        TaskService taskService = this.engine.getTaskService();
        taskService.claim(this.taskId, dto.getUserId());
    }

    @Override
    public void unclaim() {
        this.engine.getTaskService().setAssignee(this.taskId, null);
    }

    @Override
    public void complete(CompleteTaskDto dto) {
        TaskService taskService = this.engine.getTaskService();
        try {
            VariableMap variables = VariableValueDto.toMap(dto.getVariables(), this.engine, this.objectMapper);
            taskService.complete(this.taskId, (Map)variables);
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot complete task %s: %s", this.taskId, e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot complete task %s: %s", this.taskId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
    }

    @Override
    public void submit(CompleteTaskDto dto) {
        FormService formService = this.engine.getFormService();
        try {
            VariableMap variables = VariableValueDto.toMap(dto.getVariables(), this.engine, this.objectMapper);
            formService.submitTaskForm(this.taskId, (Map)variables);
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot submit task form %s: %s", this.taskId, e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot submit task form %s: %s", this.taskId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
    }

    @Override
    public void delegate(UserIdDto delegatedUser) {
        this.engine.getTaskService().delegateTask(this.taskId, delegatedUser.getUserId());
    }

    @Override
    public Object getTask(Request request) {
        Variant variant = request.selectVariant(VARIANTS);
        if (variant != null) {
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.getJsonTask();
            }
            if (Hal.APPLICATION_HAL_JSON_TYPE.equals((Object)variant.getMediaType())) {
                return this.getHalTask();
            }
        }
        throw new InvalidRequestException(Response.Status.NOT_ACCEPTABLE, "No acceptable content-type found");
    }

    public TaskDto getJsonTask() {
        Task task = this.getTaskById(this.taskId);
        if (task == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "No matching task with id " + this.taskId);
        }
        return TaskDto.fromEntity(task);
    }

    public HalTask getHalTask() {
        Task task = this.getTaskById(this.taskId);
        if (task == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "No matching task with id " + this.taskId);
        }
        return HalTask.generate(task, this.engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FormDto getForm() {
        TaskFormData formData;
        FormService formService = this.engine.getFormService();
        Task task = this.getTaskById(this.taskId);
        try {
            formData = formService.getTaskFormData(this.taskId);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Cannot get form for task " + this.taskId);
        }
        FormDto dto = FormDto.fromFormData((FormData)formData);
        if ((dto.getKey() == null || dto.getKey().isEmpty()) && formData != null && formData.getFormFields() != null && !formData.getFormFields().isEmpty()) {
            dto.setKey("embedded:engine://engine/:engine/task/" + this.taskId + "/rendered-form");
        }
        IdentityService identityService = this.engine.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        try {
            identityService.clearAuthentication();
            String processDefinitionId = task.getProcessDefinitionId();
            String caseDefinitionId = task.getCaseDefinitionId();
            if (processDefinitionId != null) {
                dto.setContextPath(ApplicationContextPathUtil.getApplicationPathByProcessDefinitionId(this.engine, processDefinitionId));
            } else if (caseDefinitionId != null) {
                dto.setContextPath(ApplicationContextPathUtil.getApplicationPathByCaseDefinitionId(this.engine, caseDefinitionId));
            }
        }
        finally {
            identityService.setAuthentication(currentAuthentication);
        }
        return dto;
    }

    @Override
    public String getRenderedForm() {
        FormService formService = this.engine.getFormService();
        Object renderedTaskForm = formService.getRenderedTaskForm(this.taskId);
        if (renderedTaskForm != null) {
            return renderedTaskForm.toString();
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "No matching rendered form for task with the id " + this.taskId + " found.");
    }

    @Override
    public void resolve(CompleteTaskDto dto) {
        TaskService taskService = this.engine.getTaskService();
        try {
            VariableMap variables = VariableValueDto.toMap(dto.getVariables(), this.engine, this.objectMapper);
            taskService.resolveTask(this.taskId, (Map)variables);
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot resolve task %s: %s", this.taskId, e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
    }

    protected Task getTaskById(String id) {
        return (Task)this.engine.getTaskService().createTaskQuery().taskId(id).initializeFormKeys().singleResult();
    }

    @Override
    public void setAssignee(UserIdDto dto) {
        TaskService taskService = this.engine.getTaskService();
        taskService.setAssignee(this.taskId, dto.getUserId());
    }

    @Override
    public List<IdentityLinkDto> getIdentityLinks(String type) {
        TaskService taskService = this.engine.getTaskService();
        List identityLinks = taskService.getIdentityLinksForTask(this.taskId);
        ArrayList<IdentityLinkDto> result = new ArrayList<IdentityLinkDto>();
        for (IdentityLink link : identityLinks) {
            if (type != null && !type.equals(link.getType())) continue;
            result.add(IdentityLinkDto.fromIdentityLink(link));
        }
        return result;
    }

    @Override
    public void addIdentityLink(IdentityLinkDto identityLink) {
        TaskService taskService = this.engine.getTaskService();
        identityLink.validate();
        if (identityLink.getUserId() != null) {
            taskService.addUserIdentityLink(this.taskId, identityLink.getUserId(), identityLink.getType());
        } else if (identityLink.getGroupId() != null) {
            taskService.addGroupIdentityLink(this.taskId, identityLink.getGroupId(), identityLink.getType());
        }
    }

    @Override
    public void deleteIdentityLink(IdentityLinkDto identityLink) {
        TaskService taskService = this.engine.getTaskService();
        identityLink.validate();
        if (identityLink.getUserId() != null) {
            taskService.deleteUserIdentityLink(this.taskId, identityLink.getUserId(), identityLink.getType());
        } else if (identityLink.getGroupId() != null) {
            taskService.deleteGroupIdentityLink(this.taskId, identityLink.getGroupId(), identityLink.getType());
        }
    }

    @Override
    public TaskCommentResource getTaskCommentResource() {
        return new TaskCommentResourceImpl(this.engine, this.taskId, this.rootResourcePath);
    }

    @Override
    public TaskAttachmentResource getAttachmentResource() {
        return new TaskAttachmentResourceImpl(this.engine, this.taskId, this.rootResourcePath);
    }

    @Override
    public VariableResource getLocalVariables() {
        return new LocalTaskVariablesResource(this.engine, this.taskId, this.objectMapper);
    }

    @Override
    public VariableResource getVariables() {
        return new TaskVariablesResource(this.engine, this.taskId, this.objectMapper);
    }

    @Override
    public Map<String, VariableValueDto> getFormVariables(String variableNames, boolean deserializeValues) {
        FormService formService = this.engine.getFormService();
        Object formVariables = null;
        if (variableNames != null) {
            StringListConverter stringListConverter = new StringListConverter();
            formVariables = stringListConverter.convertQueryParameterToType(variableNames);
        }
        VariableMap startFormVariables = formService.getTaskFormVariables(this.taskId, formVariables, deserializeValues);
        return VariableValueDto.fromVariableMap(startFormVariables);
    }

    @Override
    public void updateTask(TaskDto taskDto) {
        TaskService taskService = this.engine.getTaskService();
        Task task = this.getTaskById(this.taskId);
        if (task == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "No matching task with id " + this.taskId);
        }
        taskDto.updateTask(task);
        taskService.saveTask(task);
    }

    @Override
    public void deleteTask(String id) {
        TaskService taskService = this.engine.getTaskService();
        try {
            taskService.deleteTask(id);
        }
        catch (NotValidException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Could not delete task: " + e.getMessage());
        }
    }
}

