/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryBuilder;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryTopicBuilder;
import org.camunda.bpm.engine.rest.ExternalTaskRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.externaltask.ExternalTaskDto;
import org.camunda.bpm.engine.rest.dto.externaltask.ExternalTaskQueryDto;
import org.camunda.bpm.engine.rest.dto.externaltask.FetchExternalTasksDto;
import org.camunda.bpm.engine.rest.dto.externaltask.LockedExternalTaskDto;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.externaltask.ExternalTaskResource;
import org.camunda.bpm.engine.rest.sub.externaltask.impl.ExternalTaskResourceImpl;

public class ExternalTaskRestServiceImpl
extends AbstractRestProcessEngineAware
implements ExternalTaskRestService {
    public ExternalTaskRestServiceImpl(String processEngine, ObjectMapper objectMapper) {
        super(processEngine, objectMapper);
    }

    @Override
    public List<ExternalTaskDto> getExternalTasks(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        ExternalTaskQueryDto queryDto = new ExternalTaskQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryExternalTasks(queryDto, firstResult, maxResults);
    }

    @Override
    public List<ExternalTaskDto> queryExternalTasks(ExternalTaskQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        ExternalTaskQuery query = (ExternalTaskQuery)queryDto.toQuery(engine);
        List<ExternalTask> matchingTasks = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<ExternalTaskDto> taskResults = new ArrayList<ExternalTaskDto>();
        for (ExternalTask task : matchingTasks) {
            ExternalTaskDto resultInstance = ExternalTaskDto.fromExternalTask(task);
            taskResults.add(resultInstance);
        }
        return taskResults;
    }

    protected List<ExternalTask> executePaginatedQuery(ExternalTaskQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getExternalTasksCount(UriInfo uriInfo) {
        ExternalTaskQueryDto queryDto = new ExternalTaskQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryExternalTasksCount(queryDto);
    }

    @Override
    public CountResultDto queryExternalTasksCount(ExternalTaskQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        ExternalTaskQuery query = (ExternalTaskQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public List<LockedExternalTaskDto> fetchAndLock(FetchExternalTasksDto fetchingDto) {
        ExternalTaskQueryBuilder fetchBuilder = this.processEngine.getExternalTaskService().fetchAndLock(fetchingDto.getMaxTasks(), fetchingDto.getWorkerId(), fetchingDto.isUsePriority());
        if (fetchingDto.getTopics() != null) {
            for (FetchExternalTasksDto.FetchExternalTaskTopicDto topicDto : fetchingDto.getTopics()) {
                ExternalTaskQueryTopicBuilder topicFetchBuilder = fetchBuilder.topic(topicDto.getTopicName(), topicDto.getLockDuration());
                if (topicDto.getVariables() != null) {
                    topicFetchBuilder = topicFetchBuilder.variables(topicDto.getVariables());
                }
                if (topicDto.isDeserializeValues()) {
                    topicFetchBuilder = topicFetchBuilder.enableCustomObjectDeserialization();
                }
                fetchBuilder = topicFetchBuilder;
            }
        }
        List tasks = fetchBuilder.execute();
        return LockedExternalTaskDto.fromLockedExternalTasks(tasks);
    }

    @Override
    public ExternalTaskResource getExternalTask(String externalTaskId) {
        return new ExternalTaskResourceImpl(this.getProcessEngine(), externalTaskId, this.getObjectMapper());
    }
}

