/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.rest.dto.history.HistoricDecisionInputInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricDecisionOutputInstanceDto;

public class HistoricDecisionInstanceDto {
    protected String id;
    protected String decisionDefinitionId;
    protected String decisionDefinitionKey;
    protected String decisionDefinitionName;
    protected Date evaluationTime;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processInstanceId;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected String caseInstanceId;
    protected String activityId;
    protected String activityInstanceId;
    protected String userId;
    protected List<HistoricDecisionInputInstanceDto> inputs;
    protected List<HistoricDecisionOutputInstanceDto> outputs;
    protected Double collectResultValue;
    protected String rootDecisionInstanceId;
    protected String decisionRequirementsDefinitionId;
    protected String decisionRequirementsDefinitionKey;
    protected String tenantId;

    public String getId() {
        return this.id;
    }

    public String getDecisionDefinitionId() {
        return this.decisionDefinitionId;
    }

    public String getDecisionDefinitionKey() {
        return this.decisionDefinitionKey;
    }

    public String getDecisionDefinitionName() {
        return this.decisionDefinitionName;
    }

    public Date getEvaluationTime() {
        return this.evaluationTime;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public String getUserId() {
        return this.userId;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<HistoricDecisionInputInstanceDto> getInputs() {
        return this.inputs;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<HistoricDecisionOutputInstanceDto> getOutputs() {
        return this.outputs;
    }

    public Double getCollectResultValue() {
        return this.collectResultValue;
    }

    public String getRootDecisionInstanceId() {
        return this.rootDecisionInstanceId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getDecisionRequirementsDefinitionId() {
        return this.decisionRequirementsDefinitionId;
    }

    public String getDecisionRequirementsDefinitionKey() {
        return this.decisionRequirementsDefinitionKey;
    }

    public static HistoricDecisionInstanceDto fromHistoricDecisionInstance(HistoricDecisionInstance historicDecisionInstance) {
        HistoricDecisionInstanceDto dto = new HistoricDecisionInstanceDto();
        dto.id = historicDecisionInstance.getId();
        dto.decisionDefinitionId = historicDecisionInstance.getDecisionDefinitionId();
        dto.decisionDefinitionKey = historicDecisionInstance.getDecisionDefinitionKey();
        dto.decisionDefinitionName = historicDecisionInstance.getDecisionDefinitionName();
        dto.evaluationTime = historicDecisionInstance.getEvaluationTime();
        dto.processDefinitionId = historicDecisionInstance.getProcessDefinitionId();
        dto.processDefinitionKey = historicDecisionInstance.getProcessDefinitionKey();
        dto.processInstanceId = historicDecisionInstance.getProcessInstanceId();
        dto.caseDefinitionId = historicDecisionInstance.getCaseDefinitionId();
        dto.caseDefinitionKey = historicDecisionInstance.getCaseDefinitionKey();
        dto.caseInstanceId = historicDecisionInstance.getCaseInstanceId();
        dto.activityId = historicDecisionInstance.getActivityId();
        dto.activityInstanceId = historicDecisionInstance.getActivityInstanceId();
        dto.userId = historicDecisionInstance.getUserId();
        dto.collectResultValue = historicDecisionInstance.getCollectResultValue();
        dto.rootDecisionInstanceId = historicDecisionInstance.getRootDecisionInstanceId();
        dto.decisionRequirementsDefinitionId = historicDecisionInstance.getDecisionRequirementsDefinitionId();
        dto.decisionRequirementsDefinitionKey = historicDecisionInstance.getDecisionRequirementsDefinitionKey();
        dto.tenantId = historicDecisionInstance.getTenantId();
        try {
            ArrayList<HistoricDecisionInputInstanceDto> inputs = new ArrayList<HistoricDecisionInputInstanceDto>();
            for (HistoricDecisionInputInstance input : historicDecisionInstance.getInputs()) {
                HistoricDecisionInputInstanceDto inputDto = HistoricDecisionInputInstanceDto.fromHistoricDecisionInputInstance(input);
                inputs.add(inputDto);
            }
            dto.inputs = inputs;
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            ArrayList<HistoricDecisionOutputInstanceDto> outputs = new ArrayList<HistoricDecisionOutputInstanceDto>();
            for (HistoricDecisionOutputInstance output : historicDecisionInstance.getOutputs()) {
                HistoricDecisionOutputInstanceDto outputDto = HistoricDecisionOutputInstanceDto.fromHistoricDecisionOutputInstance(output);
                outputs.add(outputDto);
            }
            dto.outputs = outputs;
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        return dto;
    }
}

