/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.helper.EqualsList;
import org.camunda.bpm.engine.rest.helper.EqualsMap;
import org.camunda.bpm.engine.rest.helper.ErrorMessageHelper;
import org.camunda.bpm.engine.rest.helper.MockObjectValue;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.variable.EqualsNullValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsObjectValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsUntypedValue;
import org.camunda.bpm.engine.rest.util.VariablesBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.EventSubscriptionQuery;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.BooleanValue;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ExecutionRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String EXECUTION_URL = "/rest-test/execution/{id}";
    protected static final String SIGNAL_EXECUTION_URL = "/rest-test/execution/{id}/signal";
    protected static final String EXECUTION_LOCAL_VARIABLES_URL = "/rest-test/execution/{id}/localVariables";
    protected static final String SINGLE_EXECUTION_LOCAL_VARIABLE_URL = "/rest-test/execution/{id}/localVariables/{varId}";
    protected static final String SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL = "/rest-test/execution/{id}/localVariables/{varId}/data";
    protected static final String MESSAGE_SUBSCRIPTION_URL = "/rest-test/execution/{id}/messageSubscriptions/{messageName}";
    protected static final String TRIGGER_MESSAGE_SUBSCRIPTION_URL = "/rest-test/execution/{id}/messageSubscriptions/{messageName}/trigger";
    private RuntimeServiceImpl runtimeServiceMock;

    @Before
    public void setUpRuntimeData() {
        this.runtimeServiceMock = (RuntimeServiceImpl)Mockito.mock(RuntimeServiceImpl.class);
        Mockito.when((Object)this.runtimeServiceMock.getVariablesLocalTyped("anExecutionId", true)).thenReturn((Object)EXAMPLE_VARIABLES);
        this.mockEventSubscriptionQuery();
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.runtimeServiceMock);
    }

    private void mockEventSubscriptionQuery() {
        EventSubscription mockSubscription = MockProvider.createMockEventSubscription();
        EventSubscriptionQuery mockQuery = (EventSubscriptionQuery)Mockito.mock(EventSubscriptionQuery.class);
        Mockito.when((Object)this.runtimeServiceMock.createEventSubscriptionQuery()).thenReturn((Object)mockQuery);
        Mockito.when((Object)mockQuery.executionId((String)Matchers.eq((Object)"anExecutionId"))).thenReturn((Object)mockQuery);
        Mockito.when((Object)mockQuery.eventType((String)Matchers.eq((Object)"message"))).thenReturn((Object)mockQuery);
        Mockito.when((Object)mockQuery.eventName((String)Matchers.eq((Object)"anEvent"))).thenReturn((Object)mockQuery);
        Mockito.when((Object)mockQuery.singleResult()).thenReturn((Object)mockSubscription);
    }

    @Test
    public void testGetSingleExecution() {
        Execution mockExecution = MockProvider.createMockExecution();
        ExecutionQuery sampleExecutionQuery = (ExecutionQuery)Mockito.mock(ExecutionQuery.class);
        Mockito.when((Object)this.runtimeServiceMock.createExecutionQuery()).thenReturn((Object)sampleExecutionQuery);
        Mockito.when((Object)sampleExecutionQuery.executionId("anExecutionId")).thenReturn((Object)sampleExecutionQuery);
        Mockito.when((Object)sampleExecutionQuery.singleResult()).thenReturn((Object)mockExecution);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", CoreMatchers.equalTo((Object)"anExecutionId"), new Object[0]).body("ended", CoreMatchers.equalTo((Object)false), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)"aProcInstId"), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)"aTenantId"), new Object[0]).when().get(EXECUTION_URL, new Object[0]);
    }

    @Test
    public void testGetNonExistingExecution() {
        ExecutionQuery sampleExecutionQuery = (ExecutionQuery)Mockito.mock(ExecutionQuery.class);
        Mockito.when((Object)this.runtimeServiceMock.createExecutionQuery()).thenReturn((Object)sampleExecutionQuery);
        Mockito.when((Object)sampleExecutionQuery.executionId(Matchers.anyString())).thenReturn((Object)sampleExecutionQuery);
        Mockito.when((Object)sampleExecutionQuery.singleResult()).thenReturn(null);
        String nonExistingExecutionId = "aNonExistingInstanceId";
        RestAssured.given().pathParam("id", (Object)nonExistingExecutionId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Execution with id " + nonExistingExecutionId + " does not exist")), new Object[0]).when().get(EXECUTION_URL, new Object[0]);
    }

    @Test
    public void testSignalExecution() {
        String variableKey = "aKey";
        int variableValue = 123;
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SIGNAL_EXECUTION_URL, new Object[0]);
        HashMap<String, Object> expectedSignalVariables = new HashMap<String, Object>();
        expectedSignalVariables.put(variableKey, variableValue);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).signal((String)Matchers.eq((Object)"anExecutionId"), (Map)Matchers.argThat((Matcher)new EqualsMap(expectedSignalVariables)));
    }

    @Test
    public void testSignalWithUnparseableIntegerVariable() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Integer";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot signal execution anExecutionId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Integer.class))), new Object[0]).when().post(SIGNAL_EXECUTION_URL, new Object[0]);
    }

    @Test
    public void testSignalWithUnparseableShortVariable() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Short";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot signal execution anExecutionId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Short.class))), new Object[0]).when().post(SIGNAL_EXECUTION_URL, new Object[0]);
    }

    @Test
    public void testSignalWithUnparseableLongVariable() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Long";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot signal execution anExecutionId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Long.class))), new Object[0]).when().post(SIGNAL_EXECUTION_URL, new Object[0]);
    }

    @Test
    public void testSignalWithUnparseableDoubleVariable() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Double";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot signal execution anExecutionId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Double.class))), new Object[0]).when().post(SIGNAL_EXECUTION_URL, new Object[0]);
    }

    @Test
    public void testSignalWithUnparseableDateVariable() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Date";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot signal execution anExecutionId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Date.class))), new Object[0]).when().post(SIGNAL_EXECUTION_URL, new Object[0]);
    }

    @Test
    public void testSignalWithNotSupportedVariableType() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "X";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Cannot signal execution anExecutionId: Unsupported value type 'X'"), new Object[0]).when().post(SIGNAL_EXECUTION_URL, new Object[0]);
    }

    @Test
    public void testSignalNonExistingExecution() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable)new ProcessEngineException("expected exception")).when((Object)this.runtimeServiceMock)).signal(Matchers.anyString(), (Map)Matchers.any(Map.class));
        RestAssured.given().pathParam("id", (Object)"anExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Cannot signal execution anExecutionId: expected exception"), new Object[0]).when().post(SIGNAL_EXECUTION_URL, new Object[0]);
    }

    @Test
    public void testSignalThrowsAuthorizationException() {
        String message = "expected exception";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.runtimeServiceMock)).signal(Matchers.anyString(), (Map)Matchers.any(Map.class));
        RestAssured.given().pathParam("id", (Object)"anExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().post(SIGNAL_EXECUTION_URL, new Object[0]);
    }

    @Test
    public void testGetLocalVariables() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"anExecutionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("aVariableKey", org.hamcrest.Matchers.notNullValue(), new Object[0]).body("aVariableKey.value", CoreMatchers.equalTo((Object)EXAMPLE_VARIABLE_VALUE.getValue()), new Object[0]).body("aVariableKey.type", CoreMatchers.equalTo((Object)String.class.getSimpleName()), new Object[0]).when().get(EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
        Assert.assertEquals((String)"Should return exactly one variable", (long)1L, (long)response.jsonPath().getMap("").size());
    }

    @Test
    public void testGetLocalVariablesForNonExistingExecution() {
        Mockito.when((Object)this.runtimeServiceMock.getVariablesLocalTyped(Matchers.anyString(), Matchers.eq((boolean)true))).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("id", (Object)"aNonExistingExecutionId").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"expected exception"), new Object[0]).when().get(EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testGetLocalObjectVariables() {
        String variableKey = "aVariableId";
        List<String> payload = Arrays.asList("a", "b");
        MockObjectValue variableValue = MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue(payload).serializationDataFormat("application/json").create()).objectTypeName(ArrayList.class.getName()).serializedValue("a serialized value");
        Mockito.when((Object)this.runtimeServiceMock.getVariablesLocalTyped((String)Matchers.eq((Object)"anExecutionId"), Matchers.anyBoolean())).thenReturn((Object)Variables.createVariables().putValueTyped(variableKey, (TypedValue)variableValue));
        RestAssured.given().pathParam("id", (Object)"anExecutionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body(variableKey + ".value", CoreMatchers.equalTo(payload), new Object[0]).body(variableKey + ".type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body(variableKey + ".valueInfo." + "serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body(variableKey + ".valueInfo." + "objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).getVariablesLocalTyped("anExecutionId", true);
    }

    @Test
    public void testGetLocalObjectVariablesSerialized() {
        String variableKey = "aVariableId";
        ObjectValue variableValue = (ObjectValue)Variables.serializedObjectValue((String)"a serialized value").serializationDataFormat("application/json").objectTypeName(ArrayList.class.getName()).create();
        Mockito.when((Object)this.runtimeServiceMock.getVariablesLocalTyped((String)Matchers.eq((Object)"anExecutionId"), Matchers.anyBoolean())).thenReturn((Object)Variables.createVariables().putValueTyped(variableKey, (TypedValue)variableValue));
        RestAssured.given().pathParam("id", (Object)"anExecutionId").queryParam("deserializeValues", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body(variableKey + ".value", CoreMatchers.equalTo((Object)"a serialized value"), new Object[0]).body(variableKey + ".type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body(variableKey + ".valueInfo." + "serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body(variableKey + ".valueInfo." + "objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).getVariablesLocalTyped("anExecutionId", false);
    }

    @Test
    public void testGetLocalVariablesThrowsAuthorizationException() {
        String message = "expected exception";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.runtimeServiceMock)).getVariablesLocalTyped(Matchers.anyString(), Matchers.anyBoolean());
        RestAssured.given().pathParam("id", (Object)"anExecutionId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().get(EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testLocalVariableModification() {
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        String variableKey = "aKey";
        int variableValue = 123;
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("deleteKey");
        messageBodyJson.put("deletions", deletions);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
        HashMap<String, Object> expectedModifications = new HashMap<String, Object>();
        expectedModifications.put(variableKey, variableValue);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).updateVariablesLocal((String)Matchers.eq((Object)"anExecutionId"), (Map)Matchers.argThat((Matcher)new EqualsMap(expectedModifications)), (Collection)Matchers.argThat((Matcher)new EqualsList(deletions)));
    }

    @Test
    public void testLocalVariableModificationForNonExistingExecution() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable)new ProcessEngineException("expected exception")).when((Object)this.runtimeServiceMock)).updateVariablesLocal(Matchers.anyString(), (Map)Matchers.any(Map.class), (Collection)Matchers.any(List.class));
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        String variableKey = "aKey";
        int variableValue = 123;
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Cannot modify variables for execution anExecutionId: expected exception"), new Object[0]).when().post(EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testEmptyLocalVariableModification() {
        RestAssured.given().pathParam("id", (Object)"anExecutionId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testLocalVariableModificationThrowsAuthorizationException() {
        String message = "expected exception";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.runtimeServiceMock)).updateVariablesLocal(Matchers.anyString(), (Map)Matchers.any(Map.class), (Collection)Matchers.any(List.class));
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        String variableKey = "aKey";
        int variableValue = 123;
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().post(EXECUTION_LOCAL_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testGetSingleLocalVariable() {
        String variableKey = "aVariableKey";
        int variableValue = 123;
        Mockito.when((Object)this.runtimeServiceMock.getVariableLocalTyped((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.anyBoolean())).thenReturn((Object)Variables.integerValue((Integer)variableValue));
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", org.hamcrest.Matchers.is((Object)123), new Object[0]).body("type", org.hamcrest.Matchers.is((Object)"Integer"), new Object[0]).when().get(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetSingleLocalVariableData() {
        Mockito.when((Object)this.runtimeServiceMock.getVariableLocalTyped(Matchers.anyString(), (String)Matchers.eq((Object)"aBytesVariableKey"), Matchers.eq((boolean)false))).thenReturn((Object)EXAMPLE_VARIABLE_VALUE_BYTES);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)"aBytesVariableKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/octet-stream").when().get(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).getVariableLocalTyped("anExecutionId", "aBytesVariableKey", false);
    }

    @Test
    public void testGetSingleLocalVariableDataNonExisting() {
        Mockito.when((Object)this.runtimeServiceMock.getVariableLocalTyped(Matchers.anyString(), (String)Matchers.eq((Object)"nonExisting"), Matchers.eq((boolean)false))).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)"nonExisting").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)"execution variable with name nonExisting does not exist"), new Object[0]).when().get(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).getVariableLocalTyped("anExecutionId", "nonExisting", false);
    }

    @Test
    public void testGetSingleLocalVariabledataNotBinary() {
        Mockito.when((Object)this.runtimeServiceMock.getVariableLocalTyped(Matchers.anyString(), (String)Matchers.eq((Object)"aVariableKey"), Matchers.eq((boolean)false))).thenReturn((Object)EXAMPLE_VARIABLE_VALUE);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)"aVariableKey").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).getVariableLocalTyped("anExecutionId", "aVariableKey", false);
    }

    @Test
    public void testGetSingleLocalObjectVariable() {
        String variableKey = "aVariableId";
        List<String> payload = Arrays.asList("a", "b");
        MockObjectValue variableValue = MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue(payload).serializationDataFormat("application/json").create()).objectTypeName(ArrayList.class.getName()).serializedValue("a serialized value");
        Mockito.when((Object)this.runtimeServiceMock.getVariableLocalTyped((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", CoreMatchers.equalTo(payload), new Object[0]).body("type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body("valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body("valueInfo.objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).getVariableLocalTyped("anExecutionId", variableKey, true);
    }

    @Test
    public void testGetSingleLocalObjectVariableSerialized() {
        String variableKey = "aVariableId";
        ObjectValue variableValue = (ObjectValue)Variables.serializedObjectValue((String)"a serialized value").serializationDataFormat("application/json").objectTypeName(ArrayList.class.getName()).create();
        Mockito.when((Object)this.runtimeServiceMock.getVariableLocalTyped((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).queryParam("deserializeValue", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", CoreMatchers.equalTo((Object)"a serialized value"), new Object[0]).body("type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body("valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body("valueInfo.objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).getVariableLocalTyped("anExecutionId", variableKey, false);
    }

    @Test
    public void testNonExistingLocalVariable() {
        String variableKey = "aVariableKey";
        Mockito.when((Object)this.runtimeServiceMock.getVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey))).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)("execution variable with name " + variableKey + " does not exist")), new Object[0]).when().get(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetLocalVariableForNonExistingExecution() {
        String variableKey = "aVariableKey";
        Mockito.when((Object)this.runtimeServiceMock.getVariableLocalTyped((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.eq((boolean)true))).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)("Cannot get execution variable " + variableKey + ": expected exception")), new Object[0]).when().get(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetLocalVariableThrowsAuthorizationException() {
        String variableKey = "aVariableKey";
        String message = "expected exception";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.runtimeServiceMock)).getVariableLocalTyped(Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean());
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().get(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetFileVariable() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        String mimeType = "text/plain";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(mimeType).create();
        Mockito.when((Object)this.runtimeServiceMock.getVariableLocalTyped((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON.toString()).and().body("valueInfo.mimeType", CoreMatchers.equalTo((Object)mimeType), new Object[0]).body("valueInfo.filename", CoreMatchers.equalTo((Object)filename), new Object[0]).body("value", CoreMatchers.nullValue(), new Object[0]).when().get(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetNullFileVariable() {
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        String mimeType = "text/plain";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).mimeType(mimeType).create();
        Mockito.when((Object)this.runtimeServiceMock.getVariableLocalTyped((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT.toString()).and().body(org.hamcrest.Matchers.is((Matcher)CoreMatchers.equalTo((Object)"")), new Matcher[0]).when().get(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetFileVariableDownloadWithType() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).create();
        Mockito.when((Object)this.runtimeServiceMock.getVariableLocalTyped((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT.toString()).and().body(org.hamcrest.Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).when().get(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetFileVariableDownloadWithTypeAndEncoding() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        String encoding = "UTF-8";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).encoding(encoding).create();
        Mockito.when((Object)this.runtimeServiceMock.getVariableLocalTyped((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.anyBoolean())).thenReturn((Object)variableValue);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).body(org.hamcrest.Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).when().get(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        String contentType = response.contentType().replaceAll(" ", "");
        Assert.assertThat((Object)contentType, (Matcher)org.hamcrest.Matchers.is((Object)(ContentType.TEXT + ";charset=" + encoding)));
    }

    @Test
    public void testGetFileVariableDownloadWithoutType() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).create();
        Mockito.when((Object)this.runtimeServiceMock.getVariableLocalTyped((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/octet-stream").and().body(org.hamcrest.Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).header("Content-Disposition", org.hamcrest.Matchers.containsString((String)filename)).when().get(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testCannotDownloadVariableOtherThanFile() {
        String variableKey = "aVariableKey";
        BooleanValue variableValue = Variables.booleanValue((Boolean)true);
        Mockito.when((Object)this.runtimeServiceMock.getVariableLocalTyped((String)Matchers.eq((Object)"anId"), (String)Matchers.eq((Object)variableKey), Matchers.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleLocalVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "aVariableValue";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap(variableValue);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.argThat((Matcher)EqualsUntypedValue.matcher().value(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithTypeInteger() {
        String variableKey = "aVariableKey";
        Integer variableValue = 123;
        String type = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.argThat((Matcher)EqualsPrimitiveValue.integerValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableInteger() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Integer.class))), new Object[0]).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeShort() {
        String variableKey = "aVariableKey";
        Short variableValue = 123;
        String type = "Short";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.argThat((Matcher)EqualsPrimitiveValue.shortValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableShort() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Short";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Short.class))), new Object[0]).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeLong() {
        String variableKey = "aVariableKey";
        Long variableValue = 123L;
        String type = "Long";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.argThat((Matcher)EqualsPrimitiveValue.longValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableLong() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Long";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Long.class))), new Object[0]).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeDouble() {
        String variableKey = "aVariableKey";
        Double variableValue = 123.456;
        String type = "Double";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.argThat((Matcher)EqualsPrimitiveValue.doubleValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableDouble() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Double";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Double.class))), new Object[0]).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeBoolean() {
        String variableKey = "aVariableKey";
        Boolean variableValue = true;
        String type = "Boolean";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.argThat((Matcher)EqualsPrimitiveValue.booleanValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithTypeDate() throws Exception {
        Date now = new Date();
        SimpleDateFormat pattern = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String variableKey = "aVariableKey";
        String variableValue = pattern.format(now);
        String type = "Date";
        Date expectedValue = pattern.parse(variableValue);
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.argThat((Matcher)EqualsPrimitiveValue.dateValue(expectedValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableDate() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Date";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Date.class))), new Object[0]).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithNotSupportedType() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "X";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Cannot put execution variable aVariableKey: Unsupported value type 'X'"), new Object[0]).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableThrowsAuthorizationException() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "String";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        String message = "expected exception";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.runtimeServiceMock)).setVariableLocal(Matchers.anyString(), Matchers.anyString(), Matchers.any());
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleLocalBinaryVariable() {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
    }

    @Test
    public void testPutSingleLocalBinaryVariableWithValueType() {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).multiPart("valueType", "Bytes", "text/plain").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
    }

    @Test
    public void testPutSingleLocalBinaryVariableWithUnknownValueType() {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).multiPart("valueType", "SomeUnknownType", "text/plain").expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Unsupported value type 'SomeUnknownType'"), new Object[0]).when().post(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.never())).setVariableLocal(Matchers.anyString(), Matchers.anyString(), Matchers.any(Object.class));
    }

    @Test
    public void testPutSingleLocalBinaryVariableWithValueTypeOfWrongMimeType() {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).multiPart("valueType", "{ \"type\": \"Bytes\"", "application/json").expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Form part with name 'valueType' must have a text/plain value"), new Object[0]).when().post(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.never())).setVariableLocal(Matchers.anyString(), Matchers.anyString(), Matchers.any(Object.class));
    }

    @Test
    public void testPutSingleLocalBinaryVariableWithNoValue() {
        byte[] bytes = new byte[]{};
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
    }

    @Test
    public void testPutSingleLocalSerializableVariableFromJson() throws Exception {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("foo");
        ObjectMapper mapper = new ObjectMapper();
        String jsonBytes = mapper.writeValueAsString(serializable);
        String typeName = TypeFactory.defaultInstance().constructType(serializable.getClass()).toCanonical();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", jsonBytes, "application/json").multiPart("type", typeName, "text/plain").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.argThat((Matcher)EqualsObjectValue.objectValueMatcher().isDeserialized().value(serializable)));
    }

    @Test
    public void testPutSingleLocalSerializableVariableUnsupportedMediaType() throws Exception {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("foo");
        ObjectMapper mapper = new ObjectMapper();
        String jsonBytes = mapper.writeValueAsString(serializable);
        String typeName = TypeFactory.defaultInstance().constructType(serializable.getClass()).toCanonical();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", jsonBytes, "unsupported").multiPart("type", typeName, "text/plain").expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(org.hamcrest.Matchers.containsString((String)"Unrecognized content type for serialized java type: unsupported"), new Matcher[0]).when().post(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.never())).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.eq(serializable));
    }

    @Test
    public void testPutSingleLocalBinaryVariableThrowsAuthorizationException() {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        String message = "expected exception";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.runtimeServiceMock)).setVariableLocal(Matchers.anyString(), Matchers.anyString(), Matchers.any());
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", "unspecified", bytes).expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().post(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleLocalVariableFromSerialized() {
        String serializedValue = "{\"prop\" : \"value\"}";
        Map<String, Object> requestJson = VariablesBuilder.getObjectValueMap(serializedValue, ValueType.OBJECT.getName(), "aDataFormat", "aRootType");
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(requestJson).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.argThat((Matcher)EqualsObjectValue.objectValueMatcher().serializationFormat("aDataFormat").objectTypeName("aRootType").serializedValue(serializedValue)));
    }

    @Test
    public void testPutSingleLocalVariableFromInvalidSerialized() {
        String serializedValue = "{\"prop\" : \"value\"}";
        Map<String, Object> requestJson = VariablesBuilder.getObjectValueMap(serializedValue, "aNonExistingType", null, null);
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(requestJson).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Cannot put execution variable aVariableKey: Unsupported value type 'aNonExistingType'"), new Object[0]).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleLocalVariableFromSerializedWithNoValue() {
        String variableKey = "aVariableKey";
        Map<String, Object> requestJson = VariablesBuilder.getObjectValueMap(null, ValueType.OBJECT.getName(), null, null);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(requestJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.argThat((Matcher)EqualsObjectValue.objectValueMatcher().serializationFormat(null).objectTypeName(null).serializedValue(null)));
    }

    @Test
    public void testPutSingleLocalVariableWithNoValue() {
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.argThat((Matcher)EqualsNullValue.matcher()));
    }

    @Test
    public void testPutLocalVariableForNonExistingExecution() {
        String variableKey = "aVariableKey";
        String variableValue = "aVariableValue";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap(variableValue);
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable)new BadUserRequestException("expected exception")).when((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), Matchers.any());
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)("Cannot put execution variable " + variableKey + ": expected exception")), new Object[0]).when().put(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testDeleteSingleLocalVariable() {
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).removeVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey));
    }

    @Test
    public void testPostSingleLocalFileVariableWithEncodingAndMimeType() {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String encoding = "utf-8";
        String filename = "test.txt";
        String mimetype = "text/plain";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, mimetype + "; encoding=" + encoding).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        Assert.assertThat((Object)captured.getEncoding(), (Matcher)org.hamcrest.Matchers.is((Object)encoding));
        Assert.assertThat((Object)captured.getFilename(), (Matcher)org.hamcrest.Matchers.is((Object)filename));
        Assert.assertThat((Object)captured.getMimeType(), (Matcher)org.hamcrest.Matchers.is((Object)mimetype));
        Assert.assertThat((Object)IoUtil.readInputStream((InputStream)captured.getValue(), null), (Matcher)org.hamcrest.Matchers.is((Object)value));
    }

    @Test
    public void testPostSingleLocalFileVariableWithMimeType() {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        String mimetype = "text/plain";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, mimetype).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        Assert.assertThat((Object)captured.getEncoding(), (Matcher)org.hamcrest.Matchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)captured.getFilename(), (Matcher)org.hamcrest.Matchers.is((Object)filename));
        Assert.assertThat((Object)captured.getMimeType(), (Matcher)org.hamcrest.Matchers.is((Object)mimetype));
        Assert.assertThat((Object)IoUtil.readInputStream((InputStream)captured.getValue(), null), (Matcher)org.hamcrest.Matchers.is((Object)value));
    }

    @Test
    public void testPostSingleLocalFileVariableWithEncoding() {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String encoding = "utf-8";
        String filename = "test.txt";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, "encoding=" + encoding).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPostSingleLocalFileVariableOnlyFilename() throws Exception {
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).multiPart("data", filename, new byte[0]).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_EXECUTION_LOCAL_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        Assert.assertThat((Object)captured.getEncoding(), (Matcher)org.hamcrest.Matchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)captured.getFilename(), (Matcher)org.hamcrest.Matchers.is((Object)filename));
        Assert.assertThat((Object)captured.getMimeType(), (Matcher)org.hamcrest.Matchers.is((Object)"application/octet-stream"));
        Assert.assertThat((Object)captured.getValue().available(), (Matcher)org.hamcrest.Matchers.is((Object)0));
    }

    @Test
    public void testDeleteLocalVariableForNonExistingExecution() {
        String variableKey = "aVariableKey";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable)new ProcessEngineException("expected exception")).when((Object)this.runtimeServiceMock)).removeVariableLocal((String)Matchers.eq((Object)"anExecutionId"), (String)Matchers.eq((Object)variableKey));
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)("Cannot delete execution variable " + variableKey + ": expected exception")), new Object[0]).when().delete(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testDeleteLocalVariableThrowsAuthorizationException() {
        String variableKey = "aVariableKey";
        String message = "expected exception";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.runtimeServiceMock)).removeVariableLocal(Matchers.anyString(), Matchers.anyString());
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().delete(SINGLE_EXECUTION_LOCAL_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetMessageEventSubscription() {
        String messageName = "anEvent";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("messageName", (Object)messageName).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", CoreMatchers.equalTo((Object)"anEventSubscriptionId"), new Object[0]).body("eventType", CoreMatchers.equalTo((Object)"message"), new Object[0]).body("eventName", CoreMatchers.equalTo((Object)"anEvent"), new Object[0]).body("executionId", CoreMatchers.equalTo((Object)"anExecutionId"), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)"aProcInstId"), new Object[0]).body("activityId", CoreMatchers.equalTo((Object)"anActivity"), new Object[0]).body("createdDate", CoreMatchers.equalTo((Object)"2013-01-23T13:59:43"), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)"aTenantId"), new Object[0]).when().get(MESSAGE_SUBSCRIPTION_URL, new Object[0]);
    }

    @Test
    public void testGetNonExistingMessageEventSubscription() {
        EventSubscriptionQuery sampleEventSubscriptionQuery = (EventSubscriptionQuery)Mockito.mock(EventSubscriptionQuery.class);
        Mockito.when((Object)this.runtimeServiceMock.createEventSubscriptionQuery()).thenReturn((Object)sampleEventSubscriptionQuery);
        Mockito.when((Object)sampleEventSubscriptionQuery.executionId(Matchers.anyString())).thenReturn((Object)sampleEventSubscriptionQuery);
        Mockito.when((Object)sampleEventSubscriptionQuery.eventName(Matchers.anyString())).thenReturn((Object)sampleEventSubscriptionQuery);
        Mockito.when((Object)sampleEventSubscriptionQuery.eventType(Matchers.anyString())).thenReturn((Object)sampleEventSubscriptionQuery);
        Mockito.when((Object)sampleEventSubscriptionQuery.singleResult()).thenReturn(null);
        String executionId = "anExecutionId";
        String nonExistingMessageName = "aMessage";
        RestAssured.given().pathParam("id", (Object)executionId).pathParam("messageName", (Object)nonExistingMessageName).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Message event subscription for execution " + executionId + " named " + nonExistingMessageName + " does not exist")), new Object[0]).when().get(MESSAGE_SUBSCRIPTION_URL, new Object[0]);
    }

    @Test
    public void testMessageEventTriggering() {
        String messageName = "aMessageName";
        String variableKey1 = "aVarName";
        String variableValue1 = "aVarValue";
        String variableKey2 = "anotherVarName";
        String variableValue2 = "anotherVarValue";
        Map<String, Object> variables = VariablesBuilder.create().variable(variableKey1, variableValue1).variable(variableKey2, variableValue2).getVariables();
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("messageName", (Object)messageName).contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(TRIGGER_MESSAGE_SUBSCRIPTION_URL, new Object[0]);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put(variableKey1, variableValue1);
        expectedVariables.put(variableKey2, variableValue2);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).messageEventReceived((String)Matchers.eq((Object)messageName), (String)Matchers.eq((Object)"anExecutionId"), (Map)Matchers.argThat((Matcher)new EqualsMap(expectedVariables)));
    }

    @Test
    public void testMessageEventTriggeringWithoutVariables() {
        String messageName = "aMessageName";
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("messageName", (Object)messageName).contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(TRIGGER_MESSAGE_SUBSCRIPTION_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).messageEventReceived((String)Matchers.eq((Object)messageName), (String)Matchers.eq((Object)"anExecutionId"), (Map)Matchers.argThat((Matcher)new EqualsMap(null)));
    }

    @Test
    public void testFailingMessageEventTriggering() {
        String messageName = "someMessage";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable)new ProcessEngineException("expected exception")).when((Object)this.runtimeServiceMock)).messageEventReceived(Matchers.anyString(), Matchers.anyString(), (Map)Matchers.any(Map.class));
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("messageName", (Object)messageName).contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)("Cannot trigger message " + messageName + " for execution " + "anExecutionId" + ": expected exception")), new Object[0]).when().post(TRIGGER_MESSAGE_SUBSCRIPTION_URL, new Object[0]);
    }

    @Test
    public void testMessageEventTriggeringThrowsAuthorizationException() {
        String message = "expected exception";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.runtimeServiceMock)).messageEventReceived(Matchers.anyString(), Matchers.anyString(), (Map)Matchers.any(Map.class));
        RestAssured.given().pathParam("id", (Object)"anExecutionId").pathParam("messageName", (Object)"someMessage").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", org.hamcrest.Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.is((Object)message), new Object[0]).when().post(TRIGGER_MESSAGE_SUBSCRIPTION_URL, new Object[0]);
    }
}

