/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import com.jayway.restassured.RestAssured;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryTopicBuilder;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.helper.EqualsVariableMap;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.variable.EqualsObjectValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsUntypedValue;
import org.camunda.bpm.engine.rest.util.VariablesBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class ExternalTaskRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String EXTERNAL_TASK_URL = "/rest-test/external-task";
    protected static final String FETCH_EXTERNAL_TASK_URL = "/rest-test/external-task/fetchAndLock";
    protected static final String SINGLE_EXTERNAL_TASK_URL = "/rest-test/external-task/{id}";
    protected static final String COMPLETE_EXTERNAL_TASK_URL = "/rest-test/external-task/{id}/complete";
    protected static final String GET_EXTERNAL_TASK_ERROR_DETAILS_URL = "/rest-test/external-task/{id}/errorDetails";
    protected static final String HANDLE_EXTERNAL_TASK_FAILURE_URL = "/rest-test/external-task/{id}/failure";
    protected static final String HANDLE_EXTERNAL_TASK_BPMN_ERROR_URL = "/rest-test/external-task/{id}/bpmnError";
    protected static final String UNLOCK_EXTERNAL_TASK_URL = "/rest-test/external-task/{id}/unlock";
    protected static final String RETRIES_EXTERNAL_TASK_URL = "/rest-test/external-task/{id}/retries";
    protected static final String PRIORITY_EXTERNAL_TASK_URL = "/rest-test/external-task/{id}/priority";
    protected ExternalTaskService externalTaskService;
    protected LockedExternalTask lockedExternalTaskMock;
    protected ExternalTaskQueryTopicBuilder fetchTopicBuilder;
    protected ExternalTask externalTaskMock;
    protected ExternalTaskQuery externalTaskQueryMock;

    @Before
    public void setUpRuntimeData() {
        this.externalTaskService = (ExternalTaskService)Mockito.mock(ExternalTaskService.class);
        Mockito.when((Object)processEngine.getExternalTaskService()).thenReturn((Object)this.externalTaskService);
        this.lockedExternalTaskMock = MockProvider.createMockLockedExternalTask();
        this.fetchTopicBuilder = (ExternalTaskQueryTopicBuilder)Mockito.mock(ExternalTaskQueryTopicBuilder.class);
        Mockito.when((Object)this.externalTaskService.fetchAndLock(org.mockito.Matchers.anyInt(), (String)org.mockito.Matchers.any(String.class))).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.externalTaskService.fetchAndLock(org.mockito.Matchers.anyInt(), (String)org.mockito.Matchers.any(String.class), ((Boolean)org.mockito.Matchers.any(Boolean.class)).booleanValue())).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.topic((String)org.mockito.Matchers.any(String.class), org.mockito.Matchers.anyLong())).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.variables(org.mockito.Matchers.anyListOf(String.class))).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.variables((String[])org.mockito.Matchers.any(String[].class))).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.enableCustomObjectDeserialization()).thenReturn((Object)this.fetchTopicBuilder);
        Mockito.when((Object)this.fetchTopicBuilder.topic((String)org.mockito.Matchers.any(String.class), org.mockito.Matchers.anyLong())).thenReturn((Object)this.fetchTopicBuilder);
        this.externalTaskQueryMock = (ExternalTaskQuery)Mockito.mock(ExternalTaskQuery.class);
        Mockito.when((Object)this.externalTaskQueryMock.externalTaskId((String)org.mockito.Matchers.any(String.class))).thenReturn((Object)this.externalTaskQueryMock);
        Mockito.when((Object)this.externalTaskService.createExternalTaskQuery()).thenReturn((Object)this.externalTaskQueryMock);
        this.externalTaskMock = MockProvider.createMockExternalTask();
    }

    @Test
    public void testFetchAndLock() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(Arrays.asList(this.lockedExternalTaskMock));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("maxTasks", 5);
        parameters.put("workerId", "aWorkerId");
        parameters.put("usePriority", true);
        HashMap<String, Object> topicParameter = new HashMap<String, Object>();
        topicParameter.put("topicName", "aTopicName");
        topicParameter.put("lockDuration", 12354L);
        topicParameter.put("variables", Arrays.asList("aVariableInstanceName"));
        parameters.put("topics", Arrays.asList(topicParameter));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("[0].id", CoreMatchers.equalTo((Object)"anExternalTaskId"), new Object[0]).body("[0].topicName", CoreMatchers.equalTo((Object)"aTopic"), new Object[0]).body("[0].workerId", CoreMatchers.equalTo((Object)"aWorkerId"), new Object[0]).body("[0].lockExpirationTime", CoreMatchers.equalTo((Object)"2015-10-05T13:25:00"), new Object[0]).body("[0].processInstanceId", CoreMatchers.equalTo((Object)"aProcInstId"), new Object[0]).body("[0].executionId", CoreMatchers.equalTo((Object)"anExecutionId"), new Object[0]).body("[0].activityId", CoreMatchers.equalTo((Object)"anActivity"), new Object[0]).body("[0].activityInstanceId", CoreMatchers.equalTo((Object)"anActivityInstanceId"), new Object[0]).body("[0].processDefinitionId", CoreMatchers.equalTo((Object)"aProcDefId"), new Object[0]).body("[0].processDefinitionKey", CoreMatchers.equalTo((Object)"aKey"), new Object[0]).body("[0].tenantId", CoreMatchers.equalTo((Object)"aTenantId"), new Object[0]).body("[0].retries", CoreMatchers.equalTo((Object)MockProvider.EXTERNAL_TASK_RETRIES), new Object[0]).body("[0].errorMessage", CoreMatchers.equalTo((Object)"some error"), new Object[0]).body("[0].errorMessage", CoreMatchers.equalTo((Object)"some error"), new Object[0]).body("[0].priority", CoreMatchers.equalTo((Object)2147484113L), new Object[0]).body("[0].variables.aVariableInstanceName", Matchers.notNullValue(), new Object[0]).body("[0].variables.aVariableInstanceName.value", CoreMatchers.equalTo((Object)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getValue()), new Object[0]).body("[0].variables.aVariableInstanceName.type", CoreMatchers.equalTo((Object)"String"), new Object[0]).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", true);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).variables(Arrays.asList("aVariableInstanceName"));
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void testFetchWithoutVariables() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(Arrays.asList(this.lockedExternalTaskMock));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("maxTasks", 5);
        parameters.put("workerId", "aWorkerId");
        HashMap<String, Object> topicParameter = new HashMap<String, Object>();
        topicParameter.put("topicName", "aTopicName");
        topicParameter.put("lockDuration", 12354L);
        parameters.put("topics", Arrays.asList(topicParameter));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("[0].id", CoreMatchers.equalTo((Object)"anExternalTaskId"), new Object[0]).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", false);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void testEnableCustomObjectDeserialization() {
        Mockito.when((Object)this.fetchTopicBuilder.execute()).thenReturn(Arrays.asList(this.lockedExternalTaskMock));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("maxTasks", 5);
        parameters.put("workerId", "aWorkerId");
        HashMap<String, Object> topicParameter = new HashMap<String, Object>();
        topicParameter.put("topicName", "aTopicName");
        topicParameter.put("lockDuration", 12354L);
        topicParameter.put("variables", Arrays.asList("aVariableInstanceName"));
        topicParameter.put("deserializeValues", true);
        parameters.put("topics", Arrays.asList(topicParameter));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(FETCH_EXTERNAL_TASK_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
        ((ExternalTaskService)inOrder.verify((Object)this.externalTaskService)).fetchAndLock(5, "aWorkerId", false);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).topic("aTopicName", 12354L);
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).variables(Arrays.asList("aVariableInstanceName"));
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).enableCustomObjectDeserialization();
        ((ExternalTaskQueryTopicBuilder)inOrder.verify((Object)this.fetchTopicBuilder)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fetchTopicBuilder, this.externalTaskService});
    }

    @Test
    public void testComplete() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(COMPLETE_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).complete("anExternalTaskId", "aWorkerId", null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testCompleteWithVariables() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        Map<String, Object> variables = VariablesBuilder.create().variable("var1", "val1").variable("var2", (Object)"val2", "String").variable("var3", ValueType.OBJECT.getName(), "val3", "aFormat", "aRootType").getVariables();
        parameters.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(COMPLETE_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).complete((String)org.mockito.Matchers.eq((Object)"anExternalTaskId"), (String)org.mockito.Matchers.eq((Object)"aWorkerId"), (Map)org.mockito.Matchers.argThat((Matcher)EqualsVariableMap.matches().matcher("var1", (Matcher<?>)EqualsUntypedValue.matcher().value("val1")).matcher("var2", (Matcher<?>)EqualsPrimitiveValue.stringValue("val2")).matcher("var3", (Matcher<?>)((EqualsObjectValue)((Object)EqualsObjectValue.objectValueMatcher().type((ValueType)ValueType.OBJECT))).serializedValue("val3").serializationFormat("aFormat").objectTypeName("aRootType"))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testCompleteNonExistingTask() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.externalTaskService)).complete((String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), org.mockito.Matchers.anyMapOf(String.class, Object.class));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().post(COMPLETE_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testCompleteThrowsAuthorizationException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new AuthorizationException("aMessage")).when((Object)this.externalTaskService)).complete((String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), org.mockito.Matchers.anyMapOf(String.class, Object.class));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().post(COMPLETE_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testCompleteThrowsBadUserRequestException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new BadUserRequestException("aMessage")).when((Object)this.externalTaskService)).complete((String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), org.mockito.Matchers.anyMapOf(String.class, Object.class));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().post(COMPLETE_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testUnlock() {
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(UNLOCK_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).unlock("anExternalTaskId");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testUnlockNonExistingTask() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.externalTaskService)).unlock((String)org.mockito.Matchers.any(String.class));
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().post(UNLOCK_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).unlock("anExternalTaskId");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testUnlockThrowsAuthorizationException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new AuthorizationException("aMessage")).when((Object)this.externalTaskService)).unlock((String)org.mockito.Matchers.any(String.class));
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().post(UNLOCK_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).unlock("anExternalTaskId");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testGetErrorDetails() {
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().get(GET_EXTERNAL_TASK_ERROR_DETAILS_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).getExternalTaskErrorDetails("anExternalTaskId");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testGetErrorDetailsNonExistingTask() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.externalTaskService)).getExternalTaskErrorDetails((String)org.mockito.Matchers.any(String.class));
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().get(GET_EXTERNAL_TASK_ERROR_DETAILS_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).getExternalTaskErrorDetails("anExternalTaskId");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testGetErrorDetailsThrowsAuthorizationException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new AuthorizationException("aMessage")).when((Object)this.externalTaskService)).getExternalTaskErrorDetails((String)org.mockito.Matchers.any(String.class));
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().get(GET_EXTERNAL_TASK_ERROR_DETAILS_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).getExternalTaskErrorDetails("anExternalTaskId");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testHandleFailure() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorMessage", "anErrorMessage");
        parameters.put("retries", 5);
        parameters.put("retryTimeout", 12345);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(HANDLE_EXTERNAL_TASK_FAILURE_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).handleFailure("anExternalTaskId", "aWorkerId", "anErrorMessage", null, 5, 12345L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testHandleFailureWithStackTrace() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorMessage", "anErrorMessage");
        parameters.put("errorDetails", "aStackTrace");
        parameters.put("retries", 5);
        parameters.put("retryTimeout", 12345);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(HANDLE_EXTERNAL_TASK_FAILURE_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).handleFailure("anExternalTaskId", "aWorkerId", "anErrorMessage", "aStackTrace", 5, 12345L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testHandleFailureNonExistingTask() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.externalTaskService)).handleFailure((String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorMessage", "anErrorMessage");
        parameters.put("retries", 5);
        parameters.put("retryTimeout", 12345);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().post(HANDLE_EXTERNAL_TASK_FAILURE_URL, new Object[0]);
    }

    @Test
    public void testHandleFailureThrowsAuthorizationException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new AuthorizationException("aMessage")).when((Object)this.externalTaskService)).handleFailure((String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorMessage", "anErrorMessage");
        parameters.put("retries", 5);
        parameters.put("retryTimeout", 12345);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().post(HANDLE_EXTERNAL_TASK_FAILURE_URL, new Object[0]);
    }

    @Test
    public void testHandleFailureThrowsBadUserRequestException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new BadUserRequestException("aMessage")).when((Object)this.externalTaskService)).handleFailure((String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyLong());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorMessage", "anErrorMessage");
        parameters.put("retries", 5);
        parameters.put("retryTimeout", 12345);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().post(HANDLE_EXTERNAL_TASK_FAILURE_URL, new Object[0]);
    }

    @Test
    public void testHandleBpmnError() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorCode", "anErrorCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(HANDLE_EXTERNAL_TASK_BPMN_ERROR_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).handleBpmnError("anExternalTaskId", "aWorkerId", "anErrorCode");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testHandleBpmnErrorNonExistingTask() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.externalTaskService)).handleBpmnError((String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorCode", "errorCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().post(HANDLE_EXTERNAL_TASK_BPMN_ERROR_URL, new Object[0]);
    }

    @Test
    public void testHandleBpmnErrorThrowsAuthorizationException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new AuthorizationException("aMessage")).when((Object)this.externalTaskService)).handleBpmnError((String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorCode", "errorCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().post(HANDLE_EXTERNAL_TASK_BPMN_ERROR_URL, new Object[0]);
    }

    @Test
    public void testHandleBpmnErrorThrowsBadUserRequestException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new BadUserRequestException("aMessage")).when((Object)this.externalTaskService)).handleBpmnError((String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class), (String)org.mockito.Matchers.any(String.class));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("workerId", "aWorkerId");
        parameters.put("errorCode", "errorCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().post(HANDLE_EXTERNAL_TASK_BPMN_ERROR_URL, new Object[0]);
    }

    @Test
    public void testSetRetries() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("retries", "5");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(RETRIES_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).setRetries("anExternalTaskId", 5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testSetRetriesNonExistingTask() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.externalTaskService)).setRetries((String)org.mockito.Matchers.any(String.class), org.mockito.Matchers.anyInt());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("retries", "5");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().put(RETRIES_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testSetRetriesThrowsAuthorizationException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new AuthorizationException("aMessage")).when((Object)this.externalTaskService)).setRetries((String)org.mockito.Matchers.any(String.class), org.mockito.Matchers.anyInt());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("retries", "5");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().put(RETRIES_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testSetPriority() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("priority", "5");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PRIORITY_EXTERNAL_TASK_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.externalTaskService)).setPriority("anExternalTaskId", 5L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalTaskService});
    }

    @Test
    public void testSetPriorityNonExistingTask() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.externalTaskService)).setPriority((String)org.mockito.Matchers.any(String.class), (long)org.mockito.Matchers.anyInt());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("priority", "5");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().put(PRIORITY_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testSetPriorityThrowsAuthorizationException() {
        ((ExternalTaskService)Mockito.doThrow((Throwable)new AuthorizationException("aMessage")).when((Object)this.externalTaskService)).setPriority((String)org.mockito.Matchers.any(String.class), (long)org.mockito.Matchers.anyInt());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("priority", "5");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"aMessage"), new Object[0]).when().put(PRIORITY_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testGetSingleExternalTask() {
        Mockito.when((Object)this.externalTaskQueryMock.singleResult()).thenReturn((Object)this.externalTaskMock);
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("activityId", CoreMatchers.equalTo((Object)"anActivity"), new Object[0]).body("activityInstanceId", CoreMatchers.equalTo((Object)"anActivityInstanceId"), new Object[0]).body("errorMessage", CoreMatchers.equalTo((Object)"some error"), new Object[0]).body("executionId", CoreMatchers.equalTo((Object)"anExecutionId"), new Object[0]).body("id", CoreMatchers.equalTo((Object)"anExternalTaskId"), new Object[0]).body("lockExpirationTime", CoreMatchers.equalTo((Object)"2015-10-05T13:25:00"), new Object[0]).body("processDefinitionId", CoreMatchers.equalTo((Object)"aProcDefId"), new Object[0]).body("processDefinitionKey", CoreMatchers.equalTo((Object)"aKey"), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)"aProcInstId"), new Object[0]).body("retries", CoreMatchers.equalTo((Object)MockProvider.EXTERNAL_TASK_RETRIES), new Object[0]).body("suspended", CoreMatchers.equalTo((Object)true), new Object[0]).body("topicName", CoreMatchers.equalTo((Object)"aTopic"), new Object[0]).body("workerId", CoreMatchers.equalTo((Object)"aWorkerId"), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)"aTenantId"), new Object[0]).body("priority", CoreMatchers.equalTo((Object)2147484113L), new Object[0]).when().get(SINGLE_EXTERNAL_TASK_URL, new Object[0]);
    }

    @Test
    public void testGetNonExistingExternalTask() {
        Mockito.when((Object)this.externalTaskQueryMock.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"anExternalTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"External task with id anExternalTaskId does not exist"), new Object[0]).when().get(SINGLE_EXTERNAL_TASK_URL, new Object[0]);
    }
}

