/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class HistoricActivityInstanceRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_ACTIVITY_INSTANCE_URL = "/rest-test/history/activity-instance";
    protected static final String HISTORIC_SINGLE_ACTIVITY_INSTANCE_URL = "/rest-test/history/activity-instance/{id}";
    protected HistoryService historyServiceMock;
    protected HistoricActivityInstance historicInstanceMock;
    protected HistoricActivityInstanceQuery historicQueryMock;

    @Before
    public void setUpRuntimeData() {
        this.historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
        this.historicInstanceMock = MockProvider.createMockHistoricActivityInstance();
        this.historicQueryMock = (HistoricActivityInstanceQuery)Mockito.mock(HistoricActivityInstanceQuery.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricActivityInstanceQuery()).thenReturn((Object)this.historicQueryMock);
        Mockito.when((Object)this.historicQueryMock.activityInstanceId(Matchers.anyString())).thenReturn((Object)this.historicQueryMock);
        Mockito.when((Object)this.historicQueryMock.singleResult()).thenReturn((Object)this.historicInstanceMock);
    }

    @Test
    public void testGetSingleHistoricActivityInstance() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aHistoricActivityInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_ACTIVITY_INSTANCE_URL, new Object[0]);
        String content = response.asString();
        String returnedId = JsonPath.from((String)content).getString("id");
        String returnedParentActivityInstanceId = JsonPath.from((String)content).getString("parentActivityInstanceId");
        String returnedActivityId = JsonPath.from((String)content).getString("activityId");
        String returnedActivityName = JsonPath.from((String)content).getString("activityName");
        String returnedActivityType = JsonPath.from((String)content).getString("activityType");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("processDefinitionKey");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("processDefinitionId");
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("processInstanceId");
        String returnedExecutionId = JsonPath.from((String)content).getString("executionId");
        String returnedTaskId = JsonPath.from((String)content).getString("taskId");
        String returnedCalledProcessInstanceId = JsonPath.from((String)content).getString("calledProcessInstanceId");
        String returnedCalledCaseInstanceId = JsonPath.from((String)content).getString("calledCaseInstanceId");
        String returnedAssignee = JsonPath.from((String)content).getString("assignee");
        String returnedStartTime = JsonPath.from((String)content).getString("startTime");
        String returnedEndTime = JsonPath.from((String)content).getString("endTime");
        long returnedDurationInMillis = JsonPath.from((String)content).getLong("durationInMillis");
        boolean canceled = JsonPath.from((String)content).getBoolean("canceled");
        boolean completeScope = JsonPath.from((String)content).getBoolean("completeScope");
        String returnedTenantId = JsonPath.from((String)content).getString("tenantId");
        Assert.assertEquals((Object)"aHistoricActivityInstanceId", (Object)returnedId);
        Assert.assertEquals((Object)"aHistoricParentActivityInstanceId", (Object)returnedParentActivityInstanceId);
        Assert.assertEquals((Object)"anActivity", (Object)returnedActivityId);
        Assert.assertEquals((Object)"anActivityName", (Object)returnedActivityName);
        Assert.assertEquals((Object)"anActivityType", (Object)returnedActivityType);
        Assert.assertEquals((Object)"aKey", (Object)returnedProcessDefinitionKey);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"anExecutionId", (Object)returnedExecutionId);
        Assert.assertEquals((Object)"anId", (Object)returnedTaskId);
        Assert.assertEquals((Object)"aHistoricCalledProcessInstanceId", (Object)returnedCalledProcessInstanceId);
        Assert.assertEquals((Object)"aHistoricCalledCaseInstanceId", (Object)returnedCalledCaseInstanceId);
        Assert.assertEquals((Object)"anAssignee", (Object)returnedAssignee);
        Assert.assertEquals((Object)"2013-04-23T13:42:43", (Object)returnedStartTime);
        Assert.assertEquals((Object)"2013-04-23T18:42:43", (Object)returnedEndTime);
        Assert.assertEquals((long)2000L, (long)returnedDurationInMillis);
        Assert.assertEquals((Object)true, (Object)canceled);
        Assert.assertEquals((Object)true, (Object)completeScope);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
    }

    @Test
    public void testGetNonExistingHistoricCaseInstance() {
        Mockito.when((Object)this.historicQueryMock.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"nonExistingId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Historic activity instance with id 'nonExistingId' does not exist"), new Object[0]).when().get(HISTORIC_SINGLE_ACTIVITY_INSTANCE_URL, new Object[0]);
    }
}

