/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.history.HistoricActivityStatistics;
import org.camunda.bpm.engine.history.HistoricActivityStatisticsQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class HistoricActivityStatisticsRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORY_URL = "/rest-test/history";
    protected static final String HISTORIC_ACTIVITY_STATISTICS_URL = "/rest-test/history/process-definition/{id}/statistics";
    private HistoricActivityStatisticsQuery historicActivityStatisticsQuery;

    @Before
    public void setUpRuntimeData() {
        this.setupHistoricActivityStatisticsMock();
    }

    private void setupHistoricActivityStatisticsMock() {
        List<HistoricActivityStatistics> mocks = MockProvider.createMockHistoricActivityStatistics();
        this.historicActivityStatisticsQuery = (HistoricActivityStatisticsQuery)Mockito.mock(HistoricActivityStatisticsQuery.class);
        Mockito.when((Object)processEngine.getHistoryService().createHistoricActivityStatisticsQuery((String)Matchers.eq((Object)"aProcDefId"))).thenReturn((Object)this.historicActivityStatisticsQuery);
        Mockito.when((Object)this.historicActivityStatisticsQuery.list()).thenReturn(mocks);
    }

    @Test
    public void testHistoricActivityStatisticsRetrieval() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", org.hamcrest.Matchers.is((Object)2), new Object[0]).body("id", org.hamcrest.Matchers.hasItems((Object[])new String[]{"anActivity", "anotherActivity"}), new Object[0]).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testAdditionalCanceledOption() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("canceled", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).includeCanceled();
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).list();
    }

    @Test
    public void testAdditionalFinishedOption() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("finished", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).includeFinished();
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).list();
    }

    @Test
    public void testAdditionalCompleteScopeOption() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("completeScope", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).includeCompleteScope();
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).list();
    }

    @Test
    public void testAdditionalCompleteScopeAndCanceledOption() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("completeScope", new Object[]{"true"}).queryParam("canceled", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeCompleteScope();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeCanceled();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).list();
    }

    @Test
    public void testAdditionalCompleteScopeAndFinishedOption() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("completeScope", new Object[]{"true"}).queryParam("finished", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeCompleteScope();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeFinished();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).list();
    }

    @Test
    public void testAdditionalCanceledAndFinishedOption() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("canceled", new Object[]{"true"}).queryParam("finished", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeCanceled();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeFinished();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).list();
    }

    @Test
    public void testAdditionalCompleteScopeAndFinishedAndCanceledOption() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("completeScope", new Object[]{"true"}).queryParam("finished", new Object[]{"true"}).queryParam("canceled", new Object[]{"true"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeCompleteScope();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeFinished();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).includeCanceled();
        ((HistoricActivityStatisticsQuery)Mockito.verify((Object)this.historicActivityStatisticsQuery)).list();
    }

    @Test
    public void testSimpleTaskQuery() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        String content = response.asString();
        List result = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertNotNull(result.get(0));
        Assert.assertNotNull(result.get(1));
        String id = JsonPath.from((String)content).getString("[0].id");
        long instances = JsonPath.from((String)content).getLong("[0].instances");
        long canceled = JsonPath.from((String)content).getLong("[0].canceled");
        long finished = JsonPath.from((String)content).getLong("[0].finished");
        long completeScope = JsonPath.from((String)content).getLong("[0].completeScope");
        Assert.assertEquals((Object)"anActivity", (Object)id);
        Assert.assertEquals((long)123L, (long)instances);
        Assert.assertEquals((long)125L, (long)canceled);
        Assert.assertEquals((long)124L, (long)finished);
        Assert.assertEquals((long)126L, (long)completeScope);
        id = JsonPath.from((String)content).getString("[1].id");
        instances = JsonPath.from((String)content).getLong("[1].instances");
        canceled = JsonPath.from((String)content).getLong("[1].canceled");
        finished = JsonPath.from((String)content).getLong("[1].finished");
        completeScope = JsonPath.from((String)content).getLong("[1].completeScope");
        Assert.assertEquals((Object)"anotherActivity", (Object)id);
        Assert.assertEquals((long)127L, (long)instances);
        Assert.assertEquals((long)129L, (long)canceled);
        Assert.assertEquals((long)128L, (long)finished);
        Assert.assertEquals((long)130L, (long)completeScope);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("sortBy", new Object[]{"dueDate"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortOrder() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("sortOrder", new Object[]{"invalid"}).queryParam("sortBy", new Object[]{"activityId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"sortOrder parameter has invalid value: invalid"), new Object[0]).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortByParameterOnly() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("sortOrder", new Object[]{"asc"}).queryParam("sortBy", new Object[]{"invalid"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"sortBy parameter has invalid value: invalid"), new Object[0]).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
    }

    @Test
    public void testValidSortingParameters() {
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("sortOrder", new Object[]{"asc"}).queryParam("sortBy", new Object[]{"activityId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).orderByActivityId();
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).asc();
        RestAssured.given().pathParam("id", (Object)"aProcDefId").queryParam("sortOrder", new Object[]{"desc"}).queryParam("sortBy", new Object[]{"activityId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_STATISTICS_URL, new Object[0]);
        inOrder = Mockito.inOrder((Object[])new Object[]{this.historicActivityStatisticsQuery});
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).orderByActivityId();
        ((HistoricActivityStatisticsQuery)inOrder.verify((Object)this.historicActivityStatisticsQuery)).desc();
    }
}

