/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockHistoricVariableInstanceBuilder;
import org.camunda.bpm.engine.rest.helper.MockObjectValue;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.VariableTypeHelper;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HistoricVariableInstanceRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_VARIABLE_INSTANCE_RESOURCE_URL = "/rest-test/history/variable-instance";
    protected static final String VARIABLE_INSTANCE_URL = "/rest-test/history/variable-instance/{id}";
    protected static final String VARIABLE_INSTANCE_BINARY_DATA_URL = "/rest-test/history/variable-instance/{id}/data";
    protected HistoryService historyServiceMock;
    protected HistoricVariableInstanceQuery variableInstanceQueryMock;

    @Before
    public void setupTestData() {
        this.historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        this.variableInstanceQueryMock = (HistoricVariableInstanceQuery)Mockito.mock(HistoricVariableInstanceQuery.class);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
        Mockito.when((Object)this.historyServiceMock.createHistoricVariableInstanceQuery()).thenReturn((Object)this.variableInstanceQueryMock);
    }

    @Test
    public void testGetSingleVariableInstance() {
        MockHistoricVariableInstanceBuilder builder = MockProvider.mockHistoricVariableInstance();
        HistoricVariableInstance variableInstanceMock = builder.build();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableBinaryFetching()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.singleResult()).thenReturn((Object)variableInstanceMock);
        RestAssured.given().pathParam("id", (Object)builder.getId()).then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("id", CoreMatchers.equalTo((Object)builder.getId()), new Object[0]).body("name", CoreMatchers.equalTo((Object)builder.getName()), new Object[0]).body("type", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(builder.getTypedValue().getType())), new Object[0]).body("value", CoreMatchers.equalTo((Object)builder.getValue()), new Object[0]).body("processDefinitionKey", CoreMatchers.equalTo((Object)builder.getProcessDefinitionKey()), new Object[0]).body("processDefinitionId", CoreMatchers.equalTo((Object)builder.getProcessDefinitionId()), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)builder.getProcessInstanceId()), new Object[0]).body("executionId", CoreMatchers.equalTo((Object)builder.getExecutionId()), new Object[0]).body("errorMessage", CoreMatchers.equalTo((Object)builder.getErrorMessage()), new Object[0]).body("activityInstanceId", CoreMatchers.equalTo((Object)builder.getActivityInstanceId()), new Object[0]).body("caseDefinitionKey", CoreMatchers.equalTo((Object)builder.getCaseDefinitionKey()), new Object[0]).body("caseDefinitionId", CoreMatchers.equalTo((Object)builder.getCaseDefinitionId()), new Object[0]).body("caseInstanceId", CoreMatchers.equalTo((Object)builder.getCaseInstanceId()), new Object[0]).body("caseExecutionId", CoreMatchers.equalTo((Object)builder.getCaseExecutionId()), new Object[0]).body("taskId", CoreMatchers.equalTo((Object)builder.getTaskId()), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)builder.getTenantId()), new Object[0]).when().get(VARIABLE_INSTANCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
    }

    @Test
    public void testGetSingleVariableInstanceDeserialized() {
        MockObjectValue serializedValue = MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue((Object)"a value").serializationDataFormat("aDataFormat").create()).objectTypeName("aTypeName");
        MockHistoricVariableInstanceBuilder builder = MockProvider.mockHistoricVariableInstance().typedValue((TypedValue)serializedValue);
        HistoricVariableInstance variableInstanceMock = builder.build();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableBinaryFetching()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.singleResult()).thenReturn((Object)variableInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("id", CoreMatchers.equalTo((Object)builder.getId()), new Object[0]).body("name", CoreMatchers.equalTo((Object)builder.getName()), new Object[0]).body("type", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(builder.getTypedValue().getType())), new Object[0]).body("value", CoreMatchers.equalTo((Object)"a value"), new Object[0]).body("valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"aDataFormat"), new Object[0]).body("valueInfo.objectTypeName", CoreMatchers.equalTo((Object)"aTypeName"), new Object[0]).body("processDefinitionKey", CoreMatchers.equalTo((Object)builder.getProcessDefinitionKey()), new Object[0]).body("processDefinitionId", CoreMatchers.equalTo((Object)builder.getProcessDefinitionId()), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)builder.getProcessInstanceId()), new Object[0]).body("executionId", CoreMatchers.equalTo((Object)builder.getExecutionId()), new Object[0]).body("errorMessage", CoreMatchers.equalTo((Object)builder.getErrorMessage()), new Object[0]).body("activityInstanceId", CoreMatchers.equalTo((Object)builder.getActivityInstanceId()), new Object[0]).body("caseDefinitionKey", CoreMatchers.equalTo((Object)builder.getCaseDefinitionKey()), new Object[0]).body("caseDefinitionId", CoreMatchers.equalTo((Object)builder.getCaseDefinitionId()), new Object[0]).body("caseInstanceId", CoreMatchers.equalTo((Object)builder.getCaseInstanceId()), new Object[0]).body("caseExecutionId", CoreMatchers.equalTo((Object)builder.getCaseExecutionId()), new Object[0]).body("taskId", CoreMatchers.equalTo((Object)builder.getTaskId()), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)builder.getTenantId()), new Object[0]).when().get(VARIABLE_INSTANCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).disableCustomObjectDeserialization();
    }

    @Test
    public void testGetSingleVariableInstanceSerialized() {
        ObjectValue serializedValue = (ObjectValue)Variables.serializedObjectValue((String)"a serialized value").serializationDataFormat("aDataFormat").objectTypeName("aTypeName").create();
        MockHistoricVariableInstanceBuilder builder = MockProvider.mockHistoricVariableInstance().typedValue((TypedValue)serializedValue);
        HistoricVariableInstance variableInstanceMock = builder.build();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableBinaryFetching()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.singleResult()).thenReturn((Object)variableInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").queryParam("deserializeValue", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("id", CoreMatchers.equalTo((Object)builder.getId()), new Object[0]).body("name", CoreMatchers.equalTo((Object)builder.getName()), new Object[0]).body("type", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName(builder.getTypedValue().getType())), new Object[0]).body("value", CoreMatchers.equalTo((Object)"a serialized value"), new Object[0]).body("valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"aDataFormat"), new Object[0]).body("valueInfo.objectTypeName", CoreMatchers.equalTo((Object)"aTypeName"), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)builder.getProcessInstanceId()), new Object[0]).body("processDefinitionKey", CoreMatchers.equalTo((Object)builder.getProcessDefinitionKey()), new Object[0]).body("processDefinitionId", CoreMatchers.equalTo((Object)builder.getProcessDefinitionId()), new Object[0]).body("executionId", CoreMatchers.equalTo((Object)builder.getExecutionId()), new Object[0]).body("errorMessage", CoreMatchers.equalTo((Object)builder.getErrorMessage()), new Object[0]).body("activityInstanceId", CoreMatchers.equalTo((Object)builder.getActivityInstanceId()), new Object[0]).body("caseDefinitionKey", CoreMatchers.equalTo((Object)builder.getCaseDefinitionKey()), new Object[0]).body("caseDefinitionId", CoreMatchers.equalTo((Object)builder.getCaseDefinitionId()), new Object[0]).body("caseInstanceId", CoreMatchers.equalTo((Object)builder.getCaseInstanceId()), new Object[0]).body("caseExecutionId", CoreMatchers.equalTo((Object)builder.getCaseExecutionId()), new Object[0]).body("taskId", CoreMatchers.equalTo((Object)builder.getTaskId()), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)builder.getTenantId()), new Object[0]).when().get(VARIABLE_INSTANCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).disableCustomObjectDeserialization();
    }

    @Test
    public void testGetSingleVariableInstanceForBinaryVariable() {
        MockHistoricVariableInstanceBuilder builder = MockProvider.mockHistoricVariableInstance();
        HistoricVariableInstance variableInstanceMock = builder.typedValue((TypedValue)Variables.byteArrayValue(null)).build();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableBinaryFetching()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.singleResult()).thenReturn((Object)variableInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body("type", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)ValueType.BYTES)), new Object[0]).body("value", Matchers.nullValue(), new Object[0]).when().get(VARIABLE_INSTANCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
    }

    @Test
    public void testGetNonExistingVariableInstance() {
        String nonExistingId = "nonExistingId";
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(nonExistingId)).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableBinaryFetching()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)nonExistingId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"Historic variable instance with Id 'nonExistingId' does not exist."), new Matcher[0]).when().get(VARIABLE_INSTANCE_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.times((int)1))).disableBinaryFetching();
    }

    @Test
    public void testBinaryDataForBinaryVariable() {
        byte[] byteContent = "some bytes".getBytes();
        HistoricVariableInstance variableInstanceMock = MockProvider.mockHistoricVariableInstance().typedValue((TypedValue)Variables.byteArrayValue((byte[])byteContent)).build();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.singleResult()).thenReturn((Object)variableInstanceMock);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.BINARY.toString()).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
        byte[] responseBytes = response.getBody().asByteArray();
        Assert.assertEquals((Object)new String(byteContent), (Object)new String(responseBytes));
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).disableBinaryFetching();
    }

    @Test
    public void testGetBinaryDataForFileVariable() {
        String filename = "test.txt";
        byte[] byteContent = "test".getBytes();
        String encoding = "UTF-8";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).encoding(encoding).create();
        HistoricVariableInstance variableInstanceMock = MockProvider.mockHistoricVariableInstance().typedValue((TypedValue)variableValue).build();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.singleResult()).thenReturn((Object)variableInstanceMock);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).and().body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).header("Content-Disposition", "attachment; filename=" + filename).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
        String contentType = response.getContentType();
        Assert.assertThat((Object)contentType, (Matcher)Matchers.is((Matcher)CoreMatchers.either((Matcher)CoreMatchers.equalTo((Object)(ContentType.TEXT.toString() + "; charset=UTF-8"))).or(CoreMatchers.equalTo((Object)(ContentType.TEXT.toString() + ";charset=UTF-8")))));
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).disableBinaryFetching();
    }

    @Test
    public void testBinaryDataForNonBinaryVariable() {
        HistoricVariableInstance variableInstanceMock = MockProvider.createMockHistoricVariableInstance();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.singleResult()).thenReturn((Object)variableInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)("Value of Historic variable instance " + variableInstanceMock.getId() + " is not a binary value")), new Matcher[0]).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).disableBinaryFetching();
    }

    @Test
    public void testGetBinaryDataForNonExistingVariableInstance() {
        String nonExistingId = "nonExistingId";
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(nonExistingId)).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)nonExistingId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"Historic variable instance with Id 'nonExistingId' does not exist."), new Matcher[0]).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
        ((HistoricVariableInstanceQuery)Mockito.verify((Object)this.variableInstanceQueryMock, (VerificationMode)Mockito.never())).disableBinaryFetching();
    }

    @Test
    public void testGetBinaryDataForNullFileVariable() {
        String filename = "test.txt";
        byte[] byteContent = null;
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).create();
        HistoricVariableInstance variableInstanceMock = MockProvider.mockHistoricVariableInstance().typedValue((TypedValue)variableValue).build();
        Mockito.when((Object)this.variableInstanceQueryMock.variableId(variableInstanceMock.getId())).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.disableCustomObjectDeserialization()).thenReturn((Object)this.variableInstanceQueryMock);
        Mockito.when((Object)this.variableInstanceQueryMock.singleResult()).thenReturn((Object)variableInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aVariableInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).and().contentType(ContentType.TEXT).and().body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String())), new Matcher[0]).when().get(VARIABLE_INSTANCE_BINARY_DATA_URL, new Object[0]);
    }
}

