/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringSetConverter;
import org.camunda.bpm.engine.rest.dto.converter.VariableListConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class HistoricProcessInstanceQueryDto
extends AbstractQueryDto<HistoricProcessInstanceQuery> {
    private static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "instanceId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID_VALUE = "definitionId";
    private static final String SORT_BY_PROCESS_INSTANCE_BUSINESS_KEY_VALUE = "businessKey";
    private static final String SORT_BY_PROCESS_INSTANCE_START_TIME_VALUE = "startTime";
    private static final String SORT_BY_PROCESS_INSTANCE_END_TIME_VALUE = "endTime";
    private static final String SORT_BY_PROCESS_INSTANCE_DURATION_VALUE = "duration";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    private String processInstanceId;
    private Set<String> processInstanceIds;
    private String processDefinitionId;
    private String processDefinitionKey;
    private String processDefinitionName;
    private String processDefinitionNameLike;
    private List<String> processDefinitionKeyNotIn;
    private String processInstanceBusinessKey;
    private String processInstanceBusinessKeyLike;
    private Boolean finished;
    private Boolean unfinished;
    private Boolean withIncidents;
    private String incidentStatus;
    private String incidentMessage;
    private String incidentMessageLike;
    private Date startedBefore;
    private Date startedAfter;
    private Date finishedBefore;
    private Date finishedAfter;
    private String startedBy;
    private String superProcessInstanceId;
    private String subProcessInstanceId;
    private String superCaseInstanceId;
    private String subCaseInstanceId;
    private String caseInstanceId;
    private List<String> tenantIds;
    private List<VariableQueryParameterDto> variables;

    public HistoricProcessInstanceQueryDto() {
    }

    public HistoricProcessInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="processInstanceIds", converter=StringSetConverter.class)
    public void setProcessInstanceIds(Set<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="processDefinitionName")
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @CamundaQueryParam(value="processDefinitionNameLike")
    public void setProcessDefinitionNameLike(String processDefinitionNameLike) {
        this.processDefinitionNameLike = processDefinitionNameLike;
    }

    @CamundaQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @CamundaQueryParam(value="processDefinitionKeyNotIn", converter=StringListConverter.class)
    public void setProcessDefinitionKeyNotIn(List<String> processDefinitionKeys) {
        this.processDefinitionKeyNotIn = processDefinitionKeys;
    }

    @CamundaQueryParam(value="processInstanceBusinessKey")
    public void setProcessInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
    }

    @CamundaQueryParam(value="processInstanceBusinessKeyLike")
    public void setProcessInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
    }

    @CamundaQueryParam(value="finished", converter=BooleanConverter.class)
    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    @CamundaQueryParam(value="unfinished", converter=BooleanConverter.class)
    public void setUnfinished(Boolean unfinished) {
        this.unfinished = unfinished;
    }

    @CamundaQueryParam(value="withIncidents", converter=BooleanConverter.class)
    public void setWithIncidents(Boolean withIncidents) {
        this.withIncidents = withIncidents;
    }

    @CamundaQueryParam(value="incidentStatus")
    public void setIncidentStatus(String status) {
        this.incidentStatus = status;
    }

    @CamundaQueryParam(value="incidentMessage")
    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    @CamundaQueryParam(value="incidentMessageLike")
    public void setIncidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
    }

    @CamundaQueryParam(value="startedBefore", converter=DateConverter.class)
    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    @CamundaQueryParam(value="startedAfter", converter=DateConverter.class)
    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    @CamundaQueryParam(value="finishedBefore", converter=DateConverter.class)
    public void setFinishedBefore(Date finishedBefore) {
        this.finishedBefore = finishedBefore;
    }

    @CamundaQueryParam(value="finishedAfter", converter=DateConverter.class)
    public void setFinishedAfter(Date finishedAfter) {
        this.finishedAfter = finishedAfter;
    }

    @CamundaQueryParam(value="startedBy")
    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    @CamundaQueryParam(value="superProcessInstanceId")
    public void setSuperProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
    }

    @CamundaQueryParam(value="subProcessInstanceId")
    public void setSubProcessInstanceId(String subProcessInstanceId) {
        this.subProcessInstanceId = subProcessInstanceId;
    }

    @CamundaQueryParam(value="superCaseInstanceId")
    public void setSuperCaseInstanceId(String superCaseInstanceId) {
        this.superCaseInstanceId = superCaseInstanceId;
    }

    @CamundaQueryParam(value="subCaseInstanceId")
    public void setSubCaseInstanceId(String subCaseInstanceId) {
        this.subCaseInstanceId = subCaseInstanceId;
    }

    @CamundaQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @CamundaQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricProcessInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricProcessInstanceQuery();
    }

    @Override
    protected void applyFilters(HistoricProcessInstanceQuery query) {
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processInstanceIds != null) {
            query.processInstanceIds(this.processInstanceIds);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.processDefinitionName != null) {
            query.processDefinitionName(this.processDefinitionName);
        }
        if (this.processDefinitionNameLike != null) {
            query.processDefinitionNameLike(this.processDefinitionNameLike);
        }
        if (this.processDefinitionKeyNotIn != null) {
            query.processDefinitionKeyNotIn(this.processDefinitionKeyNotIn);
        }
        if (this.processInstanceBusinessKey != null) {
            query.processInstanceBusinessKey(this.processInstanceBusinessKey);
        }
        if (this.processInstanceBusinessKeyLike != null) {
            query.processInstanceBusinessKeyLike(this.processInstanceBusinessKeyLike);
        }
        if (this.finished != null && this.finished.booleanValue()) {
            query.finished();
        }
        if (this.unfinished != null && this.unfinished.booleanValue()) {
            query.unfinished();
        }
        if (this.withIncidents != null && this.withIncidents.booleanValue()) {
            query.withIncidents();
        }
        if (this.incidentStatus != null) {
            query.incidentStatus(this.incidentStatus);
        }
        if (this.incidentMessage != null) {
            query.incidentMessage(this.incidentMessage);
        }
        if (this.incidentMessageLike != null) {
            query.incidentMessageLike(this.incidentMessageLike);
        }
        if (this.startedBefore != null) {
            query.startedBefore(this.startedBefore);
        }
        if (this.startedAfter != null) {
            query.startedAfter(this.startedAfter);
        }
        if (this.finishedBefore != null) {
            query.finishedBefore(this.finishedBefore);
        }
        if (this.finishedAfter != null) {
            query.finishedAfter(this.finishedAfter);
        }
        if (this.startedBy != null) {
            query.startedBy(this.startedBy);
        }
        if (this.superProcessInstanceId != null) {
            query.superProcessInstanceId(this.superProcessInstanceId);
        }
        if (this.subProcessInstanceId != null) {
            query.subProcessInstanceId(this.subProcessInstanceId);
        }
        if (this.superCaseInstanceId != null) {
            query.superCaseInstanceId(this.superCaseInstanceId);
        }
        if (this.subCaseInstanceId != null) {
            query.subCaseInstanceId(this.subCaseInstanceId);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (this.variables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.variables) {
                String variableName = variableQueryParam.getName();
                String op = variableQueryParam.getOperator();
                Object variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.variableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.variableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.variableValueGreaterThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.variableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.variableValueLessThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.variableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.variableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
    }

    @Override
    protected void applySortBy(HistoricProcessInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID_VALUE)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_ID_VALUE)) {
            query.orderByProcessDefinitionId();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_BUSINESS_KEY_VALUE)) {
            query.orderByProcessInstanceBusinessKey();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_START_TIME_VALUE)) {
            query.orderByProcessInstanceStartTime();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_END_TIME_VALUE)) {
            query.orderByProcessInstanceEndTime();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_DURATION_VALUE)) {
            query.orderByProcessInstanceDuration();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_BUSINESS_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_START_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_END_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_DURATION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

