/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.SuspensionStateDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateBuilder;
import org.camunda.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateSelectBuilder;
import org.camunda.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateTenantBuilder;

public class ProcessInstanceSuspensionStateDto
extends SuspensionStateDto {
    private String processInstanceId;
    private String processDefinitionId;
    private String processDefinitionKey;
    private String processDefinitionTenantId;
    private boolean processDefinitionWithoutTenantId;

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public void setProcessDefinitionTenantId(String processDefinitionTenantId) {
        this.processDefinitionTenantId = processDefinitionTenantId;
    }

    public void setProcessDefinitionWithoutTenantId(boolean processDefinitionWithoutTenantId) {
        this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
    }

    @Override
    public void updateSuspensionState(ProcessEngine engine) {
        int params = (this.processInstanceId != null ? 1 : 0) + (this.processDefinitionId != null ? 1 : 0) + (this.processDefinitionKey != null ? 1 : 0);
        if (params > 1) {
            String message = "Only one of processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        if (params == 0) {
            String message = "Either processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        UpdateProcessInstanceSuspensionStateBuilder updateSuspensionStateBuilder = this.createUpdateSuspensionStateBuilder(engine);
        if (this.getSuspended()) {
            updateSuspensionStateBuilder.suspend();
        } else {
            updateSuspensionStateBuilder.activate();
        }
    }

    protected UpdateProcessInstanceSuspensionStateBuilder createUpdateSuspensionStateBuilder(ProcessEngine engine) {
        UpdateProcessInstanceSuspensionStateSelectBuilder selectBuilder = engine.getRuntimeService().updateProcessInstanceSuspensionState();
        if (this.processInstanceId != null) {
            return selectBuilder.byProcessInstanceId(this.processInstanceId);
        }
        if (this.processDefinitionId != null) {
            return selectBuilder.byProcessDefinitionId(this.processDefinitionId);
        }
        UpdateProcessInstanceSuspensionStateTenantBuilder tenantBuilder = selectBuilder.byProcessDefinitionKey(this.processDefinitionKey);
        if (this.processDefinitionTenantId != null) {
            tenantBuilder.processDefinitionTenantId(this.processDefinitionTenantId);
        } else if (this.processDefinitionWithoutTenantId) {
            tenantBuilder.processDefinitionWithoutTenantId();
        }
        return tenantBuilder;
    }
}

