/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.RequestSpecification;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class GroupRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String GROUP_QUERY_URL = "/rest-test/group";
    protected static final String GROUP_COUNT_QUERY_URL = "/rest-test/group/count";
    private GroupQuery mockQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockQuery = this.setUpMockGroupQuery(MockProvider.createMockGroups());
    }

    private GroupQuery setUpMockGroupQuery(List<Group> list) {
        GroupQuery sampleGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)sampleGroupQuery.list()).thenReturn(list);
        Mockito.when((Object)sampleGroupQuery.count()).thenReturn((Object)list.size());
        Mockito.when((Object)processEngine.getIdentityService().createGroupQuery()).thenReturn((Object)sampleGroupQuery);
        return sampleGroupQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("name", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(GROUP_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"name"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(GROUP_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(GROUP_QUERY_URL, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(GROUP_QUERY_URL, new Object[0]);
        ((GroupQuery)Mockito.verify((Object)this.mockQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockQuery});
    }

    @Test
    public void testSimpleGroupQuery() {
        String queryName = "group1";
        Response response = (Response)RestAssured.given().queryParam("name", new Object[]{queryName}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(GROUP_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((GroupQuery)inOrder.verify((Object)this.mockQuery)).groupName(queryName);
        ((GroupQuery)inOrder.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one group returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned group should not be null.", instances.get(0));
        String returendName = JsonPath.from((String)content).getString("[0].name");
        String returendType = JsonPath.from((String)content).getString("[0].type");
        Assert.assertEquals((Object)"group1", (Object)returendName);
        Assert.assertEquals((Object)"organizational-unit", (Object)returendType);
    }

    @Test
    public void testCompleteGetParameters() {
        Map<String, String> queryParameters = this.getCompleteStringQueryParameters();
        RequestSpecification requestSpecification = RestAssured.given().contentType(POST_JSON_CONTENT_TYPE);
        for (Map.Entry<String, String> paramEntry : queryParameters.entrySet()) {
            requestSpecification.parameter(paramEntry.getKey(), new Object[]{paramEntry.getValue()});
        }
        requestSpecification.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(GROUP_QUERY_URL, new Object[0]);
        ((GroupQuery)Mockito.verify((Object)this.mockQuery)).groupName("group1");
        ((GroupQuery)Mockito.verify((Object)this.mockQuery)).groupNameLike("%group1%");
        ((GroupQuery)Mockito.verify((Object)this.mockQuery)).groupType("organizational-unit");
        ((GroupQuery)Mockito.verify((Object)this.mockQuery)).groupMember("userId");
        ((GroupQuery)Mockito.verify((Object)this.mockQuery)).memberOfTenant("aTenantId");
        ((GroupQuery)Mockito.verify((Object)this.mockQuery)).list();
    }

    private Map<String, String> getCompleteStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", "group1");
        parameters.put("nameLike", "%group1%");
        parameters.put("type", "organizational-unit");
        parameters.put("member", "userId");
        parameters.put("memberOfTenant", "aTenantId");
        return parameters;
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(GROUP_COUNT_QUERY_URL, new Object[0]);
        ((GroupQuery)Mockito.verify((Object)this.mockQuery)).count();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(GROUP_QUERY_URL, new Object[0]);
        ((GroupQuery)Mockito.verify((Object)this.mockQuery)).listPage(firstResult, maxResults);
    }
}

