/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.fest.assertions.Assertions;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class JobRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String JOBS_RESOURCE_URL = "/rest-test/job";
    protected static final String JOBS_QUERY_COUNT_URL = "/rest-test/job/count";
    private JobQuery mockQuery;
    private static final int MAX_RESULTS_TEN = 10;
    private static final int FIRST_RESULTS_ZERO = 0;
    protected static final long JOB_QUERY_MAX_PRIORITY = Long.MAX_VALUE;
    protected static final long JOB_QUERY_MIN_PRIORITY = Long.MIN_VALUE;

    @Before
    public void setUpRuntimeData() {
        this.mockQuery = this.setUpMockJobQuery(MockProvider.createMockJobs());
    }

    private JobQuery setUpMockJobQuery(List<Job> mockedJobs) {
        JobQuery sampleJobQuery = (JobQuery)Mockito.mock(JobQuery.class);
        Mockito.when((Object)sampleJobQuery.list()).thenReturn(mockedJobs);
        Mockito.when((Object)sampleJobQuery.count()).thenReturn((Object)mockedJobs.size());
        Mockito.when((Object)processEngine.getManagementService().createJobQuery()).thenReturn((Object)sampleJobQuery);
        return sampleJobQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryJobId = "";
        RestAssured.given().queryParam("id", new Object[]{queryJobId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOBS_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOBS_RESOURCE_URL, new Object[0]);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockQuery});
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"jobDueDate"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(JOBS_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(JOBS_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSimpleJobQuery() {
        String jobId = "aJobId";
        Response response = (Response)RestAssured.given().queryParam("jobId", new Object[]{jobId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOBS_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).jobId(jobId);
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one job returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned job should not be null.", instances.get(0));
        String returnedJobId = JsonPath.from((String)content).getString("[0].id");
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        String returnedExecutionId = JsonPath.from((String)content).getString("[0].executionId");
        String returnedExceptionMessage = JsonPath.from((String)content).getString("[0].exceptionMessage");
        int returnedRetries = JsonPath.from((String)content).getInt("[0].retries");
        Date returnedDueDate = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].dueDate"));
        boolean returnedSuspended = JsonPath.from((String)content).getBoolean("[0].suspended");
        long returnedPriority = JsonPath.from((String)content).getLong("[0].priority");
        String returnedJobDefinitionId = JsonPath.from((String)content).getString("[0].jobDefinitionId");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assert.assertEquals((Object)"aJobId", (Object)returnedJobId);
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)"aKey", (Object)returnedProcessDefinitionKey);
        Assert.assertEquals((Object)"anExecutionId", (Object)returnedExecutionId);
        Assert.assertEquals((Object)"", (Object)returnedExceptionMessage);
        Assert.assertEquals((long)3L, (long)returnedRetries);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)"2013-04-23T13:42:43"), (Object)returnedDueDate);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_JOB_IS_SUSPENDED, (Object)returnedSuspended);
        Assert.assertEquals((long)2147483689L, (long)returnedPriority);
        Assert.assertEquals((Object)"aJobDefId", (Object)returnedJobDefinitionId);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
    }

    @Test
    public void testInvalidDueDateComparator() {
        String variableValue = "2013-05-05T00:00:00";
        String invalidComparator = "bt";
        String queryValue = invalidComparator + "_" + variableValue;
        RestAssured.given().queryParam("dueDates", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Invalid due date comparator specified: " + invalidComparator)), new Object[0]).when().get(JOBS_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testInvalidDueDateComperatorAsPost() {
        String invalidComparator = "bt";
        HashMap<String, String> conditionJson = new HashMap<String, String>();
        conditionJson.put("operator", invalidComparator);
        conditionJson.put("value", "2013-05-05T00:00:00");
        ArrayList<HashMap<String, String>> conditions = new ArrayList<HashMap<String, String>>();
        conditions.add(conditionJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("dueDates", conditions);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Invalid due date comparator specified: " + invalidComparator)), new Object[0]).when().post(JOBS_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testInvalidDueDate() {
        String variableValue = "invalidValue";
        String invalidComparator = "lt";
        String queryValue = invalidComparator + "_" + variableValue;
        RestAssured.given().queryParam("dueDates", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Invalid due date format: Cannot convert value \"invalidValue\" to java type java.util.Date"), new Object[0]).when().get(JOBS_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testInvalidDueDateAsPost() {
        HashMap<String, String> conditionJson = new HashMap<String, String>();
        conditionJson.put("operator", "lt");
        conditionJson.put("value", "invalidValue");
        ArrayList<HashMap<String, String>> conditions = new ArrayList<HashMap<String, String>>();
        conditions.add(conditionJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("dueDates", conditions);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Invalid due date format: Cannot convert value \"invalidValue\" to java type java.util.Date"), new Object[0]).when().post(JOBS_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testAdditionalParametersExcludingDueDates() {
        Map<String, Object> parameters = this.getCompleteParameters();
        RestAssured.given().queryParams(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOBS_RESOURCE_URL, new Object[0]);
        this.verifyParameterQueryInvocations();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).list();
    }

    @Test
    public void testMessagesParameter() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("messages", MockProvider.EXAMPLE_MESSAGES);
        RestAssured.given().queryParams(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOBS_RESOURCE_URL, new Object[0]);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).messages();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).list();
    }

    @Test
    public void testMessagesTimersParameter() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("messages", MockProvider.EXAMPLE_MESSAGES);
        parameters.put("timers", MockProvider.EXAMPLE_TIMERS);
        RestAssured.given().queryParams(parameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Parameter timers cannot be used together with parameter messages."), new Object[0]).when().get(JOBS_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testMessagesTimersParameterAsPost() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("messages", MockProvider.EXAMPLE_MESSAGES);
        parameters.put("timers", MockProvider.EXAMPLE_TIMERS);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Parameter timers cannot be used together with parameter messages."), new Object[0]).when().post(JOBS_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testMessagesParameterAsPost() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("messages", MockProvider.EXAMPLE_MESSAGES);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_RESOURCE_URL, new Object[0]);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).messages();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).list();
    }

    private Map<String, Object> getCompleteParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("activityId", "anActivity");
        parameters.put("jobId", "aJobId");
        parameters.put("processInstanceId", "aProcInstId");
        parameters.put("processDefinitionId", "aProcDefId");
        parameters.put("processDefinitionKey", "aKey");
        parameters.put("executionId", "anExecutionId");
        parameters.put("withRetriesLeft", MockProvider.EXAMPLE_WITH_RETRIES_LEFT);
        parameters.put("executable", MockProvider.EXAMPLE_EXECUTABLE);
        parameters.put("timers", MockProvider.EXAMPLE_TIMERS);
        parameters.put("withException", MockProvider.EXAMPLE_WITH_EXCEPTION);
        parameters.put("exceptionMessage", "aExceptionMessage");
        parameters.put("noRetriesLeft", MockProvider.EXAMPLE_NO_RETRIES_LEFT);
        parameters.put("active", true);
        parameters.put("suspended", true);
        parameters.put("priorityLowerThanOrEquals", Long.MAX_VALUE);
        parameters.put("priorityHigherThanOrEquals", Long.MIN_VALUE);
        parameters.put("jobDefinitionId", "aJobDefId");
        return parameters;
    }

    @Test
    public void testAdditionalParametersExcludingDueDatesAsPost() {
        Map<String, Object> parameters = this.getCompleteParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_RESOURCE_URL, new Object[0]);
        this.verifyParameterQueryInvocations();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).list();
    }

    private void verifyParameterQueryInvocations() {
        Map<String, Object> parameters = this.getCompleteParameters();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).jobId((String)parameters.get("jobId"));
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).processInstanceId((String)parameters.get("processInstanceId"));
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).processDefinitionId((String)parameters.get("processDefinitionId"));
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).processDefinitionKey((String)parameters.get("processDefinitionKey"));
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).executionId((String)parameters.get("executionId"));
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).activityId((String)parameters.get("activityId"));
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).withRetriesLeft();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).executable();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).timers();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).withException();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).exceptionMessage((String)parameters.get("exceptionMessage"));
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).noRetriesLeft();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).active();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).suspended();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).priorityLowerThanOrEquals(Long.MAX_VALUE);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).priorityHigherThanOrEquals(Long.MIN_VALUE);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).jobDefinitionId("aJobDefId");
    }

    @Test
    public void testDueDateParameters() {
        String variableValue = "2013-05-05T00:00:00";
        Date date = DateTimeUtil.parseDate((String)variableValue);
        String queryValue = "lt_" + variableValue;
        RestAssured.given().queryParam("dueDates", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOBS_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).duedateLowerThan(date);
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).list();
        queryValue = "gt_" + variableValue;
        RestAssured.given().queryParam("dueDates", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOBS_RESOURCE_URL, new Object[0]);
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).duedateHigherThan(date);
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).list();
    }

    @Test
    public void testDueDateParametersAsPost() {
        String value = "2013-05-18T00:00:00";
        String anotherValue = "2013-05-05T00:00:00";
        Date date = DateTimeUtil.parseDate((String)value);
        Date anotherDate = DateTimeUtil.parseDate((String)anotherValue);
        HashMap<String, String> conditionJson = new HashMap<String, String>();
        conditionJson.put("operator", "lt");
        conditionJson.put("value", value);
        HashMap<String, String> anotherConditionJson = new HashMap<String, String>();
        anotherConditionJson.put("operator", "gt");
        anotherConditionJson.put("value", anotherValue);
        ArrayList<HashMap<String, String>> conditions = new ArrayList<HashMap<String, String>>();
        conditions.add(conditionJson);
        conditions.add(anotherConditionJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("dueDates", conditions);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_RESOURCE_URL, new Object[0]);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).duedateHigherThan(anotherDate);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).duedateLowerThan(date);
    }

    @Test
    public void testMultipleDueDateParameters() {
        String variableValue1 = "2012-05-05T00:00:00";
        String variableParameter1 = "gt_" + variableValue1;
        String variableValue2 = "2013-02-02T00:00:00";
        String variableParameter2 = "lt_" + variableValue2;
        Date date = DateTimeUtil.parseDate((String)variableValue1);
        Date anotherDate = DateTimeUtil.parseDate((String)variableValue2);
        String queryValue = variableParameter1 + "," + variableParameter2;
        RestAssured.given().queryParam("dueDates", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOBS_RESOURCE_URL, new Object[0]);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).duedateHigherThan(date);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).duedateLowerThan(anotherDate);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("jobId", "desc", Response.Status.OK);
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).orderByJobId();
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("processInstanceId", "asc", Response.Status.OK);
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).orderByProcessInstanceId();
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("executionId", "desc", Response.Status.OK);
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).orderByExecutionId();
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("jobRetries", "asc", Response.Status.OK);
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).orderByJobRetries();
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("jobDueDate", "desc", Response.Status.OK);
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).orderByJobDuedate();
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("jobPriority", "asc", Response.Status.OK);
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).orderByJobPriority();
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).orderByTenantId();
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).orderByTenantId();
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).desc();
    }

    private void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(JOBS_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", OrderingBuilder.create().orderBy("jobRetries").desc().orderBy("jobDueDate").asc().getJson());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_RESOURCE_URL, new Object[0]);
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).orderByJobRetries();
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).desc();
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).orderByJobDuedate();
        ((JobQuery)inOrder.verify((Object)this.mockQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOBS_RESOURCE_URL, new Object[0]);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testQueryCount() {
        RestAssured.given().header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(JOBS_QUERY_COUNT_URL, new Object[0]);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).count();
    }

    @Test
    public void testQueryCountForPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(JOBS_QUERY_COUNT_URL, new Object[0]);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).count();
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockQuery = this.setUpMockJobQuery(this.createMockJobsTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOBS_RESOURCE_URL, new Object[0]);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List jobs = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)jobs).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testWithoutTenantIdParameter() {
        Job mockJob = MockProvider.mockJob().tenantId(null).build();
        this.mockQuery = this.setUpMockJobQuery(Arrays.asList(mockJob));
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOBS_RESOURCE_URL, new Object[0]);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).withoutTenantId();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List jobs = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)jobs).hasSize(1);
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    @Test
    public void testIncludeJobsWithoutTenantIdParameter() {
        List<Job> jobs = Arrays.asList(MockProvider.mockJob().tenantId(null).build(), MockProvider.mockJob().tenantId("aTenantId").build());
        this.mockQuery = this.setUpMockJobQuery(jobs);
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId"}).queryParam("includeJobsWithoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOBS_RESOURCE_URL, new Object[0]);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).tenantIdIn(new String[]{"aTenantId"});
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).includeJobsWithoutTenantId();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"aTenantId");
    }

    @Test
    public void testTenantIdListPostParameter() {
        this.mockQuery = this.setUpMockJobQuery(this.createMockJobsTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_RESOURCE_URL, new Object[0]);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List jobs = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)jobs).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testWithoutTenantIdPostParameter() {
        Job mockJob = MockProvider.mockJob().tenantId(null).build();
        this.mockQuery = this.setUpMockJobQuery(Arrays.asList(mockJob));
        HashMap<String, Boolean> queryParameters = new HashMap<String, Boolean>();
        queryParameters.put("withoutTenantId", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_RESOURCE_URL, new Object[0]);
        String content = response.asString();
        List jobs = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)jobs).hasSize(1);
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    @Test
    public void testIncludeJobsWithoutTenantIdPostParameter() {
        List<Job> jobs = Arrays.asList(MockProvider.mockJob().tenantId(null).build(), MockProvider.mockJob().tenantId("aTenantId").build());
        this.mockQuery = this.setUpMockJobQuery(jobs);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("tenantIdIn", new String[]{"aTenantId"});
        queryParameters.put("includeJobsWithoutTenantId", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOBS_RESOURCE_URL, new Object[0]);
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).tenantIdIn(new String[]{"aTenantId"});
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).includeJobsWithoutTenantId();
        ((JobQuery)Mockito.verify((Object)this.mockQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"aTenantId");
    }

    private List<Job> createMockJobsTwoTenants() {
        return Arrays.asList(MockProvider.mockJob().tenantId("aTenantId").build(), MockProvider.mockJob().tenantId("anotherTenantId").build());
    }
}

