/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstanceQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class HistoricCaseActivityInstanceRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_CASE_ACTIVITY_INSTANCE_URL = "/rest-test/history/case-activity-instance";
    protected static final String HISTORIC_SINGLE_CASE_ACTIVITY_INSTANCE_URL = "/rest-test/history/case-activity-instance/{id}";
    protected HistoryService historyServiceMock;
    protected HistoricCaseActivityInstance historicInstanceMock;
    protected HistoricCaseActivityInstanceQuery historicQueryMock;

    @Before
    public void setUpRuntimeData() {
        this.historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
        this.historicInstanceMock = MockProvider.createMockHistoricCaseActivityInstance();
        this.historicQueryMock = (HistoricCaseActivityInstanceQuery)Mockito.mock(HistoricCaseActivityInstanceQuery.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricCaseActivityInstanceQuery()).thenReturn((Object)this.historicQueryMock);
        Mockito.when((Object)this.historicQueryMock.caseActivityInstanceId(Matchers.anyString())).thenReturn((Object)this.historicQueryMock);
        Mockito.when((Object)this.historicQueryMock.singleResult()).thenReturn((Object)this.historicInstanceMock);
    }

    @Test
    public void testGetSingleHistoricCaseInstance() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aCaseActivityInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_CASE_ACTIVITY_INSTANCE_URL, new Object[0]);
        String content = response.asString();
        String returnedCaseActivityInstanceId = JsonPath.from((String)content).getString("id");
        String returnedParentCaseActivityInstanceId = JsonPath.from((String)content).getString("parentCaseActivityInstanceId");
        String returnedCaseActivityId = JsonPath.from((String)content).getString("caseActivityId");
        String returnedCaseActivityName = JsonPath.from((String)content).getString("caseActivityName");
        String returnedCaseActivityType = JsonPath.from((String)content).getString("caseActivityType");
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("caseDefinitionId");
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("caseInstanceId");
        String returnedCaseExecutionId = JsonPath.from((String)content).getString("caseExecutionId");
        String returnedTaskId = JsonPath.from((String)content).getString("taskId");
        String returnedCalledProcessInstanceId = JsonPath.from((String)content).getString("calledProcessInstanceId");
        String returnedCalledCaseInstanceId = JsonPath.from((String)content).getString("calledCaseInstanceId");
        String returnedCreateTime = JsonPath.from((String)content).getString("createTime");
        String returnedEndTime = JsonPath.from((String)content).getString("endTime");
        String returnedTenantId = JsonPath.from((String)content).getString("tenantId");
        long returnedDurationInMillis = JsonPath.from((String)content).getLong("durationInMillis");
        boolean required = JsonPath.from((String)content).getBoolean("required");
        boolean available = JsonPath.from((String)content).getBoolean("available");
        boolean enabled = JsonPath.from((String)content).getBoolean("enabled");
        boolean disabled = JsonPath.from((String)content).getBoolean("disabled");
        boolean active = JsonPath.from((String)content).getBoolean("active");
        boolean completed = JsonPath.from((String)content).getBoolean("completed");
        boolean terminated = JsonPath.from((String)content).getBoolean("terminated");
        Assert.assertEquals((Object)"aCaseActivityInstanceId", (Object)returnedCaseActivityInstanceId);
        Assert.assertEquals((Object)"aParentCaseActivityId", (Object)returnedParentCaseActivityInstanceId);
        Assert.assertEquals((Object)"aCaseActivityId", (Object)returnedCaseActivityId);
        Assert.assertEquals((Object)"aCaseActivityName", (Object)returnedCaseActivityName);
        Assert.assertEquals((Object)"aCaseActivityType", (Object)returnedCaseActivityType);
        Assert.assertEquals((Object)"aCaseDefnitionId", (Object)returnedCaseDefinitionId);
        Assert.assertEquals((Object)"aCaseInstId", (Object)returnedCaseInstanceId);
        Assert.assertEquals((Object)"aCaseExecutionId", (Object)returnedCaseExecutionId);
        Assert.assertEquals((Object)"anId", (Object)returnedTaskId);
        Assert.assertEquals((Object)"aCalledProcessInstanceId", (Object)returnedCalledProcessInstanceId);
        Assert.assertEquals((Object)"aCalledCaseInstanceId", (Object)returnedCalledCaseInstanceId);
        Assert.assertEquals((Object)"2014-04-23T18:42:42", (Object)returnedCreateTime);
        Assert.assertEquals((Object)"2014-04-23T18:42:43", (Object)returnedEndTime);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
        Assert.assertEquals((long)2000L, (long)returnedDurationInMillis);
        Assert.assertEquals((Object)true, (Object)required);
        Assert.assertEquals((Object)true, (Object)available);
        Assert.assertEquals((Object)true, (Object)enabled);
        Assert.assertEquals((Object)true, (Object)disabled);
        Assert.assertEquals((Object)true, (Object)active);
        Assert.assertEquals((Object)true, (Object)completed);
        Assert.assertEquals((Object)true, (Object)terminated);
    }

    @Test
    public void testGetNonExistingHistoricCaseInstance() {
        Mockito.when((Object)this.historicQueryMock.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"nonExistingId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Historic case activity instance with id 'nonExistingId' does not exist"), new Object[0]).when().get(HISTORIC_SINGLE_CASE_ACTIVITY_INSTANCE_URL, new Object[0]);
    }
}

