/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricJobLogQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class HistoricJobLogRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_JOB_LOG_RESOURCE_URL = "/rest-test/history/job-log";
    protected static final String SINGLE_HISTORIC_JOB_LOG_RESOURCE_URL = "/rest-test/history/job-log/{id}";
    protected static final String HISTORIC_JOB_LOG_RESOURCE_GET_STACKTRACE_URL = "/rest-test/history/job-log/{id}/stacktrace";
    protected ProcessEngine namedProcessEngine;
    protected HistoryService mockHistoryService;
    protected HistoricJobLogQuery mockQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockQuery = (HistoricJobLogQuery)Mockito.mock(HistoricJobLogQuery.class);
        HistoricJobLog mockedHistoricJobLog = MockProvider.createMockHistoricJobLog();
        Mockito.when((Object)this.mockQuery.singleResult()).thenReturn((Object)mockedHistoricJobLog);
        Mockito.when((Object)this.mockQuery.logId("aHistoricJobLogId")).thenReturn((Object)this.mockQuery);
        this.mockHistoryService = (HistoryService)Mockito.mock(HistoryService.class);
        Mockito.when((Object)this.mockHistoryService.createHistoricJobLogQuery()).thenReturn((Object)this.mockQuery);
        this.namedProcessEngine = this.getProcessEngine("default");
        Mockito.when((Object)this.namedProcessEngine.getHistoryService()).thenReturn((Object)this.mockHistoryService);
    }

    @Test
    public void testSimpleHistoricJobLogGet() {
        RestAssured.given().pathParam("id", (Object)"aHistoricJobLogId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aHistoricJobLogId"), new Object[0]).body("timestamp", Matchers.equalTo((Object)"2015-01-01T00:00:00"), new Object[0]).body("jobId", Matchers.equalTo((Object)"aJobId"), new Object[0]).body("jobDueDate", Matchers.equalTo((Object)"2015-10-01T00:00:00"), new Object[0]).body("jobRetries", Matchers.equalTo((Object)5), new Object[0]).body("jobPriority", Matchers.equalTo((Object)2147483689L), new Object[0]).body("jobExceptionMessage", Matchers.equalTo((Object)"aJobExceptionMsg"), new Object[0]).body("jobDefinitionId", Matchers.equalTo((Object)"aJobDefId"), new Object[0]).body("jobDefinitionType", Matchers.equalTo((Object)"aJobDefType"), new Object[0]).body("jobDefinitionConfiguration", Matchers.equalTo((Object)"aJobDefConfig"), new Object[0]).body("activityId", Matchers.equalTo((Object)"anActId"), new Object[0]).body("executionId", Matchers.equalTo((Object)"anExecId"), new Object[0]).body("processInstanceId", Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("processDefinitionId", Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("processDefinitionKey", Matchers.equalTo((Object)"aProcDefKey"), new Object[0]).body("deploymentId", Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).body("tenantId", Matchers.equalTo((Object)"aTenantId"), new Object[0]).body("creationLog", Matchers.equalTo((Object)true), new Object[0]).body("failureLog", Matchers.equalTo((Object)true), new Object[0]).body("successLog", Matchers.equalTo((Object)true), new Object[0]).body("deletionLog", Matchers.equalTo((Object)true), new Object[0]).when().get(SINGLE_HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockQuery)).logId("aHistoricJobLogId");
        ((HistoricJobLogQuery)inOrder.verify((Object)this.mockQuery)).singleResult();
    }

    @Test
    public void testHistoricJobLogGetIdDoesntExist() {
        String id = "nonExistingId";
        HistoricJobLogQuery invalidQueryNonExistingHistoricJobLog = (HistoricJobLogQuery)Mockito.mock(HistoricJobLogQuery.class);
        Mockito.when((Object)this.mockHistoryService.createHistoricJobLogQuery().logId(id)).thenReturn((Object)invalidQueryNonExistingHistoricJobLog);
        Mockito.when((Object)invalidQueryNonExistingHistoricJobLog.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)id).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Historic job log with id " + id + " does not exist")), new Object[0]).when().get(SINGLE_HISTORIC_JOB_LOG_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testGetStacktrace() {
        String stacktrace = "aStacktrace";
        Mockito.when((Object)this.mockHistoryService.getHistoricJobLogExceptionStacktrace("aHistoricJobLogId")).thenReturn((Object)stacktrace);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aHistoricJobLogId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT).when().get(HISTORIC_JOB_LOG_RESOURCE_GET_STACKTRACE_URL, new Object[0]);
        String content = response.asString();
        Assert.assertEquals((Object)stacktrace, (Object)content);
    }

    @Test
    public void testGetStacktraceJobNotFound() {
        String exceptionMessage = "historic job log not found";
        ((HistoryService)Mockito.doThrow((Throwable)new ProcessEngineException(exceptionMessage)).when((Object)this.mockHistoryService)).getHistoricJobLogExceptionStacktrace("aHistoricJobLogId");
        RestAssured.given().pathParam("id", (Object)"aHistoricJobLogId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)exceptionMessage), new Object[0]).when().get(HISTORIC_JOB_LOG_RESOURCE_GET_STACKTRACE_URL, new Object[0]);
    }

    @Test
    public void testGetStacktraceThrowsAuthorizationException() {
        String exceptionMessage = "expected exception";
        ((HistoryService)Mockito.doThrow((Throwable)new AuthorizationException(exceptionMessage)).when((Object)this.mockHistoryService)).getHistoricJobLogExceptionStacktrace("aHistoricJobLogId");
        RestAssured.given().pathParam("id", (Object)"aHistoricJobLogId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)exceptionMessage), new Object[0]).when().get(HISTORIC_JOB_LOG_RESOURCE_GET_STACKTRACE_URL, new Object[0]);
    }
}

