/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.Job;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class HistoryRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORY_CLEANUP_ASYNC_URL = "/rest-test/history/cleanup";
    private HistoryService historyServiceMock;

    @Before
    public void setUpRuntimeData() {
        this.historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        Job mockJob = MockProvider.createMockJob();
        Mockito.when((Object)this.historyServiceMock.cleanUpHistoryAsync(Matchers.anyBoolean())).thenReturn((Object)mockJob);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
    }

    @Test
    public void testHistoryCleanupImmediatelyDueDefault() {
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORY_CLEANUP_ASYNC_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).cleanUpHistoryAsync(true);
    }

    @Test
    public void testHistoryCleanupImmediatelyDue() {
        RestAssured.given().contentType(ContentType.JSON).queryParam("immediatelyDue", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORY_CLEANUP_ASYNC_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).cleanUpHistoryAsync(true);
    }

    @Test
    public void testHistoryCleanup() {
        RestAssured.given().contentType(ContentType.JSON).queryParam("immediatelyDue", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORY_CLEANUP_ASYNC_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).cleanUpHistoryAsync(false);
    }
}

