/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class HistoricVariableInstanceQueryDto
extends AbstractQueryDto<HistoricVariableInstanceQuery> {
    private static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "instanceId";
    private static final String SORT_BY_VARIABLE_NAME_VALUE = "variableName";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String processInstanceId;
    protected String caseInstanceId;
    protected String variableName;
    protected String variableNameLike;
    protected Object variableValue;
    protected String[] variableTypeIn;
    protected String[] executionIdIn;
    protected String[] taskIdIn;
    protected String[] activityInstanceIdIn;
    protected String[] caseExecutionIdIn;
    protected String[] caseActivityIdIn;
    protected String[] processInstanceIdIn;
    protected List<String> tenantIds;

    public HistoricVariableInstanceQueryDto() {
    }

    public HistoricVariableInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @CamundaQueryParam(value="variableName")
    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    @CamundaQueryParam(value="variableNameLike")
    public void setVariableNameLike(String variableNameLike) {
        this.variableNameLike = variableNameLike;
    }

    @CamundaQueryParam(value="variableValue")
    public void setVariableValue(Object variableValue) {
        this.variableValue = variableValue;
    }

    @CamundaQueryParam(value="variableTypeIn", converter=StringArrayConverter.class)
    public void setVariableTypeIn(String[] variableTypeIn) {
        this.variableTypeIn = variableTypeIn;
    }

    @CamundaQueryParam(value="executionIdIn", converter=StringArrayConverter.class)
    public void setExecutionIdIn(String[] executionIdIn) {
        this.executionIdIn = executionIdIn;
    }

    @CamundaQueryParam(value="taskIdIn", converter=StringArrayConverter.class)
    public void setTaskIdIn(String[] taskIdIn) {
        this.taskIdIn = taskIdIn;
    }

    @CamundaQueryParam(value="processInstanceIdIn", converter=StringArrayConverter.class)
    public void setProcessInstanceIdIn(String[] processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    @CamundaQueryParam(value="activityInstanceIdIn", converter=StringArrayConverter.class)
    public void setActivityInstanceIdIn(String[] activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    @CamundaQueryParam(value="caseExecutionIdIn", converter=StringArrayConverter.class)
    public void setCaseExecutionIdIn(String[] caseExecutionIdIn) {
        this.caseExecutionIdIn = caseExecutionIdIn;
    }

    @CamundaQueryParam(value="caseActivityIdIn", converter=StringArrayConverter.class)
    public void setCaseActivityIdIn(String[] caseActivityIdIn) {
        this.caseActivityIdIn = caseActivityIdIn;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricVariableInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricVariableInstanceQuery();
    }

    @Override
    protected void applyFilters(HistoricVariableInstanceQuery query) {
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.variableName != null) {
            query.variableName(this.variableName);
        }
        if (this.variableNameLike != null) {
            query.variableNameLike(this.variableNameLike);
        }
        if (this.variableValue != null) {
            if (this.variableName != null) {
                query.variableValueEquals(this.variableName, this.variableValue);
            } else {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Only a single variable value parameter specified: variable name and value are required to be able to query after a specific variable value.");
            }
        }
        if (this.variableTypeIn != null && this.variableTypeIn.length > 0) {
            query.variableTypeIn(this.variableTypeIn);
        }
        if (this.executionIdIn != null && this.executionIdIn.length > 0) {
            query.executionIdIn(this.executionIdIn);
        }
        if (this.taskIdIn != null && this.taskIdIn.length > 0) {
            query.taskIdIn(this.taskIdIn);
        }
        if (this.processInstanceIdIn != null && this.processInstanceIdIn.length > 0) {
            query.processInstanceIdIn(this.processInstanceIdIn);
        }
        if (this.activityInstanceIdIn != null && this.activityInstanceIdIn.length > 0) {
            query.activityInstanceIdIn(this.activityInstanceIdIn);
        }
        if (this.caseExecutionIdIn != null && this.caseExecutionIdIn.length > 0) {
            query.caseExecutionIdIn(this.caseExecutionIdIn);
        }
        if (this.caseActivityIdIn != null && this.caseActivityIdIn.length > 0) {
            query.caseActivityIdIn(this.caseActivityIdIn);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
    }

    @Override
    protected void applySortBy(HistoricVariableInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID_VALUE)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_VARIABLE_NAME_VALUE)) {
            query.orderByVariableName();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_VARIABLE_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

