/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.converter;

import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.history.DurationReportResult;
import org.camunda.bpm.engine.history.ReportResult;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class ReportResultToCsvConverter {
    protected static String DELIMITER = ",";
    protected static String NEW_LINE_SEPARATOR = "\n";
    public static String DURATION_HEADER = "PERIOD" + DELIMITER + "PERIOD_UNIT" + DELIMITER + "MINIMUM" + DELIMITER + "MAXIMUM" + DELIMITER + "AVERAGE";

    public static String convertReportResult(List<ReportResult> reports, String reportType) {
        if ("duration".equals(reportType)) {
            return ReportResultToCsvConverter.convertDurationReportResult(reports);
        }
        throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Unkown report type " + reportType);
    }

    protected static String convertDurationReportResult(List<ReportResult> reports) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(DURATION_HEADER);
        for (ReportResult report : reports) {
            DurationReportResult durationReport = (DurationReportResult)report;
            buffer.append(NEW_LINE_SEPARATOR);
            buffer.append(durationReport.getPeriod());
            buffer.append(DELIMITER);
            buffer.append(durationReport.getPeriodUnit().toString());
            buffer.append(DELIMITER);
            buffer.append(durationReport.getMinimum());
            buffer.append(DELIMITER);
            buffer.append(durationReport.getMaximum());
            buffer.append(DELIMITER);
            buffer.append(durationReport.getAverage());
        }
        return buffer.toString();
    }
}

