/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringSetConverter;
import org.camunda.bpm.engine.rest.dto.converter.VariableListConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;

public class ProcessInstanceQueryDto
extends AbstractQueryDto<ProcessInstanceQuery> {
    private static final String SORT_BY_INSTANCE_ID_VALUE = "instanceId";
    private static final String SORT_BY_DEFINITION_KEY_VALUE = "definitionKey";
    private static final String SORT_BY_DEFINITION_ID_VALUE = "definitionId";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final String SORT_BY_BUSINESS_KEY = "businessKey";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    private String deploymentId;
    private String processDefinitionKey;
    private String businessKey;
    private String businessKeyLike;
    private String caseInstanceId;
    private String processDefinitionId;
    private String superProcessInstance;
    private String subProcessInstance;
    private String superCaseInstance;
    private String subCaseInstance;
    private Boolean active;
    private Boolean suspended;
    private Set<String> processInstanceIds;
    private String incidentId;
    private String incidentType;
    private String incidentMessage;
    private String incidentMessageLike;
    private List<String> tenantIds;
    private Boolean withoutTenantId;
    private List<String> activityIds;
    private List<VariableQueryParameterDto> variables;

    public ProcessInstanceQueryDto() {
    }

    public ProcessInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    public Set<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    @CamundaQueryParam(value="processInstanceIds", converter=StringSetConverter.class)
    public void setProcessInstanceIds(Set<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    @CamundaQueryParam(value="deploymentId")
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @CamundaQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    @CamundaQueryParam(value="businessKey")
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public String getBusinessKeyLike() {
        return this.businessKeyLike;
    }

    @CamundaQueryParam(value="businessKeyLike")
    public void setBusinessKeyLike(String businessKeyLike) {
        this.businessKeyLike = businessKeyLike;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    @CamundaQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getSuperProcessInstance() {
        return this.superProcessInstance;
    }

    @CamundaQueryParam(value="superProcessInstance")
    public void setSuperProcessInstance(String superProcessInstance) {
        this.superProcessInstance = superProcessInstance;
    }

    public String getSubProcessInstance() {
        return this.subProcessInstance;
    }

    @CamundaQueryParam(value="subProcessInstance")
    public void setSubProcessInstance(String subProcessInstance) {
        this.subProcessInstance = subProcessInstance;
    }

    public String getSuperCaseInstance() {
        return this.superCaseInstance;
    }

    @CamundaQueryParam(value="superCaseInstance")
    public void setSuperCaseInstance(String superCaseInstance) {
        this.superCaseInstance = superCaseInstance;
    }

    public String getSubCaseInstance() {
        return this.subCaseInstance;
    }

    @CamundaQueryParam(value="subCaseInstance")
    public void setSubCaseInstance(String subCaseInstance) {
        this.subCaseInstance = subCaseInstance;
    }

    public Boolean isActive() {
        return this.active;
    }

    @CamundaQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public Boolean isSuspended() {
        return this.suspended;
    }

    @CamundaQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public List<VariableQueryParameterDto> getVariables() {
        return this.variables;
    }

    @CamundaQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    public String getIncidentId() {
        return this.incidentId;
    }

    @CamundaQueryParam(value="incidentId")
    public void setIncidentId(String incidentId) {
        this.incidentId = incidentId;
    }

    public String getIncidentType() {
        return this.incidentType;
    }

    @CamundaQueryParam(value="incidentType")
    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    @CamundaQueryParam(value="incidentMessage")
    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    public String getIncidentMessageLike() {
        return this.incidentMessageLike;
    }

    @CamundaQueryParam(value="incidentMessageLike")
    public void setIncidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
    }

    public List<String> getTenantIdIn() {
        return this.tenantIds;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    public Boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    @CamundaQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public List<String> getActivityIds() {
        return this.activityIds;
    }

    @CamundaQueryParam(value="activityIdIn", converter=StringListConverter.class)
    public void setActivityIdIn(List<String> activityIds) {
        this.activityIds = activityIds;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected ProcessInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getRuntimeService().createProcessInstanceQuery();
    }

    @Override
    protected void applyFilters(ProcessInstanceQuery query) {
        if (this.processInstanceIds != null) {
            query.processInstanceIds(this.processInstanceIds);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.deploymentId != null) {
            query.deploymentId(this.deploymentId);
        }
        if (this.businessKey != null) {
            query.processInstanceBusinessKey(this.businessKey);
        }
        if (this.businessKeyLike != null) {
            query.processInstanceBusinessKeyLike(this.businessKeyLike);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.superProcessInstance != null) {
            query.superProcessInstanceId(this.superProcessInstance);
        }
        if (this.subProcessInstance != null) {
            query.subProcessInstanceId(this.subProcessInstance);
        }
        if (this.superCaseInstance != null) {
            query.superCaseInstanceId(this.superCaseInstance);
        }
        if (this.subCaseInstance != null) {
            query.subCaseInstanceId(this.subCaseInstance);
        }
        if (Boolean.TRUE.equals(this.active)) {
            query.active();
        }
        if (Boolean.TRUE.equals(this.suspended)) {
            query.suspended();
        }
        if (this.incidentId != null) {
            query.incidentId(this.incidentId);
        }
        if (this.incidentType != null) {
            query.incidentType(this.incidentType);
        }
        if (this.incidentMessage != null) {
            query.incidentMessage(this.incidentMessage);
        }
        if (this.incidentMessageLike != null) {
            query.incidentMessageLike(this.incidentMessageLike);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.activityIds != null && !this.activityIds.isEmpty()) {
            query.activityIdIn(this.activityIds.toArray(new String[this.activityIds.size()]));
        }
        if (this.variables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.variables) {
                String variableName = variableQueryParam.getName();
                String op = variableQueryParam.getOperator();
                Object variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.variableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.variableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.variableValueGreaterThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.variableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.variableValueLessThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.variableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.variableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
    }

    @Override
    protected void applySortBy(ProcessInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_INSTANCE_ID_VALUE)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_DEFINITION_KEY_VALUE)) {
            query.orderByProcessDefinitionKey();
        } else if (sortBy.equals(SORT_BY_DEFINITION_ID_VALUE)) {
            query.orderByProcessDefinitionId();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        } else if (sortBy.equals(SORT_BY_BUSINESS_KEY)) {
            query.orderByBusinessKey();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEFINITION_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEFINITION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_BUSINESS_KEY);
    }
}

