/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricCaseActivityStatistics;
import org.camunda.bpm.engine.rest.dto.history.HistoricCaseActivityStatisticsDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricFinishedCaseInstanceReportDto;
import org.camunda.bpm.engine.rest.history.HistoricCaseDefinitionRestService;

public class HistoricCaseDefinitionRestServiceImpl
implements HistoricCaseDefinitionRestService {
    protected ProcessEngine processEngine;

    public HistoricCaseDefinitionRestServiceImpl(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    @Override
    public List<HistoricCaseActivityStatisticsDto> getHistoricCaseActivityStatistics(String caseDefinitionId) {
        HistoryService historyService = this.processEngine.getHistoryService();
        List statistics = historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId).list();
        ArrayList<HistoricCaseActivityStatisticsDto> result = new ArrayList<HistoricCaseActivityStatisticsDto>();
        for (HistoricCaseActivityStatistics currentStatistics : statistics) {
            result.add(HistoricCaseActivityStatisticsDto.fromHistoricCaseActivityStatistics(currentStatistics));
        }
        return result;
    }

    @Override
    public List<HistoricFinishedCaseInstanceReportDto> getHistoricFinishedCaseInstanceReport() {
        HistoryService historyService = this.processEngine.getHistoryService();
        List reportResult = historyService.createHistoricFinishedCaseInstanceReport().list();
        return HistoricFinishedCaseInstanceReportDto.convert(reportResult);
    }
}

