/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.repository.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.runtime.IncidentDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.runtime.IncidentResource;
import org.camunda.bpm.engine.runtime.Incident;

public class IncidentResourceImpl
implements IncidentResource {
    protected ProcessEngine engine;
    protected String incidentId;
    protected ObjectMapper objectMapper;

    public IncidentResourceImpl(ProcessEngine engine, String incidentId, ObjectMapper objectMapper) {
        this.engine = engine;
        this.incidentId = incidentId;
        this.objectMapper = objectMapper;
    }

    @Override
    public IncidentDto getIncident() {
        Incident incident = (Incident)this.engine.getRuntimeService().createIncidentQuery().incidentId(this.incidentId).singleResult();
        if (incident == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "No matching incident with id " + this.incidentId);
        }
        return IncidentDto.fromIncident(incident);
    }

    @Override
    public void resolveIncident() {
        try {
            this.engine.getRuntimeService().resolveIncident(this.incidentId);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }
}

