/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.runtime.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.rest.dto.CreateIncidentDto;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.runtime.ExecutionDto;
import org.camunda.bpm.engine.rest.dto.runtime.ExecutionTriggerDto;
import org.camunda.bpm.engine.rest.dto.runtime.IncidentDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.sub.VariableResource;
import org.camunda.bpm.engine.rest.sub.runtime.EventSubscriptionResource;
import org.camunda.bpm.engine.rest.sub.runtime.ExecutionResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.LocalExecutionVariablesResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.MessageEventSubscriptionResource;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.variable.VariableMap;

public class ExecutionResourceImpl
implements ExecutionResource {
    protected ProcessEngine engine;
    protected String executionId;
    protected ObjectMapper objectMapper;

    public ExecutionResourceImpl(ProcessEngine engine, String executionId, ObjectMapper objectMapper) {
        this.engine = engine;
        this.executionId = executionId;
        this.objectMapper = objectMapper;
    }

    @Override
    public ExecutionDto getExecution() {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
        if (execution == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Execution with id " + this.executionId + " does not exist");
        }
        return ExecutionDto.fromExecution(execution);
    }

    @Override
    public void signalExecution(ExecutionTriggerDto triggerDto) {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        try {
            VariableMap variables = VariableValueDto.toMap(triggerDto.getVariables(), this.engine, this.objectMapper);
            runtimeService.signal(this.executionId, (Map)variables);
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot signal execution %s: %s", this.executionId, e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), "Cannot signal execution " + this.executionId + ": " + e.getMessage());
        }
    }

    @Override
    public VariableResource getLocalVariables() {
        return new LocalExecutionVariablesResource(this.engine, this.executionId, this.objectMapper);
    }

    @Override
    public EventSubscriptionResource getMessageEventSubscription(String messageName) {
        return new MessageEventSubscriptionResource(this.engine, this.executionId, messageName, this.objectMapper);
    }

    @Override
    public IncidentDto createIncident(CreateIncidentDto createIncidentDto) {
        Incident newIncident = null;
        try {
            newIncident = this.engine.getRuntimeService().createIncident(createIncidentDto.getIncidentType(), this.executionId, createIncidentDto.getActivityId(), createIncidentDto.getConfiguration(), createIncidentDto.getMessage());
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return IncidentDto.fromIncident(newIncident);
    }
}

