/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.repository;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.rest.dto.HistoryTimeToLiveDto;
import org.camunda.bpm.engine.rest.dto.StatisticsResultDto;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.dto.repository.ProcessDefinitionDiagramDto;
import org.camunda.bpm.engine.rest.dto.repository.ProcessDefinitionDto;
import org.camunda.bpm.engine.rest.dto.repository.ProcessDefinitionSuspensionStateDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceDto;
import org.camunda.bpm.engine.rest.dto.runtime.RestartProcessInstanceDto;
import org.camunda.bpm.engine.rest.dto.runtime.StartProcessInstanceDto;
import org.camunda.bpm.engine.rest.dto.task.FormDto;

public interface ProcessDefinitionResource {
    @GET
    @Produces(value={"application/json"})
    public ProcessDefinitionDto getProcessDefinition();

    @GET
    @Path(value="/xml")
    @Produces(value={"application/json"})
    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20Xml();

    @GET
    @Path(value="/diagram")
    public Response getProcessDefinitionDiagram();

    @DELETE
    public Response deleteProcessDefinition(@QueryParam(value="cascade") boolean var1, @QueryParam(value="skipCustomListeners") boolean var2);

    @POST
    @Path(value="/start")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ProcessInstanceDto startProcessInstance(@Context UriInfo var1, StartProcessInstanceDto var2);

    @POST
    @Path(value="/restart")
    @Consumes(value={"application/json"})
    public void restartProcessInstance(RestartProcessInstanceDto var1);

    @POST
    @Path(value="/restart-async")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public BatchDto restartProcessInstanceAsync(RestartProcessInstanceDto var1);

    @POST
    @Path(value="/submit-form")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ProcessInstanceDto submitForm(@Context UriInfo var1, StartProcessInstanceDto var2);

    @GET
    @Path(value="/statistics")
    @Produces(value={"application/json"})
    public List<StatisticsResultDto> getActivityStatistics(@QueryParam(value="failedJobs") Boolean var1, @QueryParam(value="incidents") Boolean var2, @QueryParam(value="incidentsForType") String var3);

    @GET
    @Path(value="/startForm")
    @Produces(value={"application/json"})
    public FormDto getStartForm();

    @GET
    @Path(value="/rendered-form")
    @Produces(value={"application/xhtml+xml"})
    public Response getRenderedForm();

    @PUT
    @Path(value="/suspended")
    @Consumes(value={"application/json"})
    public void updateSuspensionState(ProcessDefinitionSuspensionStateDto var1);

    @PUT
    @Path(value="/history-time-to-live")
    @Consumes(value={"application/json"})
    public void updateHistoryTimeToLive(HistoryTimeToLiveDto var1);

    @GET
    @Path(value="/form-variables")
    @Produces(value={"application/json"})
    public Map<String, VariableValueDto> getFormVariables(@QueryParam(value="variableNames") String var1, @QueryParam(value="deserializeValues") @DefaultValue(value="true") boolean var2);
}

