/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.camunda.bpm.engine.rest.AuthorizationRestService;
import org.camunda.bpm.engine.rest.BatchRestService;
import org.camunda.bpm.engine.rest.CaseDefinitionRestService;
import org.camunda.bpm.engine.rest.CaseExecutionRestService;
import org.camunda.bpm.engine.rest.CaseInstanceRestService;
import org.camunda.bpm.engine.rest.DecisionDefinitionRestService;
import org.camunda.bpm.engine.rest.DecisionRequirementsDefinitionRestService;
import org.camunda.bpm.engine.rest.DeploymentRestService;
import org.camunda.bpm.engine.rest.ExecutionRestService;
import org.camunda.bpm.engine.rest.ExternalTaskRestService;
import org.camunda.bpm.engine.rest.FilterRestService;
import org.camunda.bpm.engine.rest.GroupRestService;
import org.camunda.bpm.engine.rest.IdentityRestService;
import org.camunda.bpm.engine.rest.IncidentRestService;
import org.camunda.bpm.engine.rest.JobDefinitionRestService;
import org.camunda.bpm.engine.rest.JobRestService;
import org.camunda.bpm.engine.rest.MessageRestService;
import org.camunda.bpm.engine.rest.MetricsRestService;
import org.camunda.bpm.engine.rest.MigrationRestService;
import org.camunda.bpm.engine.rest.ModificationRestService;
import org.camunda.bpm.engine.rest.ProcessDefinitionRestService;
import org.camunda.bpm.engine.rest.ProcessInstanceRestService;
import org.camunda.bpm.engine.rest.SignalRestService;
import org.camunda.bpm.engine.rest.TaskRestService;
import org.camunda.bpm.engine.rest.TenantRestService;
import org.camunda.bpm.engine.rest.UserRestService;
import org.camunda.bpm.engine.rest.VariableInstanceRestService;
import org.camunda.bpm.engine.rest.dto.ProcessEngineDto;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.history.HistoryRestService;
import org.camunda.bpm.engine.rest.impl.AbstractProcessEngineRestServiceImpl;
import org.camunda.bpm.engine.rest.spi.ProcessEngineProvider;

@Path(value="/engine")
public class NamedProcessEngineRestServiceImpl
extends AbstractProcessEngineRestServiceImpl {
    public static final String PATH = "/engine";

    @Override
    @Path(value="/{name}/process-definition")
    public ProcessDefinitionRestService getProcessDefinitionService(@PathParam(value="name") String engineName) {
        return super.getProcessDefinitionService(engineName);
    }

    @Override
    @Path(value="/{name}/process-instance")
    public ProcessInstanceRestService getProcessInstanceService(@PathParam(value="name") String engineName) {
        return super.getProcessInstanceService(engineName);
    }

    @Override
    @Path(value="/{name}/execution")
    public ExecutionRestService getExecutionService(@PathParam(value="name") String engineName) {
        return super.getExecutionService(engineName);
    }

    @Override
    @Path(value="/{name}/task")
    public TaskRestService getTaskRestService(@PathParam(value="name") String engineName) {
        return super.getTaskRestService(engineName);
    }

    @Override
    @Path(value="/{name}/identity")
    public IdentityRestService getIdentityRestService(@PathParam(value="name") String engineName) {
        return super.getIdentityRestService(engineName);
    }

    @Override
    @Path(value="/{name}/message")
    public MessageRestService getMessageRestService(@PathParam(value="name") String engineName) {
        return super.getMessageRestService(engineName);
    }

    @Override
    @Path(value="/{name}/variable-instance")
    public VariableInstanceRestService getVariableInstanceService(@PathParam(value="name") String engineName) {
        return super.getVariableInstanceService(engineName);
    }

    @Override
    @Path(value="/{name}/job-definition")
    public JobDefinitionRestService getJobDefinitionRestService(@PathParam(value="name") String engineName) {
        return super.getJobDefinitionRestService(engineName);
    }

    @Override
    @Path(value="/{name}/job")
    public JobRestService getJobRestService(@PathParam(value="name") String engineName) {
        return super.getJobRestService(engineName);
    }

    @Override
    @Path(value="/{name}/group")
    public GroupRestService getGroupRestService(@PathParam(value="name") String engineName) {
        return super.getGroupRestService(engineName);
    }

    @Override
    @Path(value="/{name}/user")
    public UserRestService getUserRestService(@PathParam(value="name") String engineName) {
        return super.getUserRestService(engineName);
    }

    @Override
    @Path(value="/{name}/authorization")
    public AuthorizationRestService getAuthorizationRestService(@PathParam(value="name") String engineName) {
        return super.getAuthorizationRestService(engineName);
    }

    @Override
    @Path(value="/{name}/incident")
    public IncidentRestService getIncidentService(@PathParam(value="name") String engineName) {
        return super.getIncidentService(engineName);
    }

    @Override
    @Path(value="/{name}/history")
    public HistoryRestService getHistoryRestService(@PathParam(value="name") String engineName) {
        return super.getHistoryRestService(engineName);
    }

    @Override
    @Path(value="/{name}/deployment")
    public DeploymentRestService getDeploymentRestService(@PathParam(value="name") String engineName) {
        return super.getDeploymentRestService(engineName);
    }

    @Override
    @Path(value="/{name}/case-definition")
    public CaseDefinitionRestService getCaseDefinitionRestService(@PathParam(value="name") String engineName) {
        return super.getCaseDefinitionRestService(engineName);
    }

    @Override
    @Path(value="/{name}/case-instance")
    public CaseInstanceRestService getCaseInstanceRestService(@PathParam(value="name") String engineName) {
        return super.getCaseInstanceRestService(engineName);
    }

    @Override
    @Path(value="/{name}/case-execution")
    public CaseExecutionRestService getCaseExecutionRestService(@PathParam(value="name") String engineName) {
        return super.getCaseExecutionRestService(engineName);
    }

    @Override
    @Path(value="/{name}/filter")
    public FilterRestService getFilterRestService(@PathParam(value="name") String engineName) {
        return super.getFilterRestService(engineName);
    }

    @Override
    @Path(value="/{name}/metrics")
    public MetricsRestService getMetricsRestService(@PathParam(value="name") String engineName) {
        return super.getMetricsRestService(engineName);
    }

    @Override
    @Path(value="/{name}/decision-definition")
    public DecisionDefinitionRestService getDecisionDefinitionRestService(@PathParam(value="name") String engineName) {
        return super.getDecisionDefinitionRestService(engineName);
    }

    @Override
    @Path(value="/{name}/decision-requirements-definition")
    public DecisionRequirementsDefinitionRestService getDecisionRequirementsDefinitionRestService(@PathParam(value="name") String engineName) {
        return super.getDecisionRequirementsDefinitionRestService(engineName);
    }

    @Override
    @Path(value="/{name}/external-task")
    public ExternalTaskRestService getExternalTaskRestService(@PathParam(value="name") String engineName) {
        return super.getExternalTaskRestService(engineName);
    }

    @Override
    @Path(value="/{name}/migration")
    public MigrationRestService getMigrationRestService(@PathParam(value="name") String engineName) {
        return super.getMigrationRestService(engineName);
    }

    @Override
    @Path(value="/{name}/modification")
    public ModificationRestService getModificationRestService(@PathParam(value="name") String engineName) {
        return super.getModificationRestService(engineName);
    }

    @Override
    @Path(value="/{name}/batch")
    public BatchRestService getBatchRestService(@PathParam(value="name") String engineName) {
        return super.getBatchRestService(engineName);
    }

    @Override
    @Path(value="/{name}/tenant")
    public TenantRestService getTenantRestService(@PathParam(value="name") String engineName) {
        return super.getTenantRestService(engineName);
    }

    @Override
    @Path(value="/{name}/signal")
    public SignalRestService getSignalRestService(@PathParam(value="name") String engineName) {
        return super.getSignalRestService(engineName);
    }

    @GET
    @Produces(value={"application/json"})
    public List<ProcessEngineDto> getProcessEngineNames() {
        ProcessEngineProvider provider = this.getProcessEngineProvider();
        Set<String> engineNames = provider.getProcessEngineNames();
        ArrayList<ProcessEngineDto> results = new ArrayList<ProcessEngineDto>();
        for (String engineName : engineNames) {
            ProcessEngineDto dto = new ProcessEngineDto();
            dto.setName(engineName);
            results.add(dto);
        }
        return results;
    }

    @Override
    protected URI getRelativeEngineUri(String engineName) {
        return UriBuilder.fromResource(NamedProcessEngineRestServiceImpl.class).path("{name}").build(new Object[]{engineName});
    }

    protected ProcessEngineProvider getProcessEngineProvider() {
        ServiceLoader<ProcessEngineProvider> serviceLoader = ServiceLoader.load(ProcessEngineProvider.class);
        Iterator<ProcessEngineProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            ProcessEngineProvider provider = iterator.next();
            return provider;
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "No process engine provider found");
    }
}

