/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.ExecutionRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.runtime.ExecutionDto;
import org.camunda.bpm.engine.rest.dto.runtime.ExecutionQueryDto;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.runtime.ExecutionResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.ExecutionResourceImpl;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;

public class ExecutionRestServiceImpl
extends AbstractRestProcessEngineAware
implements ExecutionRestService {
    public ExecutionRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public ExecutionResource getExecution(String executionId) {
        return new ExecutionResourceImpl(this.getProcessEngine(), executionId, this.getObjectMapper());
    }

    @Override
    public List<ExecutionDto> getExecutions(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        ExecutionQueryDto queryDto = new ExecutionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryExecutions(queryDto, firstResult, maxResults);
    }

    @Override
    public List<ExecutionDto> queryExecutions(ExecutionQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        ExecutionQuery query = (ExecutionQuery)queryDto.toQuery(engine);
        List<Execution> matchingExecutions = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<ExecutionDto> executionResults = new ArrayList<ExecutionDto>();
        for (Execution execution : matchingExecutions) {
            ExecutionDto resultExecution = ExecutionDto.fromExecution(execution);
            executionResults.add(resultExecution);
        }
        return executionResults;
    }

    private List<Execution> executePaginatedQuery(ExecutionQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getExecutionsCount(UriInfo uriInfo) {
        ExecutionQueryDto queryDto = new ExecutionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryExecutionsCount(queryDto);
    }

    @Override
    public CountResultDto queryExecutionsCount(ExecutionQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        ExecutionQuery query = (ExecutionQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

