/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.history.impl;

import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.rest.dto.history.HistoricCaseInstanceDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.history.HistoricCaseInstanceResource;

public class HistoricCaseInstanceResourceImpl
implements HistoricCaseInstanceResource {
    private ProcessEngine engine;
    private String caseInstanceId;

    public HistoricCaseInstanceResourceImpl(ProcessEngine engine, String caseInstanceId) {
        this.engine = engine;
        this.caseInstanceId = caseInstanceId;
    }

    @Override
    public HistoricCaseInstanceDto getHistoricCaseInstance() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricCaseInstance instance = (HistoricCaseInstance)historyService.createHistoricCaseInstanceQuery().caseInstanceId(this.caseInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic case instance with id '" + this.caseInstanceId + "' does not exist");
        }
        return HistoricCaseInstanceDto.fromHistoricCaseInstance(instance);
    }
}

