/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import com.jayway.restassured.RestAssured;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class IncidentRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String INCIDENT_URL = "/rest-test/incident";
    protected static final String SINGLE_INCIDENT_URL = "/rest-test/incident/{id}";
    private RuntimeServiceImpl mockRuntimeService;
    private IncidentQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        List<Incident> incidents = MockProvider.createMockIncidents();
        this.mockedQuery = this.setupMockIncidentQuery(incidents);
    }

    private IncidentQuery setupMockIncidentQuery(List<Incident> incidents) {
        IncidentQuery sampleQuery = (IncidentQuery)Mockito.mock(IncidentQuery.class);
        Mockito.when((Object)sampleQuery.incidentId(Mockito.anyString())).thenReturn((Object)sampleQuery);
        Mockito.when((Object)sampleQuery.singleResult()).thenReturn(Mockito.mock(Incident.class));
        this.mockRuntimeService = (RuntimeServiceImpl)Mockito.mock(RuntimeServiceImpl.class);
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.mockRuntimeService);
        Mockito.when((Object)this.mockRuntimeService.createIncidentQuery()).thenReturn((Object)sampleQuery);
        return sampleQuery;
    }

    @Test
    public void testGetIncident() {
        RestAssured.given().pathParam("id", (Object)"anIncidentId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SINGLE_INCIDENT_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.mockRuntimeService)).createIncidentQuery();
        ((IncidentQuery)Mockito.verify((Object)this.mockedQuery)).incidentId("anIncidentId");
        ((IncidentQuery)Mockito.verify((Object)this.mockedQuery)).singleResult();
    }

    @Test
    public void testGetUnexistingIncident() {
        Mockito.when((Object)this.mockedQuery.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"anIncidentId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().get(SINGLE_INCIDENT_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.mockRuntimeService)).createIncidentQuery();
        ((IncidentQuery)Mockito.verify((Object)this.mockedQuery)).incidentId("anIncidentId");
        ((IncidentQuery)Mockito.verify((Object)this.mockedQuery)).singleResult();
    }

    @Test
    public void testResolveIncident() {
        RestAssured.given().pathParam("id", (Object)"anIncidentId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_INCIDENT_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.mockRuntimeService)).resolveIncident("anIncidentId");
    }

    @Test
    public void testResolveUnexistingIncident() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable)new NotFoundException()).when((Object)this.mockRuntimeService)).resolveIncident(Mockito.anyString());
        RestAssured.given().pathParam("id", (Object)"anIncidentId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().delete(SINGLE_INCIDENT_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.mockRuntimeService)).resolveIncident("anIncidentId");
    }
}

