/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricCaseInstanceQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class HistoricCaseInstanceRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_CASE_INSTANCE_URL = "/rest-test/history/case-instance";
    protected static final String HISTORIC_SINGLE_CASE_INSTANCE_URL = "/rest-test/history/case-instance/{id}";
    protected HistoryService historyServiceMock;
    protected HistoricCaseInstance historicInstanceMock;
    protected HistoricCaseInstanceQuery historicQueryMock;

    @Before
    public void setUpRuntimeData() {
        this.historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
        this.historicInstanceMock = MockProvider.createMockHistoricCaseInstance();
        this.historicQueryMock = (HistoricCaseInstanceQuery)Mockito.mock(HistoricCaseInstanceQuery.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricCaseInstanceQuery()).thenReturn((Object)this.historicQueryMock);
        Mockito.when((Object)this.historicQueryMock.caseInstanceId(Matchers.anyString())).thenReturn((Object)this.historicQueryMock);
        Mockito.when((Object)this.historicQueryMock.singleResult()).thenReturn((Object)this.historicInstanceMock);
    }

    @Test
    public void testGetSingleHistoricCaseInstance() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aCaseInstId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_CASE_INSTANCE_URL, new Object[0]);
        String content = response.asString();
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("id");
        String returnedCaseInstanceBusinessKey = JsonPath.from((String)content).getString("businessKey");
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("caseDefinitionId");
        String returnedCreateTime = JsonPath.from((String)content).getString("createTime");
        String returnedCloseTime = JsonPath.from((String)content).getString("closeTime");
        long returnedDurationInMillis = JsonPath.from((String)content).getLong("durationInMillis");
        String returnedCreateUserId = JsonPath.from((String)content).getString("createUserId");
        String returnedSuperCaseInstanceId = JsonPath.from((String)content).getString("superCaseInstanceId");
        String returnedSuperProcessInstanceId = JsonPath.from((String)content).getString("superProcessInstanceId");
        String returnedTenantId = JsonPath.from((String)content).getString("tenantId");
        boolean active = JsonPath.from((String)content).getBoolean("active");
        boolean completed = JsonPath.from((String)content).getBoolean("completed");
        boolean terminated = JsonPath.from((String)content).getBoolean("terminated");
        boolean closed = JsonPath.from((String)content).getBoolean("closed");
        Assert.assertEquals((Object)"aCaseInstId", (Object)returnedCaseInstanceId);
        Assert.assertEquals((Object)"aBusinessKey", (Object)returnedCaseInstanceBusinessKey);
        Assert.assertEquals((Object)"aCaseDefnitionId", (Object)returnedCaseDefinitionId);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CREATE_TIME, (Object)returnedCreateTime);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CLOSE_TIME, (Object)returnedCloseTime);
        Assert.assertEquals((long)2000L, (long)returnedDurationInMillis);
        Assert.assertEquals((Object)"aCreateUserId", (Object)returnedCreateUserId);
        Assert.assertEquals((Object)"aSuperCaseInstanceId", (Object)returnedSuperCaseInstanceId);
        Assert.assertEquals((Object)"aSuperProcessInstanceId", (Object)returnedSuperProcessInstanceId);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
        Assert.assertEquals((Object)true, (Object)active);
        Assert.assertEquals((Object)true, (Object)completed);
        Assert.assertEquals((Object)true, (Object)terminated);
        Assert.assertEquals((Object)true, (Object)closed);
    }

    @Test
    public void testGetNonExistingHistoricCaseInstance() {
        Mockito.when((Object)this.historicQueryMock.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"nonExistingId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", org.hamcrest.Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", org.hamcrest.Matchers.equalTo((Object)"Historic case instance with id 'nonExistingId' does not exist"), new Object[0]).when().get(HISTORIC_SINGLE_CASE_INSTANCE_URL, new Object[0]);
    }
}

