/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class HistoricDecisionInstanceRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_DECISION_INSTANCE_URL = "/rest-test/history/decision-instance";
    protected static final String HISTORIC_SINGLE_DECISION_INSTANCE_URL = "/rest-test/history/decision-instance/{id}";
    protected HistoryService historyServiceMock;
    protected HistoricDecisionInstance historicInstanceMock;
    protected HistoricDecisionInstanceQuery historicQueryMock;

    @Before
    public void setUpRuntimeData() {
        this.historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
        this.historicInstanceMock = MockProvider.createMockHistoricDecisionInstance();
        this.historicQueryMock = (HistoricDecisionInstanceQuery)Mockito.mock(HistoricDecisionInstanceQuery.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricDecisionInstanceQuery()).thenReturn((Object)this.historicQueryMock);
        Mockito.when((Object)this.historicQueryMock.decisionInstanceId(org.mockito.Matchers.anyString())).thenReturn((Object)this.historicQueryMock);
        Mockito.when((Object)this.historicQueryMock.singleResult()).thenReturn((Object)this.historicInstanceMock);
    }

    @Test
    public void testGetSingleHistoricDecisionInstance() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aHistoricDecisionInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_DECISION_INSTANCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicQueryMock});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).decisionInstanceId("aHistoricDecisionInstanceId");
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).singleResult();
        String content = response.asString();
        String returnedHistoricDecisionInstanceId = JsonPath.from((String)content).getString("id");
        String returnedDecisionDefinitionId = JsonPath.from((String)content).getString("decisionDefinitionId");
        String returnedDecisionDefinitionKey = JsonPath.from((String)content).getString("decisionDefinitionKey");
        String returnedDecisionDefinitionName = JsonPath.from((String)content).getString("decisionDefinitionName");
        String returnedEvaluationTime = JsonPath.from((String)content).getString("evaluationTime");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("processDefinitionId");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("processDefinitionKey");
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("processInstanceId");
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("caseDefinitionId");
        String returnedCaseDefinitionKey = JsonPath.from((String)content).getString("caseDefinitionKey");
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("caseInstanceId");
        String returnedActivityId = JsonPath.from((String)content).getString("activityId");
        String returnedActivityInstanceId = JsonPath.from((String)content).getString("activityInstanceId");
        String returnedUserId = JsonPath.from((String)content).getString("userId");
        List returnedInputs = JsonPath.from((String)content).getList("inputs");
        List returnedOutputs = JsonPath.from((String)content).getList("outputs");
        Double returnedCollectResultValue = JsonPath.from((String)content).getDouble("collectResultValue");
        String returnedTenantId = JsonPath.from((String)content).getString("tenantId");
        String returnedRootDecisionInstanceId = JsonPath.from((String)content).getString("rootDecisionInstanceId");
        String returnedDecisionRequirementsDefinitionId = JsonPath.from((String)content).getString("decisionRequirementsDefinitionId");
        String returnedDecisionRequirementsDefinitionKey = JsonPath.from((String)content).getString("decisionRequirementsDefinitionKey");
        Assert.assertThat((Object)returnedHistoricDecisionInstanceId, (Matcher)Matchers.is((Object)"aHistoricDecisionInstanceId"));
        Assert.assertThat((Object)returnedDecisionDefinitionId, (Matcher)Matchers.is((Object)"aDecisionDefinitionId"));
        Assert.assertThat((Object)returnedDecisionDefinitionKey, (Matcher)Matchers.is((Object)"aDecisionDefinitionKey"));
        Assert.assertThat((Object)returnedDecisionDefinitionName, (Matcher)Matchers.is((Object)"aDecisionDefinitionName"));
        Assert.assertThat((Object)returnedEvaluationTime, (Matcher)Matchers.is((Object)MockProvider.EXAMPLE_HISTORIC_DECISION_INSTANCE_EVALUATION_TIME));
        Assert.assertThat((Object)returnedProcessDefinitionId, (Matcher)Matchers.is((Object)"aProcDefId"));
        Assert.assertThat((Object)returnedProcessDefinitionKey, (Matcher)Matchers.is((Object)"aKey"));
        Assert.assertThat((Object)returnedProcessInstanceId, (Matcher)Matchers.is((Object)"aProcInstId"));
        Assert.assertThat((Object)returnedCaseDefinitionId, (Matcher)Matchers.is((Object)"aCaseDefnitionId"));
        Assert.assertThat((Object)returnedCaseDefinitionKey, (Matcher)Matchers.is((Object)"aCaseDefinitionKey"));
        Assert.assertThat((Object)returnedCaseInstanceId, (Matcher)Matchers.is((Object)"aCaseInstId"));
        Assert.assertThat((Object)returnedActivityId, (Matcher)Matchers.is((Object)"aHistoricDecisionInstanceActivityId"));
        Assert.assertThat((Object)returnedActivityInstanceId, (Matcher)Matchers.is((Object)"aHistoricDecisionInstanceActivityInstanceId"));
        Assert.assertThat((Object)returnedUserId, (Matcher)Matchers.is((Object)"aUserId"));
        Assert.assertThat((Object)returnedInputs, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)returnedOutputs, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)returnedCollectResultValue, (Matcher)Matchers.is((Object)MockProvider.EXAMPLE_HISTORIC_DECISION_INSTANCE_COLLECT_RESULT_VALUE));
        Assert.assertThat((Object)returnedTenantId, (Matcher)Matchers.is((Object)"aTenantId"));
        Assert.assertThat((Object)returnedRootDecisionInstanceId, (Matcher)Matchers.is((Object)"aHistoricDecisionInstanceId"));
        Assert.assertThat((Object)returnedDecisionRequirementsDefinitionId, (Matcher)Matchers.is((Object)"aDecisionRequirementsDefinitionId"));
        Assert.assertThat((Object)returnedDecisionRequirementsDefinitionKey, (Matcher)Matchers.is((Object)"aDecisionRequirementsDefinitionKey"));
    }

    @Test
    public void testGetSingleHistoricDecisionInstanceWithInputs() {
        this.historicInstanceMock = MockProvider.createMockHistoricDecisionInstanceWithInputs();
        Mockito.when((Object)this.historicQueryMock.singleResult()).thenReturn((Object)this.historicInstanceMock);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aHistoricDecisionInstanceId").queryParam("includeInputs", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_DECISION_INSTANCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicQueryMock});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).decisionInstanceId("aHistoricDecisionInstanceId");
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).includeInputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock, Mockito.never())).includeOutputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).singleResult();
        String content = response.asString();
        List returnedInputs = JsonPath.from((String)content).getList("inputs");
        List returnedOutputs = JsonPath.from((String)content).getList("outputs");
        Assert.assertThat((Object)returnedInputs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)returnedInputs, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)returnedOutputs, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetSingleHistoricDecisionInstanceWithOutputs() {
        this.historicInstanceMock = MockProvider.createMockHistoricDecisionInstanceWithOutputs();
        Mockito.when((Object)this.historicQueryMock.singleResult()).thenReturn((Object)this.historicInstanceMock);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aHistoricDecisionInstanceId").queryParam("includeOutputs", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_DECISION_INSTANCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicQueryMock});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).decisionInstanceId("aHistoricDecisionInstanceId");
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock, Mockito.never())).includeInputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).includeOutputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).singleResult();
        String content = response.asString();
        List returnedInputs = JsonPath.from((String)content).getList("inputs");
        List returnedOutputs = JsonPath.from((String)content).getList("outputs");
        Assert.assertThat((Object)returnedInputs, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)returnedOutputs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)returnedOutputs, (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void testGetSingleHistoricDecisionInstanceWithInputsAndOutputs() {
        this.historicInstanceMock = MockProvider.createMockHistoricDecisionInstanceWithInputsAndOutputs();
        Mockito.when((Object)this.historicQueryMock.singleResult()).thenReturn((Object)this.historicInstanceMock);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aHistoricDecisionInstanceId").queryParam("includeInputs", new Object[]{true}).queryParam("includeOutputs", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_DECISION_INSTANCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicQueryMock});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).decisionInstanceId("aHistoricDecisionInstanceId");
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).includeInputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).includeOutputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).singleResult();
        String content = response.asString();
        List returnedInputs = JsonPath.from((String)content).getList("inputs");
        List returnedOutputs = JsonPath.from((String)content).getList("outputs");
        Assert.assertThat((Object)returnedInputs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)returnedInputs, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)returnedOutputs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)returnedOutputs, (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void testGetSingleHistoricDecisionInstanceWithDisabledBinaryFetching() {
        this.historicInstanceMock = MockProvider.createMockHistoricDecisionInstanceWithInputsAndOutputs();
        Mockito.when((Object)this.historicQueryMock.singleResult()).thenReturn((Object)this.historicInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aHistoricDecisionInstanceId").queryParam("disableBinaryFetching", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_DECISION_INSTANCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicQueryMock});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).decisionInstanceId("aHistoricDecisionInstanceId");
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).disableBinaryFetching();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).singleResult();
    }

    @Test
    public void testGetSingleHistoricDecisionInstanceWithDisabledCustomObjectDeserialization() {
        this.historicInstanceMock = MockProvider.createMockHistoricDecisionInstanceWithInputsAndOutputs();
        Mockito.when((Object)this.historicQueryMock.singleResult()).thenReturn((Object)this.historicInstanceMock);
        RestAssured.given().pathParam("id", (Object)"aHistoricDecisionInstanceId").queryParam("disableCustomObjectDeserialization", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_DECISION_INSTANCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicQueryMock});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).decisionInstanceId("aHistoricDecisionInstanceId");
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).disableCustomObjectDeserialization();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.historicQueryMock)).singleResult();
    }

    @Test
    public void testGetNonExistingHistoricCaseInstance() {
        Mockito.when((Object)this.historicQueryMock.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"nonExistingId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Historic decision instance with id 'nonExistingId' does not exist"), new Object[0]).when().get(HISTORIC_SINGLE_DECISION_INSTANCE_URL, new Object[0]);
    }
}

