/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.mapper.JacksonConfigurator;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.Job;
import org.hamcrest.CoreMatchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class HistoryCleanupRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORY_CLEANUP_URL = "/rest-test/history/cleanup";
    protected static final String FIND_HISTORY_CLEANUP_JOB_URL = "/rest-test/history/cleanup/job";
    protected static final String CONFIGURATION_URL = "/rest-test/history/cleanup/configuration";
    private HistoryService historyServiceMock;

    @Before
    public void setUpRuntimeData() {
        this.historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        Job mockJob = MockProvider.createMockJob();
        Mockito.when((Object)this.historyServiceMock.cleanUpHistoryAsync(Matchers.anyBoolean())).thenReturn((Object)mockJob);
        Mockito.when((Object)this.historyServiceMock.findHistoryCleanupJob()).thenReturn((Object)mockJob);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
    }

    @Test
    public void testFindHistoryCleanupJob() {
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(FIND_HISTORY_CLEANUP_JOB_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).findHistoryCleanupJob();
    }

    @Test
    public void testFindNoHistoryCleanupJob() {
        Mockito.when((Object)this.historyServiceMock.findHistoryCleanupJob()).thenReturn(null);
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).when().get(FIND_HISTORY_CLEANUP_JOB_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).findHistoryCleanupJob();
    }

    @Test
    public void testHistoryCleanupImmediatelyDueDefault() {
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORY_CLEANUP_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).cleanUpHistoryAsync(true);
    }

    @Test
    public void testHistoryCleanupImmediatelyDue() {
        RestAssured.given().contentType(ContentType.JSON).queryParam("immediatelyDue", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORY_CLEANUP_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).cleanUpHistoryAsync(true);
    }

    @Test
    public void testHistoryCleanup() {
        RestAssured.given().contentType(ContentType.JSON).queryParam("immediatelyDue", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORY_CLEANUP_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).cleanUpHistoryAsync(false);
    }

    @Test
    public void testHistoryConfigurationOutsideBatchWindow() throws ParseException {
        ProcessEngineConfigurationImpl processEngineConfigurationImplMock = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        Date startDate = HistoryCleanupHelper.parseTimeConfiguration((String)"23:59+0200");
        Date endDate = HistoryCleanupHelper.parseTimeConfiguration((String)"00:00+0200");
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)processEngineConfigurationImplMock);
        Mockito.when((Object)processEngineConfigurationImplMock.getHistoryCleanupBatchWindowStartTimeAsDate()).thenReturn((Object)startDate);
        Mockito.when((Object)processEngineConfigurationImplMock.getHistoryCleanupBatchWindowEndTimeAsDate()).thenReturn((Object)endDate);
        SimpleDateFormat sdf = new SimpleDateFormat(JacksonConfigurator.dateFormatString);
        Date now = sdf.parse("2017-09-01T22:00:00.000+0200");
        ClockUtil.setCurrentTime((Date)now);
        Calendar today = Calendar.getInstance();
        today.setTime(now);
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.setTime(HistoryCleanupHelper.addDays((Date)now, (int)1));
        Date dateToday = HistoryCleanupHelper.updateTime((Date)today.getTime(), (Date)startDate);
        Date dateTomorrow = HistoryCleanupHelper.updateTime((Date)tomorrow.getTime(), (Date)endDate);
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("batchWindowStartTime", CoreMatchers.containsString((String)sdf.format(dateToday)), new Object[0]).body("batchWindowEndTime", CoreMatchers.containsString((String)sdf.format(dateTomorrow)), new Object[0]).when().get(CONFIGURATION_URL, new Object[0]);
        ((ProcessEngineConfigurationImpl)Mockito.verify((Object)processEngineConfigurationImplMock)).getHistoryCleanupBatchWindowStartTimeAsDate();
        ((ProcessEngineConfigurationImpl)Mockito.verify((Object)processEngineConfigurationImplMock)).getHistoryCleanupBatchWindowEndTimeAsDate();
    }

    @Test
    public void testHistoryConfigurationWithinBatchWindow() throws ParseException {
        ProcessEngineConfigurationImpl processEngineConfigurationImplMock = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        Date startDate = HistoryCleanupHelper.parseTimeConfiguration((String)"22:00+0200");
        Date endDate = HistoryCleanupHelper.parseTimeConfiguration((String)"23:00+0200");
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)processEngineConfigurationImplMock);
        Mockito.when((Object)processEngineConfigurationImplMock.getHistoryCleanupBatchWindowStartTimeAsDate()).thenReturn((Object)startDate);
        Mockito.when((Object)processEngineConfigurationImplMock.getHistoryCleanupBatchWindowEndTimeAsDate()).thenReturn((Object)endDate);
        SimpleDateFormat sdf = new SimpleDateFormat(JacksonConfigurator.dateFormatString);
        Date now = sdf.parse("2017-09-01T22:00:00.000+0200");
        ClockUtil.setCurrentTime((Date)now);
        Calendar today = Calendar.getInstance();
        today.setTime(now);
        Date dateToday = HistoryCleanupHelper.updateTime((Date)today.getTime(), (Date)startDate);
        Date dateTomorrow = HistoryCleanupHelper.updateTime((Date)today.getTime(), (Date)endDate);
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("batchWindowStartTime", CoreMatchers.containsString((String)sdf.format(dateToday)), new Object[0]).body("batchWindowEndTime", CoreMatchers.containsString((String)sdf.format(dateTomorrow)), new Object[0]).when().get(CONFIGURATION_URL, new Object[0]);
        ((ProcessEngineConfigurationImpl)Mockito.verify((Object)processEngineConfigurationImplMock)).getHistoryCleanupBatchWindowStartTimeAsDate();
        ((ProcessEngineConfigurationImpl)Mockito.verify((Object)processEngineConfigurationImplMock)).getHistoryCleanupBatchWindowEndTimeAsDate();
    }

    @Test
    public void testHistoryConfigurationWhenBatchNotDefined() {
        ProcessEngineConfigurationImpl processEngineConfigurationImplMock = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)processEngineConfigurationImplMock);
        Mockito.when((Object)processEngineConfigurationImplMock.getHistoryCleanupBatchWindowStartTimeAsDate()).thenReturn(null);
        Mockito.when((Object)processEngineConfigurationImplMock.getHistoryCleanupBatchWindowEndTimeAsDate()).thenReturn(null);
        RestAssured.given().contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("batchWindowStartTime", CoreMatchers.equalTo(null), new Object[0]).body("batchWindowEndTime", CoreMatchers.equalTo(null), new Object[0]).when().get(CONFIGURATION_URL, new Object[0]);
        ((ProcessEngineConfigurationImpl)Mockito.verify((Object)processEngineConfigurationImplMock)).getHistoryCleanupBatchWindowStartTimeAsDate();
        ((ProcessEngineConfigurationImpl)Mockito.verify((Object)processEngineConfigurationImplMock)).getHistoryCleanupBatchWindowEndTimeAsDate();
    }
}

