/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.util;

import java.util.HashMap;
import java.util.Map;

public class VariablesBuilder {
    private Map<String, Object> variables = new HashMap<String, Object>();

    private VariablesBuilder() {
    }

    public static VariablesBuilder create() {
        VariablesBuilder builder = new VariablesBuilder();
        return builder;
    }

    public VariablesBuilder variable(String name, Object value, String type) {
        Map<String, Object> variableValue = VariablesBuilder.getVariableValueMap(value, type);
        this.variables.put(name, variableValue);
        return this;
    }

    public VariablesBuilder variable(String name, Object value, String type, boolean local) {
        Map<String, Object> variableValue = VariablesBuilder.getVariableValueMap(value, type, local);
        this.variables.put(name, variableValue);
        return this;
    }

    public VariablesBuilder variable(String name, Object value) {
        return this.variable(name, value, null);
    }

    public VariablesBuilder variable(String name, Object value, boolean local) {
        return this.variable(name, value, null, local);
    }

    public VariablesBuilder variable(String name, String type, Object value, String serializationFormat, String objectType) {
        Map<String, Object> variableValue = VariablesBuilder.getObjectValueMap(value, type, serializationFormat, objectType);
        this.variables.put(name, variableValue);
        return this;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public static Map<String, Object> getVariableValueMap(Object value) {
        return VariablesBuilder.getVariableValueMap(value, null);
    }

    public static Map<String, Object> getVariableValueMap(Object value, boolean local) {
        return VariablesBuilder.getVariableValueMap(value, null, local);
    }

    public static Map<String, Object> getVariableValueMap(Object value, String type) {
        return VariablesBuilder.getVariableValueMap(value, type, false);
    }

    public static Map<String, Object> getVariableValueMap(Object value, String type, boolean local) {
        HashMap<String, Object> variable = new HashMap<String, Object>();
        if (value != null) {
            variable.put("value", value);
        }
        if (type != null) {
            variable.put("type", type);
        }
        variable.put("local", local);
        return variable;
    }

    public static Map<String, Object> getObjectValueMap(Object value, String variableType, String serializationFormat, String objectTypeName) {
        HashMap<String, Object> serializedVariable = new HashMap<String, Object>();
        if (value != null) {
            serializedVariable.put("value", value);
        }
        if (variableType != null) {
            serializedVariable.put("type", variableType);
        }
        HashMap<String, String> typeInfo = new HashMap<String, String>();
        typeInfo.put("serializationDataFormat", serializationFormat);
        typeInfo.put("objectTypeName", objectTypeName);
        serializedVariable.put("valueInfo", typeInfo);
        return serializedVariable;
    }
}

