/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.rest.dto.history.HistoryCleanupConfigurationDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobDto;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.history.HistoryCleanupRestService;
import org.camunda.bpm.engine.runtime.Job;

public class HistoryCleanupRestServiceImpl
implements HistoryCleanupRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoryCleanupRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public JobDto cleanupAsync(boolean immediatelyDue) {
        Job job = this.processEngine.getHistoryService().cleanUpHistoryAsync(immediatelyDue);
        return JobDto.fromJob(job);
    }

    @Override
    public JobDto findCleanupJob() {
        Job job = this.processEngine.getHistoryService().findHistoryCleanupJob();
        if (job == null) {
            throw new RestException(Response.Status.NOT_FOUND, "History cleanup job does not exist");
        }
        return JobDto.fromJob(job);
    }

    @Override
    public HistoryCleanupConfigurationDto getHistoryCleanupConfiguration() {
        HistoryCleanupConfigurationDto configurationDto = new HistoryCleanupConfigurationDto();
        Date startTime = ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getHistoryCleanupBatchWindowStartTimeAsDate();
        Date endTime = ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getHistoryCleanupBatchWindowEndTimeAsDate();
        if (startTime == null || endTime == null) {
            return configurationDto;
        }
        Date now = ClockUtil.getCurrentTime();
        Date startDate = HistoryCleanupHelper.getCurrentOrNextBatchWindowStartTime((Date)now, (Date)startTime, (Date)endTime);
        Date endDate = HistoryCleanupHelper.getNextBatchWindowEndTime((Date)now, (Date)endTime);
        configurationDto.setBatchWindowStartTime(startDate);
        configurationDto.setBatchWindowEndTime(endDate);
        return configurationDto;
    }
}

