/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.util;

import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.rest.dto.converter.PermissionConverter;

public class AuthorizationUtil
implements Permission,
Resource {
    protected String resourceName;
    protected int resourceType;
    protected String permissionName;
    protected int permissionValue;

    public AuthorizationUtil(String resourceName, int resourceType, String permissionName) {
        this.resourceName = resourceName;
        this.resourceType = resourceType;
        this.permissionName = permissionName;
        this.permissionValue = PermissionConverter.getPermissionForName(permissionName).getValue();
    }

    public String resourceName() {
        return this.resourceName;
    }

    public int resourceType() {
        return this.resourceType;
    }

    public String getName() {
        return this.permissionName;
    }

    public int getValue() {
        return this.permissionValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.permissionName == null ? 0 : this.permissionName.hashCode());
        result = 31 * result + this.permissionValue;
        result = 31 * result + (this.resourceName == null ? 0 : this.resourceName.hashCode());
        result = 31 * result + this.resourceType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationUtil other = (AuthorizationUtil)obj;
        if (this.permissionName == null ? other.permissionName != null : !this.permissionName.equals(other.permissionName)) {
            return false;
        }
        if (this.permissionValue != other.permissionValue) {
            return false;
        }
        if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
            return false;
        }
        return this.resourceType == other.resourceType;
    }
}

