/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.runtime.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.rest.dto.runtime.ActivityInstanceDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceSuspensionStateDto;
import org.camunda.bpm.engine.rest.dto.runtime.modification.ProcessInstanceModificationDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.VariableResource;
import org.camunda.bpm.engine.rest.sub.runtime.ProcessInstanceResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.ExecutionVariablesResource;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationBuilder;

public class ProcessInstanceResourceImpl
implements ProcessInstanceResource {
    protected ProcessEngine engine;
    protected String processInstanceId;
    protected ObjectMapper objectMapper;

    public ProcessInstanceResourceImpl(ProcessEngine engine, String processInstanceId, ObjectMapper objectMapper) {
        this.engine = engine;
        this.processInstanceId = processInstanceId;
        this.objectMapper = objectMapper;
    }

    @Override
    public ProcessInstanceDto getProcessInstance() {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        ProcessInstance instance = (ProcessInstance)runtimeService.createProcessInstanceQuery().processInstanceId(this.processInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Process instance with id " + this.processInstanceId + " does not exist");
        }
        ProcessInstanceDto result = ProcessInstanceDto.fromProcessInstance(instance);
        return result;
    }

    @Override
    public void deleteProcessInstance(boolean skipCustomListeners, boolean skipIoMappings, boolean skipSubprocesses) {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        try {
            runtimeService.deleteProcessInstance(this.processInstanceId, null, skipCustomListeners, true, skipIoMappings, skipSubprocesses);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), "Process instance with id " + this.processInstanceId + " does not exist");
        }
    }

    @Override
    public VariableResource getVariablesResource() {
        return new ExecutionVariablesResource(this.engine, this.processInstanceId, true, this.objectMapper);
    }

    @Override
    public ActivityInstanceDto getActivityInstanceTree() {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        ActivityInstance activityInstance = null;
        try {
            activityInstance = runtimeService.getActivityInstance(this.processInstanceId);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), e.getMessage());
        }
        if (activityInstance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Process instance with id " + this.processInstanceId + " does not exist");
        }
        ActivityInstanceDto result = ActivityInstanceDto.fromActivityInstance(activityInstance);
        return result;
    }

    @Override
    public void updateSuspensionState(ProcessInstanceSuspensionStateDto dto) {
        dto.setProcessInstanceId(this.processInstanceId);
        dto.updateSuspensionState(this.engine);
    }

    @Override
    public void modifyProcessInstance(ProcessInstanceModificationDto dto) {
        if (dto.getInstructions() != null && !dto.getInstructions().isEmpty()) {
            ProcessInstanceModificationBuilder modificationBuilder = this.engine.getRuntimeService().createProcessInstanceModification(this.processInstanceId);
            dto.applyTo(modificationBuilder, this.engine, this.objectMapper);
            modificationBuilder.execute(dto.isSkipCustomListeners(), dto.isSkipIoMappings());
        }
    }
}

