/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.externaltask;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryBuilder;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryTopicBuilder;

public class FetchExternalTasksDto {
    protected int maxTasks;
    protected String workerId;
    protected boolean usePriority = false;
    protected List<FetchExternalTaskTopicDto> topics;

    public int getMaxTasks() {
        return this.maxTasks;
    }

    public void setMaxTasks(int maxTasks) {
        this.maxTasks = maxTasks;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public List<FetchExternalTaskTopicDto> getTopics() {
        return this.topics;
    }

    public void setTopics(List<FetchExternalTaskTopicDto> topics) {
        this.topics = topics;
    }

    public boolean isUsePriority() {
        return this.usePriority;
    }

    public void setUsePriority(boolean usePriority) {
        this.usePriority = usePriority;
    }

    public ExternalTaskQueryBuilder buildQuery(ProcessEngine processEngine) {
        ExternalTaskQueryBuilder fetchBuilder = processEngine.getExternalTaskService().fetchAndLock(this.getMaxTasks(), this.getWorkerId(), this.isUsePriority());
        if (this.getTopics() != null) {
            for (FetchExternalTaskTopicDto topicDto : this.getTopics()) {
                ExternalTaskQueryTopicBuilder topicFetchBuilder = fetchBuilder.topic(topicDto.getTopicName(), topicDto.getLockDuration());
                if (topicDto.getBusinessKey() != null) {
                    topicFetchBuilder = topicFetchBuilder.businessKey(topicDto.getBusinessKey());
                }
                if (topicDto.getVariables() != null) {
                    topicFetchBuilder = topicFetchBuilder.variables(topicDto.getVariables());
                }
                if (topicDto.getProcessVariables() != null) {
                    topicFetchBuilder = topicFetchBuilder.processInstanceVariableEquals(topicDto.getProcessVariables());
                }
                if (topicDto.isDeserializeValues()) {
                    topicFetchBuilder = topicFetchBuilder.enableCustomObjectDeserialization();
                }
                fetchBuilder = topicFetchBuilder;
            }
        }
        return fetchBuilder;
    }

    public static class FetchExternalTaskTopicDto {
        protected String topicName;
        protected String businessKey;
        protected long lockDuration;
        protected List<String> variables;
        protected HashMap<String, Object> processVariables;
        protected boolean deserializeValues = false;

        public String getTopicName() {
            return this.topicName;
        }

        public void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        public String getBusinessKey() {
            return this.businessKey;
        }

        public void setBusinessKey(String businessKey) {
            this.businessKey = businessKey;
        }

        public long getLockDuration() {
            return this.lockDuration;
        }

        public void setLockDuration(long lockDuration) {
            this.lockDuration = lockDuration;
        }

        public List<String> getVariables() {
            return this.variables;
        }

        public void setVariables(List<String> variables) {
            this.variables = variables;
        }

        public HashMap<String, Object> getProcessVariables() {
            return this.processVariables;
        }

        public void setProcessVariables(HashMap<String, Object> processVariables) {
            this.processVariables = processVariables;
        }

        public boolean isDeserializeValues() {
            return this.deserializeValues;
        }

        public void setDeserializeValues(boolean deserializeValues) {
            this.deserializeValues = deserializeValues;
        }
    }
}

