/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.camunda.bpm.engine.rest.hal;

import java.util.Collections;

/**
 * @author Sebastian Menski
 */
public class EmptyHalCollection extends HalCollectionResource<EmptyHalCollection> {

  public static final HalResource INSTANCE = new EmptyHalCollection();

  public EmptyHalCollection() {
    this(0);
  }

  public EmptyHalCollection(long count) {
    _links = Collections.emptyMap();
    _embedded = Collections.emptyMap();
    this.count = count;
  }

  @SuppressWarnings("unchecked")
  public static <T extends HalCollectionResource> T emptyHalCollection() {
    return (T) INSTANCE;
  }

}
