/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.AuthorizationQuery;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AuthorizationServiceImpl;
import org.camunda.bpm.engine.impl.IdentityServiceImpl;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.authorization.AuthorizationDto;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.AuthorizationUtil;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AuthorizationRestServiceInteractionTest
extends AbstractRestServiceTest {
    protected static final String SERVICE_PATH = "/rest-test/authorization";
    protected static final String AUTH_CREATE_PATH = "/rest-test/authorization/create";
    protected static final String AUTH_CHECK_PATH = "/rest-test/authorization/check";
    protected static final String AUTH_RESOURCE_PATH = "/rest-test/authorization/{id}";
    protected AuthorizationService authorizationServiceMock;
    protected IdentityService identityServiceMock;
    protected ProcessEngineConfiguration processEngineConfigurationMock;
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();

    @Before
    public void setUpRuntimeData() {
        this.authorizationServiceMock = (AuthorizationService)Mockito.mock(AuthorizationServiceImpl.class);
        this.identityServiceMock = (IdentityService)Mockito.mock(IdentityServiceImpl.class);
        this.processEngineConfigurationMock = (ProcessEngineConfiguration)Mockito.mock(ProcessEngineConfiguration.class);
        Mockito.when((Object)processEngine.getAuthorizationService()).thenReturn((Object)this.authorizationServiceMock);
        Mockito.when((Object)processEngine.getIdentityService()).thenReturn((Object)this.identityServiceMock);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration()).thenReturn((Object)this.processEngineConfigurationMock);
    }

    @Test
    public void testIsUserAuthorizedTrue() {
        ArrayList exampleGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", exampleGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        AuthorizationUtil authorizationUtil = new AuthorizationUtil("exampleResource", 12345678, "READ");
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", exampleGroups, (Permission)authorizationUtil, (Resource)authorizationUtil)).thenReturn((Object)true);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("permissionName", Matchers.equalTo((Object)"READ"), new Object[0]).body("resourceName", Matchers.equalTo((Object)"exampleResource"), new Object[0]).body("resourceId", Matchers.equalTo(null), new Object[0]).body("authorized", Matchers.equalTo((Object)true), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", exampleGroups, (Permission)authorizationUtil, (Resource)authorizationUtil);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedFalse() {
        ArrayList exampleGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", exampleGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        AuthorizationUtil authorizationUtil = new AuthorizationUtil("exampleResource", 12345678, "READ");
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", exampleGroups, (Permission)authorizationUtil, (Resource)authorizationUtil)).thenReturn((Object)false);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("permissionName", Matchers.equalTo((Object)"READ"), new Object[0]).body("resourceName", Matchers.equalTo((Object)"exampleResource"), new Object[0]).body("resourceId", Matchers.equalTo(null), new Object[0]).body("authorized", Matchers.equalTo((Object)false), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", exampleGroups, (Permission)authorizationUtil, (Resource)authorizationUtil);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedResourceIdTrue() {
        ArrayList exampleGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", exampleGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        AuthorizationUtil authorizationUtil = new AuthorizationUtil("exampleResource", 12345678, "READ");
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", exampleGroups, (Permission)authorizationUtil, (Resource)authorizationUtil, "exampleResourceId")).thenReturn((Object)true);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).queryParam("resourceId", new Object[]{"exampleResourceId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("permissionName", Matchers.equalTo((Object)"READ"), new Object[0]).body("resourceName", Matchers.equalTo((Object)"exampleResource"), new Object[0]).body("resourceId", Matchers.equalTo((Object)"exampleResourceId"), new Object[0]).body("authorized", Matchers.equalTo((Object)true), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", exampleGroups, (Permission)authorizationUtil, (Resource)authorizationUtil, "exampleResourceId");
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedResourceIdFalse() {
        ArrayList exampleGroups = new ArrayList();
        Authentication authentication = new Authentication("userId", exampleGroups);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        AuthorizationUtil authorizationUtil = new AuthorizationUtil("exampleResource", 12345678, "READ");
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", exampleGroups, (Permission)authorizationUtil, (Resource)authorizationUtil, "exampleResourceId")).thenReturn((Object)false);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).queryParam("resourceId", new Object[]{"exampleResourceId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").body("permissionName", Matchers.equalTo((Object)"READ"), new Object[0]).body("resourceName", Matchers.equalTo((Object)"exampleResource"), new Object[0]).body("resourceId", Matchers.equalTo((Object)"exampleResourceId"), new Object[0]).body("authorized", Matchers.equalTo((Object)false), new Object[0]).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", exampleGroups, (Permission)authorizationUtil, (Resource)authorizationUtil, "exampleResourceId");
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testIsUserAuthorizedNoAuthentication() {
        ArrayList exampleGroups = new ArrayList();
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn(null);
        AuthorizationUtil authorizationUtil = new AuthorizationUtil("exampleResource", 12345678, "READ");
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", exampleGroups, (Permission)authorizationUtil, (Resource)authorizationUtil)).thenReturn((Object)false);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).then().expect().statusCode(Response.Status.UNAUTHORIZED.getStatusCode()).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).isUserAuthorized((String)org.mockito.Matchers.any(String.class), (List)org.mockito.Matchers.any(List.class), (Permission)org.mockito.Matchers.any(Permission.class), (Resource)org.mockito.Matchers.any(Resource.class));
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).isUserAuthorized((String)org.mockito.Matchers.any(String.class), (List)org.mockito.Matchers.any(List.class), (Permission)org.mockito.Matchers.any(Permission.class), (Resource)org.mockito.Matchers.any(Resource.class), (String)org.mockito.Matchers.any(String.class));
    }

    @Test
    public void testIsUserAuthorizedBadRequests() {
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceName", new Object[]{"exampleResource"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(AUTH_CHECK_PATH, new Object[0]);
        RestAssured.given().queryParam("permissionName", new Object[]{"READ"}).queryParam("resourceType", new Object[]{12345678}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(AUTH_CHECK_PATH, new Object[0]);
        RestAssured.given().queryParam("resourceName", new Object[]{"exampleResource"}).queryParam("resourceType", new Object[]{12345678}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(AUTH_CHECK_PATH, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.never())).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).isUserAuthorized((String)org.mockito.Matchers.any(String.class), (List)org.mockito.Matchers.any(List.class), (Permission)org.mockito.Matchers.any(Permission.class), (Resource)org.mockito.Matchers.any(Resource.class));
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).isUserAuthorized((String)org.mockito.Matchers.any(String.class), (List)org.mockito.Matchers.any(List.class), (Permission)org.mockito.Matchers.any(Permission.class), (Resource)org.mockito.Matchers.any(Resource.class), (String)org.mockito.Matchers.any(String.class));
    }

    @Test
    public void testCreateGlobalAuthorization() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        Mockito.when((Object)this.authorizationServiceMock.createNewAuthorization(0)).thenReturn((Object)authorization);
        Mockito.when((Object)this.authorizationServiceMock.saveAuthorization(authorization)).thenReturn((Object)authorization);
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.singleResult()).thenReturn((Object)authorization);
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization);
        RestAssured.given().body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(AUTH_CREATE_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).createNewAuthorization(0);
        ((Authorization)Mockito.verify((Object)authorization)).setUserId("*");
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)4))).setResourceType(authorization.getAuthorizationType());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setResourceId(authorization.getResourceId());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setPermissions(authorization.getPermissions((Permission[])Permissions.values()));
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).saveAuthorization(authorization);
    }

    @Test
    public void testCreateGrantAuthorization() {
        Authorization authorization = MockProvider.createMockGrantAuthorization();
        Mockito.when((Object)this.authorizationServiceMock.createNewAuthorization(1)).thenReturn((Object)authorization);
        Mockito.when((Object)this.authorizationServiceMock.saveAuthorization(authorization)).thenReturn((Object)authorization);
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.singleResult()).thenReturn((Object)authorization);
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization);
        RestAssured.given().body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(AUTH_CREATE_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).createNewAuthorization(1);
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setUserId(authorization.getUserId());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)4))).setResourceType(authorization.getAuthorizationType());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setResourceId(authorization.getResourceId());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setPermissions(authorization.getPermissions((Permission[])Permissions.values()));
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).saveAuthorization(authorization);
    }

    @Test
    public void testCreateRevokeAuthorization() {
        Authorization authorization = MockProvider.createMockRevokeAuthorization();
        Mockito.when((Object)this.authorizationServiceMock.createNewAuthorization(2)).thenReturn((Object)authorization);
        Mockito.when((Object)this.authorizationServiceMock.saveAuthorization(authorization)).thenReturn((Object)authorization);
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.singleResult()).thenReturn((Object)authorization);
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization);
        RestAssured.given().body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(AUTH_CREATE_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).createNewAuthorization(2);
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setUserId(authorization.getUserId());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)4))).setResourceType(authorization.getAuthorizationType());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setResourceId(authorization.getResourceId());
        ((Authorization)Mockito.verify((Object)authorization, (VerificationMode)Mockito.times((int)2))).setPermissions(authorization.getPermissions((Permission[])Permissions.values()));
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).saveAuthorization(authorization);
    }

    @Test
    public void testCreateAuthorizationThrowsAuthorizationException() {
        String message = "expected authorization exception";
        Mockito.when((Object)this.authorizationServiceMock.createNewAuthorization(1)).thenThrow(new Throwable[]{new AuthorizationException(message)});
        Authorization authorization = MockProvider.createMockGrantAuthorization();
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization);
        RestAssured.given().body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(AUTH_CREATE_PATH, new Object[0]);
    }

    @Test
    public void testSaveAuthorizationThrowsAuthorizationException() {
        String message = "expected authorization exception";
        Mockito.when((Object)this.authorizationServiceMock.saveAuthorization((Authorization)org.mockito.Matchers.any(Authorization.class))).thenThrow(new Throwable[]{new AuthorizationException(message)});
        Authorization authorization = MockProvider.createMockGrantAuthorization();
        Mockito.when((Object)this.authorizationServiceMock.createNewAuthorization(1)).thenReturn((Object)authorization);
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization);
        RestAssured.given().body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(AUTH_CREATE_PATH, new Object[0]);
    }

    @Test
    public void testDeleteAuthorization() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.singleResult()).thenReturn((Object)authorization);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(AUTH_RESOURCE_PATH, new Object[0]);
        ((AuthorizationQuery)Mockito.verify((Object)authorizationQuery)).authorizationId("someAuthorizationId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).deleteAuthorization("someAuthorizationId");
    }

    @Test
    public void testDeleteNonExistingAuthorization() {
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("message", Matchers.equalTo((Object)"Authorization with id someAuthorizationId does not exist."), new Object[0]).when().delete(AUTH_RESOURCE_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).deleteAuthorization("someAuthorizationId");
    }

    @Test
    public void testDeleteAuthorizationThrowsAuthorizationException() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.singleResult()).thenReturn((Object)authorization);
        String message = "expected authorization exception";
        ((AuthorizationService)Mockito.doThrow((Throwable)new AuthorizationException(message)).when((Object)this.authorizationServiceMock)).deleteAuthorization("someAuthorizationId");
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().delete(AUTH_RESOURCE_PATH, new Object[0]);
    }

    @Test
    public void testUpdateAuthorization() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.singleResult()).thenReturn((Object)authorization);
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(AUTH_RESOURCE_PATH, new Object[0]);
        ((AuthorizationQuery)Mockito.verify((Object)authorizationQuery)).authorizationId("someAuthorizationId");
        ((Authorization)Mockito.verify((Object)authorization)).setGroupId(dto.getGroupId());
        ((Authorization)Mockito.verify((Object)authorization)).setUserId(dto.getUserId());
        ((Authorization)Mockito.verify((Object)authorization)).setResourceId(dto.getResourceId());
        ((Authorization)Mockito.verify((Object)authorization)).setResourceType(dto.getResourceType().intValue());
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock)).saveAuthorization(authorization);
    }

    @Test
    public void testUpdateNonExistingAuthorization() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.singleResult()).thenReturn(null);
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("message", Matchers.equalTo((Object)"Authorization with id someAuthorizationId does not exist."), new Object[0]).when().put(AUTH_RESOURCE_PATH, new Object[0]);
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.never())).saveAuthorization(authorization);
    }

    @Test
    public void testUpdateAuthorizationThrowsAuthorizationException() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationDto dto = AuthorizationDto.fromAuthorization((Authorization)authorization);
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.singleResult()).thenReturn((Object)authorization);
        String message = "expected authorization exception";
        Mockito.when((Object)this.authorizationServiceMock.saveAuthorization((Authorization)org.mockito.Matchers.any(Authorization.class))).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").body((Object)dto).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(AUTH_RESOURCE_PATH, new Object[0]);
    }

    @Test
    public void testGetAuthorizationById() {
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.singleResult()).thenReturn((Object)authorization);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("id", Matchers.equalTo((Object)authorization.getId()), new Object[0]).body("type", Matchers.equalTo((Object)authorization.getAuthorizationType()), new Object[0]).body("permissions[0]", Matchers.equalTo((Object)Permissions.READ.getName()), new Object[0]).body("permissions[1]", Matchers.equalTo((Object)Permissions.UPDATE.getName()), new Object[0]).body("userId", Matchers.equalTo((Object)authorization.getUserId()), new Object[0]).body("groupId", Matchers.equalTo((Object)authorization.getGroupId()), new Object[0]).body("resourceType", Matchers.equalTo((Object)authorization.getResourceType()), new Object[0]).body("resourceId", Matchers.equalTo((Object)authorization.getResourceId()), new Object[0]).when().get(AUTH_RESOURCE_PATH, new Object[0]);
    }

    @Test
    public void testGetNonExistingAuthorizationById() {
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.singleResult()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("message", Matchers.equalTo((Object)"Authorization with id someAuthorizationId does not exist."), new Object[0]).when().get(AUTH_RESOURCE_PATH, new Object[0]);
    }

    @Test
    public void testAuthenticationRestServiceOptions() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + "/rest-test" + "/authorization";
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/count")), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"count"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/create")), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(SERVICE_PATH, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentAuthentication();
    }

    @Test
    public void testAuthenticationRestServiceOptionsWithAuthorizationDisabled() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + "/rest-test" + "/authorization";
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)false);
        RestAssured.given().then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"list"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/count")), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"count"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)(fullAuthorizationUrl + "/create")), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"POST"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"create"), new Object[0]).when().options(SERVICE_PATH, new Object[0]);
        this.verifyNoAuthorizationCheckPerformed();
    }

    @Test
    public void testAuthorizationResourceOptions() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + "/rest-test" + "/authorization" + "/" + "someAuthorizationId";
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.singleResult()).thenReturn((Object)authorization);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn(null);
        Mockito.when((Object)this.processEngineConfigurationMock.isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"update"), new Object[0]).when().options(AUTH_RESOURCE_PATH, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
    }

    @Test
    public void testAuthorizationResourceOptionsUnauthorized() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + "/rest-test" + "/authorization" + "/" + "someAuthorizationId";
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.singleResult()).thenReturn((Object)authorization);
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId")).thenReturn((Object)false);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId")).thenReturn((Object)false);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration().isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1]", Matchers.nullValue(), new Object[0]).body("links[2]", Matchers.nullValue(), new Object[0]).when().options(AUTH_RESOURCE_PATH, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId");
    }

    @Test
    public void testAuthorizationResourceOptionsUpdateUnauthorized() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + "/rest-test" + "/authorization" + "/" + "someAuthorizationId";
        Authorization authorization = MockProvider.createMockGlobalAuthorization();
        AuthorizationQuery authorizationQuery = (AuthorizationQuery)Mockito.mock(AuthorizationQuery.class);
        Mockito.when((Object)this.authorizationServiceMock.createAuthorizationQuery()).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.authorizationId("someAuthorizationId")).thenReturn((Object)authorizationQuery);
        Mockito.when((Object)authorizationQuery.singleResult()).thenReturn((Object)authorization);
        Authentication authentication = new Authentication("userId", null);
        Mockito.when((Object)this.identityServiceMock.getCurrentAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId")).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationServiceMock.isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId")).thenReturn((Object)false);
        Mockito.when((Object)processEngine.getProcessEngineConfiguration().isAuthorizationEnabled()).thenReturn((Object)true);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2]", Matchers.nullValue(), new Object[0]).when().options(AUTH_RESOURCE_PATH, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)2))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.DELETE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId");
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)1))).isUserAuthorized("userId", null, (Permission)Permissions.UPDATE, (Resource)Resources.AUTHORIZATION, "someAuthorizationId");
    }

    @Test
    public void testAuthorizationResourceOptionsWithAuthorizationDisabled() {
        String fullAuthorizationUrl = "http://localhost:" + PORT + "/rest-test" + "/authorization" + "/" + "someAuthorizationId";
        Mockito.when((Object)processEngine.getProcessEngineConfiguration().isAuthorizationEnabled()).thenReturn((Object)false);
        RestAssured.given().pathParam("id", (Object)"someAuthorizationId").then().statusCode(Response.Status.OK.getStatusCode()).body("links[0].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[0].method", Matchers.equalTo((Object)"GET"), new Object[0]).body("links[0].rel", Matchers.equalTo((Object)"self"), new Object[0]).body("links[1].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[1].method", Matchers.equalTo((Object)"DELETE"), new Object[0]).body("links[1].rel", Matchers.equalTo((Object)"delete"), new Object[0]).body("links[2].href", Matchers.equalTo((Object)fullAuthorizationUrl), new Object[0]).body("links[2].method", Matchers.equalTo((Object)"PUT"), new Object[0]).body("links[2].rel", Matchers.equalTo((Object)"update"), new Object[0]).when().options(AUTH_RESOURCE_PATH, new Object[0]);
        this.verifyNoAuthorizationCheckPerformed();
    }

    protected void verifyNoAuthorizationCheckPerformed() {
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock, (VerificationMode)Mockito.times((int)0))).getCurrentAuthentication();
        ((AuthorizationService)Mockito.verify((Object)this.authorizationServiceMock, (VerificationMode)Mockito.times((int)0))).isUserAuthorized(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyListOf(String.class), (Permission)org.mockito.Matchers.any(Permission.class), (Resource)org.mockito.Matchers.any(Resource.class));
    }
}

