/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.fest.assertions.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class CaseInstanceRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String CASE_INSTANCE_QUERY_URL = "/rest-test/case-instance";
    protected static final String CASE_INSTANCE_COUNT_QUERY_URL = "/rest-test/case-instance/count";
    private CaseInstanceQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockCaseInstanceQuery(MockProvider.createMockCaseInstances());
    }

    private CaseInstanceQuery setUpMockCaseInstanceQuery(List<CaseInstance> mockedCaseInstances) {
        CaseInstanceQuery query = (CaseInstanceQuery)Mockito.mock(CaseInstanceQuery.class);
        Mockito.when((Object)query.list()).thenReturn(mockedCaseInstances);
        Mockito.when((Object)query.count()).thenReturn((Object)mockedCaseInstances.size());
        Mockito.when((Object)processEngine.getCaseService().createCaseInstanceQuery()).thenReturn((Object)query);
        return query;
    }

    @Test
    public void testEmptyQuery() {
        String queryCaseInstanceId = "";
        RestAssured.given().queryParam("caseInstanceId", new Object[]{queryCaseInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testEmptyQueryAsPost() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("caseInstanceId", "");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryAsPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("caseInstanceId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"caseInstanceId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseInstanceId", "asc", Response.Status.OK);
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceId();
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseDefinitionKey", "asc", Response.Status.OK);
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionKey();
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseDefinitionId", "asc", Response.Status.OK);
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionId();
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseInstanceId", "desc", Response.Status.OK);
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceId();
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseDefinitionKey", "desc", Response.Status.OK);
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionKey();
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("caseDefinitionId", "desc", Response.Status.OK);
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionId();
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", OrderingBuilder.create().orderBy("caseInstanceId").desc().orderBy("caseDefinitionId").asc().getJson());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceId();
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionId();
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testCaseInstanceRetrieval() {
        String queryCaseInstanceId = "aCaseInstanceId";
        Response response = (Response)RestAssured.given().queryParam("caseInstanceId", new Object[]{queryCaseInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).caseInstanceId(queryCaseInstanceId);
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List caseInstances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)caseInstances).hasSize(1);
        Assertions.assertThat((Map)((Map)caseInstances.get(0))).isNotNull();
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("[0].caseDefinitionId");
        String returnedBusinessKeyKey = JsonPath.from((String)content).getString("[0].businessKey");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        boolean returnedActiveState = JsonPath.from((String)content).getBoolean("[0].active");
        boolean returnedCompletedState = JsonPath.from((String)content).getBoolean("[0].completed");
        boolean returnedTerminatedState = JsonPath.from((String)content).getBoolean("[0].terminated");
        Assertions.assertThat((String)returnedId).isEqualTo((Object)"aCaseInstId");
        Assertions.assertThat((String)returnedCaseDefinitionId).isEqualTo((Object)"aCaseDefinitionId");
        Assertions.assertThat((String)returnedBusinessKeyKey).isEqualTo((Object)"aBusinessKey");
        Assertions.assertThat((String)returnedTenantId).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((boolean)returnedActiveState).isEqualTo(true);
        Assertions.assertThat((boolean)returnedCompletedState).isEqualTo(true);
        Assertions.assertThat((boolean)returnedTerminatedState).isEqualTo(true);
    }

    @Test
    public void testCaseInstanceRetrievalAsPost() {
        String queryCaseInstanceId = "aCaseInstanceId";
        HashMap<String, String> queryParameter = new HashMap<String, String>();
        queryParameter.put("caseInstanceId", queryCaseInstanceId);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameter).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).caseInstanceId(queryCaseInstanceId);
        ((CaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List caseInstances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)caseInstances).hasSize(1);
        Assertions.assertThat((Map)((Map)caseInstances.get(0))).isNotNull();
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("[0].caseDefinitionId");
        String returnedBusinessKeyKey = JsonPath.from((String)content).getString("[0].businessKey");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        boolean returnedActiveState = JsonPath.from((String)content).getBoolean("[0].active");
        boolean returnedCompletedState = JsonPath.from((String)content).getBoolean("[0].completed");
        boolean returnedTerminatedState = JsonPath.from((String)content).getBoolean("[0].terminated");
        Assertions.assertThat((String)returnedId).isEqualTo((Object)"aCaseInstId");
        Assertions.assertThat((String)returnedCaseDefinitionId).isEqualTo((Object)"aCaseDefinitionId");
        Assertions.assertThat((String)returnedBusinessKeyKey).isEqualTo((Object)"aBusinessKey");
        Assertions.assertThat((String)returnedTenantId).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((boolean)returnedActiveState).isEqualTo(true);
        Assertions.assertThat((boolean)returnedCompletedState).isEqualTo(true);
        Assertions.assertThat((boolean)returnedTerminatedState).isEqualTo(true);
    }

    @Test
    public void testMultipleParameters() {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("caseInstanceId", "aCaseInstanceId");
        queryParameters.put("caseDefinitionId", "aCaseDefId");
        queryParameters.put("caseDefinitionKey", "aCaseDefKey");
        queryParameters.put("deploymentId", "aDeploymentId");
        queryParameters.put("businessKey", "aBusinessKey");
        queryParameters.put("superProcessInstance", "aSuperProcInstId");
        queryParameters.put("subProcessInstance", "aSubProcInstId");
        queryParameters.put("superCaseInstance", "aSuperCaseInstId");
        queryParameters.put("subCaseInstance", "aSubCaseInstId");
        queryParameters.put("tenantIdIn", "aTenantId");
        queryParameters.put("active", "true");
        queryParameters.put("completed", "true");
        queryParameters.put("terminated", "true");
        RestAssured.given().queryParams(queryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId((String)queryParameters.get("caseInstanceId"));
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionId((String)queryParameters.get("caseDefinitionId"));
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionKey((String)queryParameters.get("caseDefinitionKey"));
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).deploymentId((String)queryParameters.get("deploymentId"));
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceBusinessKey((String)queryParameters.get("businessKey"));
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).superProcessInstanceId((String)queryParameters.get("superProcessInstance"));
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).subProcessInstanceId((String)queryParameters.get("subProcessInstance"));
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).superCaseInstanceId((String)queryParameters.get("superCaseInstance"));
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).subCaseInstanceId((String)queryParameters.get("subCaseInstance"));
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{(String)queryParameters.get("tenantIdIn")});
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).active();
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).completed();
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).terminated();
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testMultipleParametersAsPost() {
        String aCaseInstanceId = "aCaseInstanceId";
        String aCaseDefId = "aCaseDefId";
        String aCaseDefKey = "aCaseDefKey";
        String aDeploymentId = "aDeploymentId";
        String aBusinessKey = "aBusinessKey";
        String aSuperProcInstId = "aSuperProcInstId";
        String aSubProcInstId = "aSubProcInstId";
        String aSuperCaseInstId = "aSuperCaseInstId";
        String aSubCaseInstId = "aSubCaseInstId";
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("caseInstanceId", aCaseInstanceId);
        queryParameters.put("caseDefinitionId", aCaseDefId);
        queryParameters.put("caseDefinitionKey", aCaseDefKey);
        queryParameters.put("deploymentId", aDeploymentId);
        queryParameters.put("businessKey", aBusinessKey);
        queryParameters.put("superProcessInstance", aSuperProcInstId);
        queryParameters.put("subProcessInstance", aSubProcInstId);
        queryParameters.put("superCaseInstance", aSuperCaseInstId);
        queryParameters.put("subCaseInstance", aSubCaseInstId);
        queryParameters.put("active", "true");
        queryParameters.put("completed", "true");
        queryParameters.put("terminated", "true");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId(aCaseInstanceId);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionId(aCaseDefId);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionKey(aCaseDefKey);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).deploymentId(aDeploymentId);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceBusinessKey(aBusinessKey);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).superProcessInstanceId(aSuperProcInstId);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).subProcessInstanceId(aSubProcInstId);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).superCaseInstanceId(aSuperCaseInstId);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).subCaseInstanceId(aSubCaseInstId);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).active();
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).completed();
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).terminated();
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testVariableParameters() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        queryValue = variableName + "_gt_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThan(variableName, (Object)variableValue);
        queryValue = variableName + "_gteq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThanOrEqual(variableName, (Object)variableValue);
        queryValue = variableName + "_lt_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThan(variableName, (Object)variableValue);
        queryValue = variableName + "_lteq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThanOrEqual(variableName, (Object)variableValue);
        queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(variableName, variableValue);
        queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableParametersAsPost() {
        String variableName = "varName";
        String variableValue = "varValue";
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        variableJson.put("operator", "gt");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThan(variableName, (Object)variableValue);
        variableJson.put("operator", "gteq");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThanOrEqual(variableName, (Object)variableValue);
        variableJson.put("operator", "lt");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThan(variableName, (Object)variableValue);
        variableJson.put("operator", "lteq");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThanOrEqual(variableName, (Object)variableValue);
        variableJson.put("operator", "like");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(variableName, variableValue);
        variableJson.put("operator", "neq");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testMultipleVariableParameters() {
        String variableName1 = "varName";
        String variableValue1 = "varValue";
        String variableParameter1 = variableName1 + "_eq_" + variableValue1;
        String variableName2 = "anotherVarName";
        String variableValue2 = "anotherVarValue";
        String variableParameter2 = variableName2 + "_neq_" + variableValue2;
        String queryValue = variableParameter1 + "," + variableParameter2;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName1, (Object)variableValue1);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName2, (Object)variableValue2);
    }

    @Test
    public void testMultipleVariableParametersAsPost() {
        String variableName = "varName";
        String variableValue = "varValue";
        String anotherVariableName = "anotherVarName";
        Integer anotherVariableValue = 30;
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        HashMap<String, Object> anotherVariableJson = new HashMap<String, Object>();
        anotherVariableJson.put("name", anotherVariableName);
        anotherVariableJson.put("operator", "neq");
        anotherVariableJson.put("value", anotherVariableValue);
        ArrayList<HashMap<String, Object>> variables = new ArrayList<HashMap<String, Object>>();
        variables.add(variableJson);
        variables.add(anotherVariableJson);
        HashMap<String, ArrayList<HashMap<String, Object>>> json = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals((String)org.mockito.Matchers.eq((Object)anotherVariableName), org.mockito.Matchers.argThat((Matcher)EqualsPrimitiveValue.numberValue(anotherVariableValue)));
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(CASE_INSTANCE_COUNT_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testQueryCountAsPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(CASE_INSTANCE_COUNT_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockCaseInstanceQuery(this.createMockCaseInstancesTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List caseInstances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)caseInstances).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testWithoutTenantIdParameter() {
        this.mockedQuery = this.setUpMockCaseInstanceQuery(Arrays.asList(MockProvider.createMockCaseInstance(null)));
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List caseInstances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)caseInstances).hasSize(1);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
    }

    @Test
    public void testTenantIdListPostParameter() {
        this.mockedQuery = this.setUpMockCaseInstanceQuery(this.createMockCaseInstancesTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List caseInstances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)caseInstances).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testWithoutTenantIdPostParameter() {
        this.mockedQuery = this.setUpMockCaseInstanceQuery(Arrays.asList(MockProvider.createMockCaseInstance(null)));
        HashMap<String, Boolean> queryParameters = new HashMap<String, Boolean>();
        queryParameters.put("withoutTenantId", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(CASE_INSTANCE_QUERY_URL, new Object[0]);
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((CaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List caseInstances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)caseInstances).hasSize(1);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
    }

    private List<CaseInstance> createMockCaseInstancesTwoTenants() {
        return Arrays.asList(MockProvider.createMockCaseInstance("aTenantId"), MockProvider.createMockCaseInstance("anotherTenantId"));
    }
}

