/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.fest.assertions.Assertions;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class JobDefinitionRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String JOB_DEFINITION_QUERY_URL = "/rest-test/job-definition";
    protected static final String JOB_DEFINITION_COUNT_QUERY_URL = "/rest-test/job-definition/count";
    private JobDefinitionQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockDefinitionQuery(MockProvider.createMockJobDefinitions());
    }

    private JobDefinitionQuery setUpMockDefinitionQuery(List<JobDefinition> mockedJobDefinitions) {
        JobDefinitionQuery query = (JobDefinitionQuery)Mockito.mock(JobDefinitionQuery.class);
        Mockito.when((Object)query.list()).thenReturn(mockedJobDefinitions);
        Mockito.when((Object)query.count()).thenReturn((Object)mockedJobDefinitions.size());
        Mockito.when((Object)processEngine.getManagementService().createJobDefinitionQuery()).thenReturn((Object)query);
        return query;
    }

    @Test
    public void testEmptyQuery() {
        String queryJobDefinitionId = "";
        RestAssured.given().queryParam("jobDefinitionId", new Object[]{queryJobDefinitionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testEmptyQueryAsPost() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jobDefinitionId", "");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryAsPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("jobDefinitionId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(JOB_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"jobDefinitionId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(JOB_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(JOB_DEFINITION_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobDefinitionId", "asc", Response.Status.OK);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobDefinitionId();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityId", "asc", Response.Status.OK);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityId();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionId", "asc", Response.Status.OK);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionKey", "asc", Response.Status.OK);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionKey();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobType", "asc", Response.Status.OK);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobType();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobConfiguration", "asc", Response.Status.OK);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobConfiguration();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobDefinitionId", "desc", Response.Status.OK);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobDefinitionId();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityId", "desc", Response.Status.OK);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityId();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionId", "desc", Response.Status.OK);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("processDefinitionKey", "desc", Response.Status.OK);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionKey();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobType", "desc", Response.Status.OK);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobType();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("jobConfiguration", "desc", Response.Status.OK);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobConfiguration();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", OrderingBuilder.create().orderBy("jobType").desc().orderBy("jobConfiguration").asc().getJson());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobType();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).orderByJobConfiguration();
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testJobDefinitionRetrieval() {
        String queryJobDefinitionId = "aJobDefId";
        Response response = (Response)RestAssured.given().queryParam("jobDefinitionId", new Object[]{queryJobDefinitionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOB_DEFINITION_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).jobDefinitionId(queryJobDefinitionId);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List jobDefinitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)jobDefinitions).hasSize(1);
        Assertions.assertThat((Map)((Map)jobDefinitions.get(0))).isNotNull();
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        String returnedActivityId = JsonPath.from((String)content).getString("[0].activityId");
        String returnedJobType = JsonPath.from((String)content).getString("[0].jobType");
        String returnedJobConfiguration = JsonPath.from((String)content).getString("[0].jobConfiguration");
        boolean returnedSuspensionState = JsonPath.from((String)content).getBoolean("[0].suspended");
        Long returnedJobPriority = (Long)JsonPath.from((String)content).getObject("[0].overridingJobPriority", Long.class);
        Assertions.assertThat((String)returnedId).isEqualTo((Object)"aJobDefId");
        Assertions.assertThat((String)returnedProcessDefinitionId).isEqualTo((Object)"aProcDefId");
        Assertions.assertThat((String)returnedProcessDefinitionKey).isEqualTo((Object)"aKey");
        Assertions.assertThat((String)returnedActivityId).isEqualTo((Object)"anActivity");
        Assertions.assertThat((String)returnedJobType).isEqualTo((Object)"aJobType");
        Assertions.assertThat((String)returnedJobConfiguration).isEqualTo((Object)"aJobConfig");
        Assertions.assertThat((boolean)returnedSuspensionState).isEqualTo(true);
        Assertions.assertThat((Long)returnedJobPriority).isEqualTo(0x80000033L);
    }

    @Test
    public void testJobDefinitionRetrievalAsPost() {
        String queryJobDefinitionId = "aJobDefId";
        HashMap<String, String> queryParameter = new HashMap<String, String>();
        queryParameter.put("jobDefinitionId", queryJobDefinitionId);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameter).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOB_DEFINITION_QUERY_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).jobDefinitionId(queryJobDefinitionId);
        ((JobDefinitionQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List jobDefinitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)jobDefinitions).hasSize(1);
        Assertions.assertThat((Map)((Map)jobDefinitions.get(0))).isNotNull();
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        String returnedActivityId = JsonPath.from((String)content).getString("[0].activityId");
        String returnedJobType = JsonPath.from((String)content).getString("[0].jobType");
        String returnedJobConfiguration = JsonPath.from((String)content).getString("[0].jobConfiguration");
        boolean returnedSuspensionState = JsonPath.from((String)content).getBoolean("[0].suspended");
        Assertions.assertThat((String)returnedId).isEqualTo((Object)"aJobDefId");
        Assertions.assertThat((String)returnedProcessDefinitionId).isEqualTo((Object)"aProcDefId");
        Assertions.assertThat((String)returnedProcessDefinitionKey).isEqualTo((Object)"aKey");
        Assertions.assertThat((String)returnedActivityId).isEqualTo((Object)"anActivity");
        Assertions.assertThat((String)returnedJobType).isEqualTo((Object)"aJobType");
        Assertions.assertThat((String)returnedJobConfiguration).isEqualTo((Object)"aJobConfig");
        Assertions.assertThat((boolean)returnedSuspensionState).isEqualTo(true);
    }

    @Test
    public void testMultipleParameters() {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("jobDefinitionId", "aJobDefId");
        queryParameters.put("processDefinitionId", "aProcDefId");
        queryParameters.put("processDefinitionKey", "aProcDefKey");
        queryParameters.put("activityIdIn", "aActId,anotherActId");
        queryParameters.put("jobType", "aJobType");
        queryParameters.put("jobConfiguration", "aJobConfig");
        queryParameters.put("suspended", "true");
        queryParameters.put("active", "true");
        queryParameters.put("withOverridingJobPriority", "true");
        RestAssured.given().queryParams(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).jobDefinitionId((String)queryParameters.get("jobDefinitionId"));
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId((String)queryParameters.get("processDefinitionId"));
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey((String)queryParameters.get("processDefinitionKey"));
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).activityIdIn(new String[]{"aActId", "anotherActId"});
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).jobType((String)queryParameters.get("jobType"));
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).jobConfiguration((String)queryParameters.get("jobConfiguration"));
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).active();
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).suspended();
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).withOverridingJobPriority();
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testMultipleParametersAsPost() {
        String aJobDefId = "aJobDefId";
        String aProcDefId = "aProcDefId";
        String aProcDefKey = "aProcDefKey";
        String aActId = "aActId";
        String anotherActId = "anotherActId";
        String aJobType = "aJobType";
        String aJobConfig = "aJobConfig";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("jobDefinitionId", aJobDefId);
        queryParameters.put("processDefinitionId", aProcDefId);
        queryParameters.put("processDefinitionKey", aProcDefKey);
        queryParameters.put("jobType", aJobType);
        queryParameters.put("jobConfiguration", aJobConfig);
        queryParameters.put("suspended", "true");
        queryParameters.put("active", "true");
        queryParameters.put("withOverridingJobPriority", "true");
        ArrayList<String> activityIdIn = new ArrayList<String>();
        activityIdIn.add(aActId);
        activityIdIn.add(anotherActId);
        queryParameters.put("activityIdIn", activityIdIn);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).jobDefinitionId(aJobDefId);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(aProcDefId);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey(aProcDefKey);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).activityIdIn(new String[]{aActId, anotherActId});
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).jobType(aJobType);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).jobConfiguration(aJobConfig);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).active();
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).suspended();
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).withOverridingJobPriority();
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(JOB_DEFINITION_COUNT_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testQueryCountAsPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(JOB_DEFINITION_COUNT_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockDefinitionQuery(this.createMockJobDefinitionsTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List jobs = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)jobs).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testWithoutTenantIdParameter() {
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List jobs = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)jobs).hasSize(1);
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    @Test
    public void testIncludeJobDefinitionsWithoutTenantIdParameter() {
        List<JobDefinition> jobDefinitions = Arrays.asList(MockProvider.mockJobDefinition().tenantId(null).build(), MockProvider.mockJobDefinition().tenantId("aTenantId").build());
        this.mockedQuery = this.setUpMockDefinitionQuery(jobDefinitions);
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId"}).queryParam("includeJobDefinitionsWithoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId"});
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).includeJobDefinitionsWithoutTenantId();
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"aTenantId");
    }

    @Test
    public void testTenantIdListPostParameter() {
        this.mockedQuery = this.setUpMockDefinitionQuery(this.createMockJobDefinitionsTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List jobs = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)jobs).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testWithoutTenantIdPostParameter() {
        HashMap<String, Boolean> queryParameters = new HashMap<String, Boolean>();
        queryParameters.put("withoutTenantId", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List jobs = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)jobs).hasSize(1);
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    @Test
    public void testIncludeJobDefinitionsWithoutTenantIdPostParameter() {
        List<JobDefinition> jobDefinitions = Arrays.asList(MockProvider.mockJobDefinition().tenantId(null).build(), MockProvider.mockJobDefinition().tenantId("aTenantId").build());
        this.mockedQuery = this.setUpMockDefinitionQuery(jobDefinitions);
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("tenantIdIn", new String[]{"aTenantId"});
        queryParameters.put("includeJobDefinitionsWithoutTenantId", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(JOB_DEFINITION_QUERY_URL, new Object[0]);
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId"});
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).includeJobDefinitionsWithoutTenantId();
        ((JobDefinitionQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"aTenantId");
    }

    private List<JobDefinition> createMockJobDefinitionsTwoTenants() {
        return Arrays.asList(MockProvider.mockJobDefinition().tenantId("aTenantId").build(), MockProvider.mockJobDefinition().tenantId("anotherTenantId").build());
    }
}

